/*
 * Decompiled with CFR 0.152.
 */
package loci;

public class loci {
    String ID;
    String chr;
    String strand;
    int loci_start;
    int loci_stop;
    int numReads;
    String seq;
    boolean prefix_matching;

    public loci(String ID, String chr, String strand, int loci_start, int loci_stop, String seq, boolean prefix_matching) {
        this.ID = ID;
        this.chr = chr;
        this.strand = strand;
        this.loci_start = loci_start;
        this.loci_stop = loci_stop;
        this.seq = seq;
        this.prefix_matching = prefix_matching;
        this.numReads = 1;
    }

    public loci(String chr1, String strand1, int start1, int stop1, String seq1) {
        this.chr = chr1;
        this.strand = strand1;
        this.loci_start = start1;
        this.loci_stop = stop1;
        this.seq = seq1;
        this.numReads = 1;
    }

    public loci() {
        this.chr = "none";
        this.strand = "+";
        this.loci_start = -1;
        this.loci_stop = -1;
        this.numReads = 0;
    }

    public loci(String ID1, String chr1, String strand1, int loci_start1, int loci_stop1, int numReads1) {
        this.ID = ID1;
        this.chr = chr1;
        this.strand = strand1;
        this.loci_start = loci_start1;
        this.loci_stop = loci_stop1;
        this.numReads = numReads1;
    }

    public loci(String ID1, String chr1, String strand1, int loci_start1, int loci_stop1) {
        this.ID = ID1;
        this.chr = chr1;
        this.strand = strand1;
        this.loci_start = loci_start1;
        this.loci_stop = loci_stop1;
        this.numReads = 1;
    }

    public loci(String chr1, String strand1, int loci_start1, int loci_stop1, int numReads1) {
        this.chr = chr1;
        this.strand = strand1;
        this.loci_start = loci_start1;
        this.loci_stop = loci_stop1;
        this.numReads = numReads1;
    }

    public loci(String chr1, String strand1, int loci_start1, int loci_stop1, String seq1, int numReads1) {
        this.chr = chr1;
        this.strand = strand1;
        this.loci_start = loci_start1;
        this.loci_stop = loci_stop1;
        this.seq = seq1;
        this.numReads = numReads1;
    }

    public loci(String chr1, String strand1, int loci_start1, int loci_stop1) {
        this.chr = chr1;
        this.strand = strand1;
        this.loci_start = loci_start1;
        this.loci_stop = loci_stop1;
        this.numReads = 1;
    }

    public loci(String chr1, int loci_start1, int loci_stop1) {
        this.chr = chr1;
        this.loci_start = loci_start1;
        this.loci_stop = loci_stop1;
        this.numReads = 1;
    }

    public loci(loci rec1) {
        this.ID = rec1.ID;
        this.chr = rec1.chr;
        this.strand = rec1.strand;
        this.loci_start = rec1.loci_start;
        this.loci_stop = rec1.loci_stop;
        this.numReads = rec1.numReads;
        this.seq = rec1.seq;
    }

    public void update(String chr1, String strand1, int loci_start1, int loci_stop1, int numReads1) {
        this.chr = chr1;
        this.strand = strand1;
        this.loci_start = loci_start1;
        this.loci_stop = loci_stop1;
        this.numReads = numReads1;
    }

    public void update(String chr1, String strand1, int loci_start1, int loci_stop1, String seq1, int numReads1) {
        this.chr = chr1;
        this.strand = strand1;
        this.loci_start = loci_start1;
        this.loci_stop = loci_stop1;
        this.seq = seq1;
        this.numReads = numReads1;
    }

    public void update(String chr1, String strand1, int loci_start1, int loci_stop1) {
        this.chr = chr1;
        this.strand = strand1;
        this.loci_start = loci_start1;
        this.loci_stop = loci_stop1;
        this.numReads = 1;
    }

    public void clear() {
        this.chr = "";
        this.strand = "";
        this.loci_start = -1;
        this.loci_stop = -1;
        this.numReads = -1;
    }

    public void increase() {
        ++this.numReads;
    }

    public void set_ID(String _ID) {
        this.ID = _ID;
    }

    public void setloci_start(int start1) {
        this.loci_start = start1;
    }

    public void setloci_stop(int stop1) {
        this.loci_stop = stop1;
    }

    public void setstrand(String strand1) {
        this.strand = strand1;
    }

    public void setseq(String seq1) {
        this.seq = seq1;
    }

    public void setnumReads(int numReads1) {
        this.numReads = numReads1;
    }

    public boolean isSameStart(String chr1, String strand1, int loci_start1) {
        return this.chr.equalsIgnoreCase(chr1) && this.strand.equals(strand1) && this.loci_start == loci_start1;
    }

    public boolean isOverlapped(String chr1, String strand1, int loci_start1) {
        return this.chr.equalsIgnoreCase(chr1) && this.strand.equals(strand1) && this.loci_stop >= loci_start1;
    }

    public boolean isOverlapped(loci l) {
        return this.chr.equalsIgnoreCase(l.getChr()) && this.strand.equals(l.getstrand()) && (this.loci_stop >= l.getstart_loci() && this.loci_start <= l.getstop_loci() || l.getstart_loci() < this.loci_stop && l.getstop_loci() >= this.loci_start);
    }

    public boolean isOverlapped_base_0(loci l) {
        return this.chr.equalsIgnoreCase(l.getChr()) && this.strand.equals(l.getstrand()) && (this.loci_stop > l.getstart_loci() && this.loci_start < l.getstop_loci() || l.getstart_loci() < this.loci_stop && l.getstop_loci() > this.loci_start);
    }

    public boolean equal(String chr1, String strand1, int loci_start1, int loci_stop1) {
        return this.chr.equalsIgnoreCase(chr1) && this.strand.equals(strand1) && this.loci_start == loci_start1 && this.loci_stop == loci_stop1;
    }

    public boolean contain(String chr1, String strand1, int loci_start1, int loci_stop1) {
        return this.chr.equalsIgnoreCase(chr1) && this.strand.equals(strand1) && this.loci_start <= loci_start1 && this.loci_stop >= loci_stop1;
    }

    public boolean contain(loci loci2) {
        return this.chr.equalsIgnoreCase(loci2.chr) && this.strand.equals(loci2.strand) && this.loci_start <= loci2.loci_start && this.loci_stop >= loci2.loci_stop;
    }

    public int compare(loci rec) {
        if (this.chr.compareToIgnoreCase(rec.chr) == 0) {
            if (this.strand.equals("+") && rec.strand.equals("-")) {
                return 1;
            }
            if (this.strand.equals("-") && rec.strand.equals("+")) {
                return -1;
            }
            if (this.loci_start > rec.loci_stop) {
                return 1;
            }
            if (this.loci_stop < rec.loci_start) {
                return -1;
            }
            return 0;
        }
        return this.chr.compareToIgnoreCase(rec.chr);
    }

    public String getID() {
        return this.ID;
    }

    public String getChr() {
        return this.chr;
    }

    public String getstrand() {
        return this.strand;
    }

    public int getstart_loci() {
        return this.loci_start;
    }

    public int getstop_loci() {
        return this.loci_stop;
    }

    public int get_len() {
        return this.loci_stop - this.loci_start + 1;
    }

    public String getseq() {
        return this.seq;
    }

    public int getnumReads() {
        return this.numReads;
    }

    public boolean get_prefix_matching() {
        return this.prefix_matching;
    }

    public String toPrefixSuffixString() {
        String pre_suf = this.prefix_matching ? "prefix" : "suffix";
        return this.chr + "\t" + this.strand + "\t" + Integer.toString(this.loci_start) + "\t" + Integer.toString(this.loci_stop) + "\t" + Integer.toString(this.loci_stop - this.loci_start + 1) + "\t" + this.seq + "\t" + this.ID + "\t" + pre_suf;
    }

    public String toMyString() {
        return this.chr + "\t" + this.strand + "\t" + Integer.toString(this.loci_start) + "\t" + Integer.toString(this.loci_stop) + "\t" + Integer.toString(this.loci_stop - this.loci_start + 1) + "\t" + Integer.toString(this.numReads);
    }

    public String toString() {
        return this.chr + "\t" + this.strand + "\t" + Integer.toString(this.loci_start) + "\t" + Integer.toString(this.loci_stop) + "\t" + Integer.toString(this.loci_stop - this.loci_start + 1);
    }

    public String toSimpleString() {
        return this.chr + this.strand + Integer.toString(this.loci_start) + "-" + Integer.toString(this.loci_stop);
    }

    public String toSimpleStringWithNumReads() {
        return this.chr + this.strand + Integer.toString(this.loci_start) + "-" + Integer.toString(this.loci_stop) + "|" + this.numReads;
    }

    public boolean checkIfNumber(String in) {
        try {
            Integer.parseInt(in);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static boolean isRevComplementary(String seq1, String seq2) {
        if (seq1.length() != seq2.length()) {
            return false;
        }
        int len = seq1.length();
        seq1 = seq1.toUpperCase().replace("A", "1").replace("C", "2").replace("G", "3").replace("T", "4").replace("U", "4");
        seq2 = seq2.toUpperCase().replace("A", "1").replace("C", "2").replace("G", "3").replace("T", "4").replace("U", "4");
        for (int i = 0; i < seq1.length(); ++i) {
            if (seq1.charAt(i) - 48 + seq2.charAt(len - i - 1) - 48 == 5) continue;
            return false;
        }
        return true;
    }

    public static String toMinusStrand(String seq) {
        String reverse = new StringBuffer(seq).reverse().toString();
        return reverse.replace("c", "@").replace("g", "c").replace("@", "g").replace("a", "#").replace("t", "a").replace("#", "t").replace("C", "$").replace("G", "C").replace("$", "G").replace("A", "%").replace("T", "A").replace("%", "T");
    }

    public static boolean isIntNumber(String num) {
        try {
            Integer.parseInt(num);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        return string.matches("^[-+]?\\d+(\\.\\d+)?$");
    }
}

