/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.picard.vcf.VariantContextIterator;
import net.sf.picard.vcf.VariantContextIteratorFactory;
import net.sf.samtools.util.CloserUtil;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;

public class VcfFormatConverter
extends CommandLineProgram {
    public static final Log LOG = Log.getInstance(VcfFormatConverter.class);
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Convert a VCF file to a BCF file, or BCF to VCF.\n" + "" + "Input and output formats are determined by file extension.";
    @Option(doc="The BCF or VCF file to parse.", shortName="I")
    public File INPUT;
    @Option(doc="The BCF or VCF output file. ", shortName="O")
    public File OUTPUT;

    public static void main(String[] argv) {
        new VcfFormatConverter().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        ProgressLogger progress = new ProgressLogger(LOG, 10000);
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        VariantContextIterator readerIterator = VariantContextIteratorFactory.create(this.INPUT);
        VariantContextWriter writer = VariantContextWriterFactory.create((File)this.OUTPUT, null);
        writer.writeHeader(readerIterator.getHeader());
        while (readerIterator.hasNext()) {
            VariantContext v = (VariantContext)readerIterator.next();
            writer.add(v);
            progress.record(v.getChr(), v.getStart());
        }
        CloserUtil.close((Object)readerIterator);
        CloserUtil.close((Object)writer);
        return 0;
    }
}

