/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.picard.vcf.VariantContextIterator;
import net.sf.picard.vcf.VariantContextIteratorFactory;
import net.sf.picard.vcf.VariantContextUtils;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFHeader;

public class MakeSitesOnlyVcf
extends CommandLineProgram {
    @Option(shortName="I", doc="Input VCF or BCF")
    public File INPUT;
    @Option(shortName="O", doc="Output VCF or BCF to emit without per-sample info.")
    public File OUTPUT;
    @Option(shortName="SD", doc="Sequence dictionary to use when indexing the VCF.")
    public File SEQUENCE_DICTIONARY;
    private static final Set<String> NO_SAMPLES = Collections.emptySet();

    public static void main(String[] args) {
        new MakeSitesOnlyVcf().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsReadable(this.SEQUENCE_DICTIONARY);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        VariantContextIterator in = VariantContextIteratorFactory.create(this.INPUT);
        VariantContextWriter out = VariantContextWriterFactory.create((File)this.OUTPUT, (SAMSequenceDictionary)VariantContextUtils.getSequenceDictionary(this.SEQUENCE_DICTIONARY));
        VCFHeader header = new VCFHeader(in.getHeader());
        out.writeHeader(header);
        ProgressLogger progress = new ProgressLogger(Log.getInstance(MakeSitesOnlyVcf.class), 10000);
        while (in.hasNext()) {
            VariantContext ctx = (VariantContext)in.next();
            out.add(ctx.subContextFromSamples(NO_SAMPLES, false));
            progress.record(ctx.getChr(), ctx.getStart());
        }
        out.close();
        in.close();
        return 0;
    }
}

