/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.log4j.Logger;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.util.SnapshotFileChooser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SnapshotUtilities {
    private static Logger log = Logger.getLogger(SnapshotUtilities.class);
    public static int DEFAULT_MAX_PANEL_HEIGHT = 1000;
    private static ThreadLocal<Integer> maxPanelHeight = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(DEFAULT_MAX_PANEL_HEIGHT);
        }
    };

    public static int getMaxPanelHeight() {
        return maxPanelHeight.get();
    }

    public static void setMaxPanelHeight(int h) {
        maxPanelHeight.set(h);
    }

    private SnapshotUtilities() {
    }

    public static String doComponentSnapshot(Component component, File file, SnapshotFileChooser.SnapshotFileType type, boolean paintOffscreen) throws IOException {
        if (paintOffscreen && !(component instanceof Paintable)) {
            log.error((Object)"Component cannot be painted offscreen. Performing onscreen paint");
            paintOffscreen = false;
        }
        if (paintOffscreen) {
            Rectangle rect = component.getBounds();
            rect.height = component instanceof MainPanel ? ((MainPanel)component).getOffscreenImageHeight() : Math.min(component.getHeight(), SnapshotUtilities.getMaxPanelHeight());
            int dx = rect.x;
            int dy = rect.y;
            rect.x = 0;
            rect.y = 0;
            rect.width -= dx;
            rect.height -= dy;
            component.setBounds(rect);
        }
        int width = component.getWidth();
        int height = component.getHeight();
        String format = null;
        String[] exts = null;
        switch (type) {
            case SVG: {
                SnapshotUtilities.exportScreenshotSVG(component, file, paintOffscreen);
                break;
            }
            case JPEG: {
                format = "jpeg";
                exts = new String[]{".jpg", ".jpeg"};
                break;
            }
            case PNG: {
                format = "png";
                exts = new String[]{"." + format};
            }
        }
        if (format != null && exts != null) {
            SnapshotUtilities.exportScreenShotBufferedImage(component, file, width, height, exts, format, paintOffscreen);
        }
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportScreenshotSVG(Component target, File selectedFile, boolean paintOffscreen) throws IOException {
        String format = "svg";
        selectedFile = SnapshotUtilities.fixFileExt(selectedFile, new String[]{format}, format);
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, format, null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        SnapshotUtilities.choosePaint(target, (Graphics2D)svgGenerator, paintOffscreen);
        Writer out = null;
        try {
            boolean useCSS = true;
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(selectedFile), "UTF-8"));
            svgGenerator.stream(out, useCSS);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing svg file", (Throwable)e);
                }
            }
        }
    }

    private static void choosePaint(Component target, Graphics2D g, boolean paintOffscreen) {
        log.debug((Object)("Painting to target " + target + " , offscreen " + paintOffscreen));
        if (paintOffscreen) {
            ((Paintable)((Object)target)).paintOffscreen(g, target.getBounds());
        } else {
            target.paintAll(g);
        }
    }

    private static void exportScreenShotBufferedImage(Component target, File selectedFile, int width, int height, String[] allowedExts, String format, boolean paintOffscreen) throws IOException {
        BufferedImage image = SnapshotUtilities.getDeviceCompatibleImage(width, height);
        Graphics2D g = image.createGraphics();
        SnapshotUtilities.choosePaint(target, g, paintOffscreen);
        selectedFile = SnapshotUtilities.fixFileExt(selectedFile, allowedExts, format);
        if (selectedFile != null) {
            log.debug((Object)("Writing image to " + selectedFile.getAbsolutePath()));
            ImageIO.write((RenderedImage)image, format, selectedFile);
        }
    }

    private static File fixFileExt(File selectedFile, String[] allowedExts, String defExtension) {
        boolean hasExt = false;
        if (selectedFile != null) {
            for (String ext : allowedExts) {
                if (!selectedFile.getName().toLowerCase().endsWith(ext)) continue;
                hasExt = true;
                break;
            }
            if (!hasExt) {
                String addExt = defExtension.startsWith(".") ? defExtension : "." + defExtension;
                String correctedFilename = selectedFile.getAbsolutePath() + addExt;
                selectedFile = new File(correctedFilename);
            }
        }
        return selectedFile;
    }

    public static BufferedImage getDeviceCompatibleImage(int width, int height) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice screenDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicConfiguration = screenDevice.getDefaultConfiguration();
        BufferedImage image = graphicConfiguration.createCompatibleImage(width, height);
        return image;
    }
}

