/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.Globals;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionMenu;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.blat.BlatClient;

public class RegionOfInterestPanel
extends JPanel {
    PopupMenu popup;
    ReferenceFrame frame;
    private static RegionOfInterest selectedRegion = null;

    public RegionOfInterestPanel(ReferenceFrame frame) {
        this.setToolTipText("Regions of Interest");
        this.frame = frame;
        ROIMouseAdapater ma = new ROIMouseAdapater();
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawRegionsOfInterest((Graphics2D)g, this.getHeight());
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void drawRegionsOfInterest(Graphics2D g, int height) {
        Collection<RegionOfInterest> regions = this.getRegions();
        if (regions == null || regions.isEmpty()) {
            return;
        }
        for (RegionOfInterest regionOfInterest : regions) {
            int regionStart = regionOfInterest.getStart();
            int regionEnd = regionOfInterest.getEnd();
            if (this.frame.getChrName().equals("All")) {
                Genome genome = GenomeManager.getInstance().getCurrentGenome();
                regionStart = genome.getGenomeCoordinate(regionOfInterest.getChr(), regionStart);
                regionEnd = genome.getGenomeCoordinate(regionOfInterest.getChr(), regionEnd);
            }
            int start = this.frame.getScreenPosition(regionStart);
            int end = this.frame.getScreenPosition(regionEnd);
            int regionWidth = Math.max(1, end - start);
            g.setColor(regionOfInterest.getBackgroundColor());
            g.fillRect(start, 0, regionWidth, height);
        }
    }

    RegionOfInterest getRegionOfInterest(int px) {
        double pos = this.frame.getChromosomePosition(px);
        Collection<RegionOfInterest> roiList = this.getRegions();
        if (roiList != null) {
            for (RegionOfInterest roi : roiList) {
                if (!(pos > (double)roi.getStart()) || !(pos < (double)roi.getEnd())) continue;
                return roi;
            }
        }
        return null;
    }

    protected static JPopupMenu getPopupMenu(final Component parent, final RegionOfInterest roi, final ReferenceFrame frame) {
        RegionMenu popupMenu = new RegionMenu(roi, frame);
        ((JPopupMenu)((Object)popupMenu)).addSeparator();
        JMenuItem item = new JMenuItem("Zoom");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.jumpTo(roi.getChr(), roi.getStart(), roi.getEnd());
                String locusString = roi.getLocusString();
                IGV.getInstance().getSession().getHistory().push(locusString, frame.getZoom());
            }
        });
        ((JPopupMenu)((Object)popupMenu)).add(item);
        item = new JMenuItem("Edit description...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String desc = JOptionPane.showInputDialog(parent, "Add or edit region description:", roi.getDescription());
                roi.setDescription(desc);
                IGV.getInstance().getSession().getRegionsOfInterestObservable().setChangedAndNotify();
            }
        });
        ((JPopupMenu)((Object)popupMenu)).add(item);
        item = new JMenuItem("Copy sequence");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LongRunningTask.submit(new NamedRunnable(){

                    @Override
                    public String getName() {
                        return "Copy sequence";
                    }

                    @Override
                    public void run() {
                        Genome genome = GenomeManager.getInstance().getCurrentGenome();
                        IGV.copySequenceToClipboard(genome, roi.getChr(), roi.getStart(), roi.getEnd());
                    }
                });
            }
        });
        ((JPopupMenu)((Object)popupMenu)).add(item);
        if (roi.getEnd() - roi.getStart() > 1000000) {
            item.setEnabled(false);
        }
        ((JPopupMenu)((Object)popupMenu)).add(item);
        if (Globals.isDevelopment()) {
            item = new JMenuItem("Blat sequence");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BlatClient.doBlatQuery(roi.getChr(), roi.getStart(), roi.getEnd());
                }
            });
            ((JPopupMenu)((Object)popupMenu)).add(item);
        }
        ((Container)((Object)popupMenu)).add(new JSeparator());
        item = new JMenuItem("Delete");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGV.getInstance().getSession().getRegionsOfInterest(frame.getChrName()).remove(roi);
                IGV.getInstance().repaintDataAndHeaderPanels();
            }
        });
        ((JPopupMenu)((Object)popupMenu)).add(item);
        return popupMenu;
    }

    public static RegionOfInterest getSelectedRegion() {
        return selectedRegion;
    }

    public static void setSelectedRegion(RegionOfInterest region) {
        selectedRegion = region;
    }

    private Collection<RegionOfInterest> getRegions() {
        return IGV.getInstance().getSession().getRegionsOfInterest(this.frame.getChrName());
    }

    class ROIMouseAdapater
    extends MouseInputAdapter {
        ROIMouseAdapater() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            RegionOfInterest roi = RegionOfInterestPanel.this.getRegionOfInterest(e.getX());
            if (roi != null) {
                RegionOfInterestPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                RegionOfInterestPanel.this.setToolTipText(roi.getTooltip());
                if (selectedRegion != roi) {
                    selectedRegion = roi;
                    IGV.getInstance().repaintDataPanels();
                }
            } else {
                if (selectedRegion != null) {
                    selectedRegion = null;
                    IGV.getInstance().repaintDataPanels();
                }
                RegionOfInterestPanel.this.setToolTipText("");
                RegionOfInterestPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (selectedRegion != null) {
                selectedRegion = null;
                IGV.getInstance().repaintDataPanels();
            }
        }

        private void showPopup(MouseEvent e) {
            RegionOfInterest roi = RegionOfInterestPanel.this.getRegionOfInterest(e.getX());
            if (roi != null) {
                RegionOfInterestPanel.getPopupMenu(RegionOfInterestPanel.this, roi, RegionOfInterestPanel.this.frame).show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

