/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.session.Session;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.AttributeHeaderPanel;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.HeaderPanelContainer;
import org.broad.igv.ui.panel.IGVPanel;
import org.broad.igv.ui.panel.NameHeaderPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackNamePanel;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.ui.util.UIUtilities;

public class MainPanel
extends JPanel
implements Paintable {
    private static Logger log = Logger.getLogger(MainPanel.class);
    IGV igv;
    private int namePanelX;
    private int namePanelWidth = PreferenceManager.getInstance().getAsInt("NAME_PANEL_WIDTH");
    private int attributePanelX;
    private int attributePanelWidth;
    private int dataPanelX;
    private int dataPanelWidth;
    public IGVPanel applicationHeaderPanel;
    public HeaderPanelContainer headerPanelContainer;
    private TrackPanelScrollPane dataTrackScrollPane;
    private TrackPanelScrollPane featureTrackScrollPane;
    private JideSplitPane centerSplitPane;
    private NameHeaderPanel nameHeaderPanel;
    private AttributeHeaderPanel attributeHeaderPanel;
    private int hgap = 5;
    private JScrollPane headerScrollPane;

    public MainPanel(IGV igv) {
        this.igv = igv;
        this.initComponents();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MainPanel.this.revalidate();
                MainPanel.this.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public void setDividerFractions(double[] fractions) {
        int[] dividerLocations = new int[fractions.length];
        double h = this.centerSplitPane.getHeight();
        for (int i = 0; i < fractions.length; ++i) {
            dividerLocations[i] = (int)Math.round(h * fractions[i]);
        }
        this.centerSplitPane.setDividerLocations(dividerLocations);
    }

    public double[] getDividerFractions() {
        int[] dividerLocations = this.centerSplitPane.getDividerLocations();
        double h = this.centerSplitPane.getHeight();
        double[] dividerFractions = new double[dividerLocations.length];
        for (int i = 0; i < dividerLocations.length; ++i) {
            dividerFractions[i] = (double)dividerLocations[i] / h;
        }
        return dividerFractions;
    }

    public void collapseNamePanel() {
        this.namePanelWidth = 0;
        this.revalidate();
    }

    public void expandNamePanel() {
        this.namePanelWidth = PreferenceManager.getInstance().getAsInt("NAME_PANEL_WIDTH");
        this.revalidate();
    }

    public void setNamePanelWidth(int width) {
        this.namePanelWidth = width;
        this.revalidate();
    }

    public void removeHeader() {
        this.remove(this.headerScrollPane);
        this.revalidate();
    }

    public void restoreHeader() {
        this.add((Component)this.headerScrollPane, "North");
        this.revalidate();
    }

    @Override
    public void doLayout() {
        this.layoutFrames();
        super.doLayout();
        this.applicationHeaderPanel.doLayout();
        for (TrackPanel tp : this.getTrackPanels()) {
            tp.getScrollPane().doLayout();
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.headerPanelContainer != null) {
            this.applicationHeaderPanel.setBackground(color);
            this.nameHeaderPanel.setBackground(color);
            this.attributeHeaderPanel.setBackground(color);
            this.headerPanelContainer.setBackground(color);
            this.nameHeaderPanel.setBackground(color);
            this.attributeHeaderPanel.setBackground(color);
            for (TrackPanel tsp : this.getTrackPanels()) {
                tsp.setBackground(color);
            }
        }
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(1021, 510));
        this.setLayout(new BorderLayout());
        this.nameHeaderPanel = new NameHeaderPanel();
        this.nameHeaderPanel.setBackground(new Color(255, 255, 255));
        this.nameHeaderPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.nameHeaderPanel.setMinimumSize(new Dimension(0, 0));
        this.nameHeaderPanel.setPreferredSize(new Dimension(0, 0));
        this.nameHeaderPanel.setLayout(new BorderLayout());
        this.attributeHeaderPanel = new AttributeHeaderPanel();
        this.attributeHeaderPanel.setBackground(new Color(255, 255, 255));
        this.attributeHeaderPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.attributeHeaderPanel.setDebugGraphicsOptions(-1);
        this.attributeHeaderPanel.setMinimumSize(new Dimension(0, 0));
        this.attributeHeaderPanel.setPreferredSize(new Dimension(0, 0));
        this.headerPanelContainer = new HeaderPanelContainer();
        this.headerScrollPane = new JScrollPane();
        this.headerScrollPane.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.headerScrollPane.setForeground(new Color(153, 153, 153));
        this.headerScrollPane.setHorizontalScrollBarPolicy(31);
        this.headerScrollPane.setVerticalScrollBarPolicy(22);
        this.headerScrollPane.setPreferredSize(new Dimension(1021, 130));
        this.add((Component)this.headerScrollPane, "North");
        this.applicationHeaderPanel = new IGVPanel(this);
        this.applicationHeaderPanel.add(this.nameHeaderPanel);
        this.applicationHeaderPanel.add(this.attributeHeaderPanel);
        this.applicationHeaderPanel.add(this.headerPanelContainer);
        this.headerScrollPane.setViewportView(this.applicationHeaderPanel);
        this.dataTrackScrollPane = new TrackPanelScrollPane();
        this.dataTrackScrollPane.setPreferredSize(new Dimension(1021, 349));
        TrackPanel dataTrackPanel = new TrackPanel("DataPanel", this);
        this.dataTrackScrollPane.setViewportView(dataTrackPanel);
        if (!PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane")) {
            this.featureTrackScrollPane = new TrackPanelScrollPane();
            this.featureTrackScrollPane.setPreferredSize(new Dimension(1021, 50));
            this.featureTrackScrollPane.setViewportView(new TrackPanel("FeaturePanel", this));
            this.add((Component)((Object)this.featureTrackScrollPane), "South");
        }
        this.centerSplitPane = new SplitPane(){

            public Insets getInsets(Insets insets) {
                return new Insets(0, 0, 0, 0);
            }
        };
        this.centerSplitPane.setDividerSize(3);
        this.centerSplitPane.setOrientation(0);
        this.centerSplitPane.add((Component)((Object)this.dataTrackScrollPane), (Object)"top");
        if (!PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane")) {
            this.centerSplitPane.add((Component)((Object)this.featureTrackScrollPane), (Object)"bottom");
        }
        this.add((Component)this.centerSplitPane, "Center");
        this.setBackground(PreferenceManager.getInstance().getAsColor("BACKGROUND_COLOR"));
    }

    public void resetPanels() {
        for (TrackPanel tp : this.getTrackPanels()) {
            tp.clearTracks();
            TrackPanelScrollPane tsp = tp.getScrollPane();
            if (tsp == this.dataTrackScrollPane || tsp == this.featureTrackScrollPane) continue;
            this.centerSplitPane.remove((Component)((Object)tsp));
            TrackNamePanel.removeDropListenerFor(tsp.getNamePanel());
        }
        this.igv.reset();
    }

    public synchronized TrackPanelScrollPane addDataPanel(String name) {
        TrackPanel trackPanel = new TrackPanel(name, this);
        TrackPanelScrollPane sp = new TrackPanelScrollPane();
        sp.setViewportView(trackPanel);
        for (TrackPanel tp : this.getTrackPanels()) {
            tp.getScrollPane().minimizeHeight();
        }
        int featurePaneIdx = this.centerSplitPane.indexOfPane((Component)((Object)this.featureTrackScrollPane));
        if (featurePaneIdx > 0) {
            this.centerSplitPane.insertPane((Component)((Object)sp), featurePaneIdx);
        } else {
            this.centerSplitPane.add((Component)((Object)sp));
        }
        if (!PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane") && sp.getTrackPanel().getTracks().size() == 0) {
            this.centerSplitPane.setDividerLocation(0, 3);
        }
        return sp;
    }

    public List<TrackPanel> getTrackPanels() {
        ArrayList<TrackPanel> panels = new ArrayList<TrackPanel>();
        for (Component c : this.centerSplitPane.getComponents()) {
            if (!(c instanceof TrackPanelScrollPane)) continue;
            panels.add(((TrackPanelScrollPane)((Object)c)).getTrackPanel());
        }
        return panels;
    }

    public void reorderPanels(List<String> names) {
        int h = this.centerSplitPane.getHeight();
        int[] dividerLocations = this.centerSplitPane.getDividerLocations();
        HashMap<String, Integer> panelHeights = new HashMap<String, Integer>();
        int idx = 0;
        HashMap<String, TrackPanelScrollPane> panes = new HashMap<String, TrackPanelScrollPane>();
        for (Component c : this.centerSplitPane.getComponents()) {
            if (!(c instanceof TrackPanelScrollPane)) continue;
            TrackPanelScrollPane tsp = (TrackPanelScrollPane)((Object)c);
            panes.put(tsp.getTrackPanelName(), tsp);
            int top = idx == 0 ? 0 : dividerLocations[idx - 1];
            int bottom = idx < dividerLocations.length ? dividerLocations[idx] : h;
            panelHeights.put(tsp.getTrackPanelName(), bottom - top);
            ++idx;
        }
        this.centerSplitPane.removeAll();
        idx = 0;
        int divLoc = 0;
        for (String name : names) {
            this.centerSplitPane.add((Component)panes.get(name));
            if (idx >= dividerLocations.length) continue;
            dividerLocations[idx] = divLoc += ((Integer)panelHeights.get(name)).intValue();
            ++idx;
        }
        this.centerSplitPane.setDividerLocations(dividerLocations);
        this.centerSplitPane.invalidate();
    }

    public void tweakPanelDivider() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                int h = MainPanel.this.centerSplitPane.getHeight();
                int nPanes = MainPanel.this.centerSplitPane.getPaneCount();
                double prefHeight = 0.0;
                for (int i = 0; i < nPanes; ++i) {
                    prefHeight += MainPanel.this.centerSplitPane.getPaneAt(i).getPreferredSize().getHeight();
                }
                double ratio = (double)h / prefHeight;
                int pos = 0;
                for (int i = 0; i < nPanes - 1; ++i) {
                    MainPanel.this.centerSplitPane.setDividerLocation(i, pos += (int)(ratio * MainPanel.this.centerSplitPane.getPaneAt(i).getPreferredSize().getHeight()));
                }
            }
        });
    }

    public void removeEmptyDataPanels() {
        ArrayList<TrackPanelScrollPane> emptyPanels = new ArrayList<TrackPanelScrollPane>();
        for (TrackPanel tp : this.getTrackPanels()) {
            if (!tp.getTracks().isEmpty()) continue;
            emptyPanels.add(tp.getScrollPane());
        }
        for (TrackPanelScrollPane panel : emptyPanels) {
            if (panel == null) continue;
            this.centerSplitPane.remove((Component)((Object)panel));
            TrackNamePanel.removeDropListenerFor(panel.getNamePanel());
        }
    }

    public void removeDataPanel(String name) {
        TrackPanelScrollPane sp = null;
        for (TrackPanel tp : this.getTrackPanels()) {
            if (!name.equals(tp.getName())) continue;
            sp = tp.getScrollPane();
            break;
        }
        if (sp == this.dataTrackScrollPane || sp == this.featureTrackScrollPane) {
            return;
        }
        if (sp != null) {
            this.centerSplitPane.remove((Component)((Object)sp));
            TrackNamePanel.removeDropListenerFor(sp.getNamePanel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutFrames() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Insets insets = this.applicationHeaderPanel.getInsets();
            this.namePanelX = insets.left;
            this.attributePanelX = this.namePanelX + this.namePanelWidth + this.hgap;
            this.attributePanelWidth = this.calculateAttributeWidth();
            this.dataPanelX = this.attributePanelX + this.attributePanelWidth + this.hgap;
            List<ReferenceFrame> frames = FrameManager.getFrames();
            this.dataPanelWidth = this.applicationHeaderPanel.getWidth() - insets.right - this.dataPanelX;
            if (frames.size() == 1) {
                frames.get(0).setBounds(0, this.dataPanelWidth);
            } else {
                float gap = Math.min(1.0f, 20.0f / (float)((int)(1.5 * (double)frames.size()))) * (float)this.hgap;
                int x = 0;
                Session.GeneListMode mode = IGV.hasInstance() ? IGV.getInstance().getSession().getGeneListMode() : Session.GeneListMode.NORMAL;
                float wc = mode == Session.GeneListMode.NORMAL ? ((float)this.dataPanelWidth - (float)(frames.size() - 1) * gap) / (float)frames.size() : 20.0f;
                for (int i = 0; i < frames.size(); ++i) {
                    ReferenceFrame frame = frames.get(i);
                    int nextX = (int)((float)(i + 1) * (wc + gap));
                    int w = nextX - x;
                    frame.setBounds(x, w);
                    x = nextX;
                }
            }
        }
    }

    private int calculateAttributeWidth() {
        if (!PreferenceManager.getInstance().getAsBoolean("IGV.track.show.attribute.views")) {
            return 0;
        }
        List<String> attributeKeys = AttributeManager.getInstance().getVisibleAttributes();
        int attributeCount = attributeKeys.size();
        int packWidth = attributeCount * 11 + 1;
        return packWidth;
    }

    public boolean isExpanded() {
        return this.namePanelWidth > 0;
    }

    public int getAttributePanelWidth() {
        return this.attributePanelWidth;
    }

    public int getNamePanelX() {
        return this.namePanelX;
    }

    public int getNamePanelWidth() {
        return this.namePanelWidth;
    }

    public int getAttributePanelX() {
        return this.attributePanelX;
    }

    public int getDataPanelX() {
        return this.dataPanelX;
    }

    public int getDataPanelWidth() {
        return this.dataPanelWidth;
    }

    public JideSplitPane getCenterSplitPane() {
        return this.centerSplitPane;
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect) {
        int width = this.applicationHeaderPanel.getWidth();
        int height = this.applicationHeaderPanel.getHeight();
        Graphics2D headerGraphics = (Graphics2D)g.create();
        Rectangle headerRect = new Rectangle(0, 0, width, height);
        this.applicationHeaderPanel.paintOffscreen(headerGraphics, headerRect);
        headerGraphics.dispose();
        Rectangle r = this.centerSplitPane.getBounds();
        g.translate(0, r.y);
        Component[] components = this.centerSplitPane.getComponents();
        Arrays.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component component, Component component1) {
                return component.getY() - component1.getY();
            }
        });
        int dy = components[0].getY();
        for (Component c : components) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(0, dy);
            if (c instanceof TrackPanelScrollPane) {
                TrackPanelScrollPane tsp = (TrackPanelScrollPane)((Object)c);
                if (tsp.getTrackPanel().getTracks().size() == 0) continue;
                int panelHeight = this.getOffscreenImagePanelHeight(tsp);
                Rectangle tspRect = new Rectangle(tsp.getBounds());
                tspRect.height = panelHeight;
                g2d.setClip(new Rectangle(0, 0, tsp.getWidth(), tspRect.height));
                tsp.paintOffscreen(g2d, tspRect);
                dy += tspRect.height;
            } else {
                g2d.setClip(new Rectangle(0, 0, c.getWidth(), c.getHeight()));
                c.paint(g2d);
                dy += c.getHeight();
            }
            g2d.dispose();
        }
    }

    public int getOffscreenImageHeight() {
        int height = this.centerSplitPane.getBounds().y;
        for (Component c : this.centerSplitPane.getComponents()) {
            if (c instanceof TrackPanelScrollPane) {
                TrackPanelScrollPane tsp = (TrackPanelScrollPane)((Object)c);
                int panelHeight = this.getOffscreenImagePanelHeight(tsp);
                Rectangle tspRect = new Rectangle(tsp.getBounds());
                tspRect.height = panelHeight;
                height += tspRect.height;
                continue;
            }
            height += c.getHeight();
        }
        return height += 35;
    }

    private int getOffscreenImagePanelHeight(TrackPanelScrollPane tsp) {
        int maxPanelHeight = SnapshotUtilities.getMaxPanelHeight();
        int visibleHeight = tsp.getVisibleRect().height;
        int panelHeight = maxPanelHeight < 0 ? visibleHeight : Math.min(maxPanelHeight, Math.max(visibleHeight, tsp.getDataPanel().getHeight()));
        return panelHeight;
    }

    static class SplitPane
    extends JideSplitPane {
        SplitPane() {
        }

        public void doLayout() {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Layout");
            }
            super.doLayout();
        }
    }
}

