/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import org.broad.igv.PreferenceManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.ui.FontManager;
import org.broad.igv.util.ChromosomeColors;

public class ChromosomeColorLegend
extends JPanel {
    public ChromosomeColorLegend() {
        this.setSize(480, 24);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(480, 24);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintLegend(g);
    }

    public void paintLegend(Graphics g) {
        Graphics textGraphics = g.create();
        if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
            ((Graphics2D)textGraphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        textGraphics.setColor(Color.black);
        textGraphics.setFont(FontManager.getFont(10));
        int w = this.getWidth() / 24;
        int h = this.getHeight() / 2;
        int x = 0;
        for (int i = 1; i <= 24; ++i) {
            String chr = i < 23 ? "chr" + i : (i == 23 ? "chrX" : "chrY");
            Color c = ChromosomeColors.getColor(chr);
            g.setColor(c);
            g.fillRect(x, 0, w, h);
            String tmp = i < 23 ? String.valueOf(i) : (i == 23 ? "X" : "Y");
            GraphicUtils.drawCenteredText(tmp, x, h, w, h, textGraphics);
            x += w;
        }
    }
}

