/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.IExon;
import org.broad.igv.renderer.SashimiJunctionRenderer;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.IAlignmentDataManager;
import org.broad.igv.sam.MemoryAlignmentDataManager;
import org.broad.igv.sam.SpliceJunctionFinderTrack;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.RenderContextImpl;
import org.broad.igv.track.SelectableFeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorPalette;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.event.AlignmentTrackEvent;
import org.broad.igv.ui.panel.FeatureTrackSelectionDialog;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.PanTool;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackSelectionDialog;
import org.broad.igv.ui.panel.ZoomSliderPanel;
import org.broad.igv.ui.util.UIUtilities;

public class SashimiPlot
extends JFrame {
    private List<SpliceJunctionFinderTrack> spliceJunctionTracks;
    private ReferenceFrame frame;
    private final double minOrigin;
    private final double maxEnd;
    private static final List<Color> plotColors;

    public SashimiPlot(ReferenceFrame iframe, Collection<? extends AlignmentTrack> alignmentTracks, FeatureTrack geneTrack) {
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        int minJunctionCoverage = PreferenceManager.getInstance().getAsInt("SAM.JUNCTION_MIN_COVERAGE");
        this.frame = new ReferenceFrame(iframe);
        this.minOrigin = this.frame.getOrigin();
        this.maxEnd = this.frame.getEnd();
        this.initSize(this.frame.getWidthInPixels());
        BoxLayout boxLayout = new BoxLayout(this.getContentPane(), 1);
        this.getContentPane().setLayout(boxLayout);
        this.getContentPane().add(this.generateControlPanel(this.frame));
        this.spliceJunctionTracks = new ArrayList<SpliceJunctionFinderTrack>(alignmentTracks.size());
        int colorInd = 0;
        for (AlignmentTrack alignmentTrack : alignmentTracks) {
            AlignmentDataManager oldDataManager = alignmentTrack.getDataManager();
            MemoryAlignmentDataManager dataManager = new MemoryAlignmentDataManager(oldDataManager, oldDataManager.getSpliceJunctionLoadOptions());
            SpliceJunctionFinderTrack spliceJunctionTrack = new SpliceJunctionFinderTrack(alignmentTrack.getResourceLocator(), alignmentTrack.getName(), dataManager, true);
            spliceJunctionTrack.setRendererClass(SashimiJunctionRenderer.class);
            Color color = plotColors.get(colorInd);
            colorInd = (colorInd + 1) % plotColors.size();
            spliceJunctionTrack.setColor(color);
            TrackComponent<SpliceJunctionFinderTrack> trackComponent = new TrackComponent<SpliceJunctionFinderTrack>(this.frame, spliceJunctionTrack);
            this.initSpliceJunctionComponent(trackComponent, dataManager, oldDataManager.getCoverageTrack(), minJunctionCoverage);
            this.getContentPane().add(trackComponent);
            this.spliceJunctionTracks.add(spliceJunctionTrack);
        }
        Axis axis = this.createAxis(this.frame);
        this.getContentPane().add(axis);
        SelectableFeatureTrack selectableFeatureTrack = new SelectableFeatureTrack(geneTrack);
        TrackComponent<SelectableFeatureTrack> geneComponent = new TrackComponent<SelectableFeatureTrack>(this.frame, selectableFeatureTrack);
        this.getContentPane().add(geneComponent);
        this.initGeneComponent(this.frame.getWidthInPixels(), geneComponent, selectableFeatureTrack);
        this.validate();
    }

    private Component generateControlPanel(ReferenceFrame frame) {
        JPanel controlPanel = new JPanel();
        ZoomSliderPanel zoomSliderPanel = new ZoomSliderPanel(frame);
        zoomSliderPanel.setMinZoomLevel(frame.getZoom());
        zoomSliderPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SashimiPlot.this.repaint();
            }
        });
        Dimension controlSize = new Dimension(200, 30);
        controlPanel.add(zoomSliderPanel);
        SashimiPlot.setFixedSize(zoomSliderPanel, controlSize);
        Dimension panelSize = controlSize;
        SashimiPlot.setFixedSize(controlPanel, panelSize);
        BoxLayout layout = new BoxLayout(controlPanel, 0);
        controlPanel.setLayout(layout);
        return controlPanel;
    }

    private static void setFixedSize(Component component, Dimension dimension) {
        component.setPreferredSize(dimension);
        component.setMinimumSize(dimension);
        component.setMaximumSize(dimension);
    }

    private void initSize(int width) {
        this.setSize(width, 500);
    }

    private Axis createAxis(ReferenceFrame frame) {
        Axis axis = new Axis(frame);
        Dimension maxDim = new Dimension(Integer.MAX_VALUE, 25);
        axis.setMaximumSize(maxDim);
        Dimension prefDim = new Dimension(maxDim);
        prefDim.setSize(frame.getWidthInPixels(), prefDim.height);
        axis.setPreferredSize(prefDim);
        return axis;
    }

    private void initGeneComponent(int prefWidth, TrackComponent<SelectableFeatureTrack> geneComponent, FeatureTrack geneTrack) {
        geneTrack.setDisplayMode(Track.DisplayMode.SQUISHED);
        geneTrack.setVisibilityWindow(geneTrack.getVisibilityWindow());
        RenderContextImpl context = new RenderContextImpl(geneComponent, null, this.frame, null);
        geneTrack.load(context);
        Dimension maxGeneDim = new Dimension(Integer.MAX_VALUE, geneTrack.getNumberOfFeatureLevels() * geneTrack.getSquishedRowHeight() + 10);
        geneComponent.setMaximumSize(maxGeneDim);
        Dimension prefGeneDim = new Dimension(maxGeneDim);
        prefGeneDim.setSize(prefWidth, prefGeneDim.height);
        geneComponent.setPreferredSize(prefGeneDim);
        GeneTrackMouseAdapter ad2 = new GeneTrackMouseAdapter(geneComponent);
        geneComponent.addMouseListener(ad2);
        geneComponent.addMouseMotionListener(ad2);
    }

    private void initSpliceJunctionComponent(TrackComponent<SpliceJunctionFinderTrack> trackComponent, IAlignmentDataManager dataManager, CoverageTrack coverageTrack, int minJunctionCoverage) {
        JunctionTrackMouseAdapter ad1 = new JunctionTrackMouseAdapter(trackComponent);
        trackComponent.addMouseListener(ad1);
        trackComponent.addMouseMotionListener(ad1);
        this.getRenderer((SpliceJunctionFinderTrack)((TrackComponent)trackComponent).track).setDataManager(dataManager);
        this.getRenderer((SpliceJunctionFinderTrack)((TrackComponent)trackComponent).track).setCoverageTrack(coverageTrack);
        dataManager.setMinJunctionCoverage(minJunctionCoverage);
        this.getRenderer((SpliceJunctionFinderTrack)((TrackComponent)trackComponent).track).setBackground(this.getBackground());
    }

    private SashimiJunctionRenderer getRenderer(SpliceJunctionFinderTrack spliceJunctionTrack) {
        return (SashimiJunctionRenderer)spliceJunctionTrack.getRenderer();
    }

    private void setMinJunctionCoverage(TrackComponent<SpliceJunctionFinderTrack> trackComponent, int newMinJunctionCoverage) {
        IAlignmentDataManager dataManager = this.getRenderer((SpliceJunctionFinderTrack)((TrackComponent)trackComponent).track).getDataManager();
        dataManager.setMinJunctionCoverage(newMinJunctionCoverage);
        ((SpliceJunctionFinderTrack)((TrackComponent)trackComponent).track).onAlignmentTrackEvent(new AlignmentTrackEvent(this, AlignmentTrackEvent.Type.SPLICE_JUNCTION));
        trackComponent.repaint();
    }

    private void setMaxCoverageDepth(TrackComponent<SpliceJunctionFinderTrack> trackComponent, int newMaxDepth) {
        this.getRenderer((SpliceJunctionFinderTrack)((TrackComponent)trackComponent).track).setMaxDepth(newMaxDepth);
        this.repaint();
    }

    public static void getSashimiPlot(SashimiPlot sashimiPlot) {
        if (sashimiPlot == null) {
            FeatureTrack geneTrack = null;
            if (IGV.getInstance().getFeatureTracks().size() == 1) {
                geneTrack = IGV.getInstance().getFeatureTracks().get(0);
            } else {
                FeatureTrackSelectionDialog dlg = new FeatureTrackSelectionDialog(IGV.getMainFrame());
                dlg.setTitle("Select Gene Track");
                dlg.setVisible(true);
                if (dlg.getIsCancelled()) {
                    return;
                }
                geneTrack = dlg.getSelectedTrack();
            }
            Collection<AlignmentTrack> alignmentTracks = new ArrayList<AlignmentTrack>();
            for (Track track : IGV.getInstance().getAllTracks()) {
                if (!(track instanceof AlignmentTrack)) continue;
                alignmentTracks.add((AlignmentTrack)track);
            }
            if (alignmentTracks.size() > 1) {
                TrackSelectionDialog alDlg = new TrackSelectionDialog(IGV.getMainFrame(), TrackSelectionDialog.SelectionMode.MULTIPLE, alignmentTracks);
                alDlg.setTitle("Select Alignment Tracks");
                alDlg.setVisible(true);
                if (alDlg.getIsCancelled()) {
                    return;
                }
                alignmentTracks = alDlg.getSelectedTracks();
            }
            sashimiPlot = new SashimiPlot(FrameManager.getDefaultFrame(), alignmentTracks, geneTrack);
            sashimiPlot.setVisible(true);
        }
    }

    static {
        ColorPalette palette = ColorUtilities.getDefaultPalette();
        plotColors = Arrays.asList(palette.getColors());
    }

    private static class Axis
    extends JComponent {
        private ReferenceFrame frame;

        Axis(ReferenceFrame frame) {
            this.frame = frame;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle visibleRect = this.getVisibleRect();
            RenderContextImpl context = new RenderContextImpl(this, (Graphics2D)g, this.frame, visibleRect);
            this.drawGenomicAxis(context, visibleRect);
        }

        private void drawGenomicAxis(RenderContext context, Rectangle trackRectangle) {
            int numTicks = 4;
            int ticHeight = 5;
            double pixelPadding = trackRectangle.getWidth() / 20.0;
            int yLoc = ticHeight + 1;
            double origin = context.getOrigin();
            double locScale = context.getScale();
            double startPix = trackRectangle.getX() + pixelPadding;
            double endPix = trackRectangle.getMaxX() - pixelPadding;
            double ticIntervalPix = (endPix - startPix) / (double)(numTicks - 1);
            double ticIntervalCoord = locScale * ticIntervalPix;
            int startCoord = (int)(origin + locScale * startPix);
            Graphics2D g2D = context.getGraphic2DForColor(Color.black);
            g2D.drawLine((int)startPix, yLoc, (int)endPix, yLoc);
            for (int tic = 0; tic < numTicks; ++tic) {
                int xLoc = (int)(startPix + (double)tic * ticIntervalPix);
                g2D.drawLine(xLoc, yLoc, xLoc, yLoc - ticHeight);
                int ticCoord = (int)((double)startCoord + (double)tic * ticIntervalCoord);
                String text = "" + ticCoord;
                Rectangle2D textBounds = g2D.getFontMetrics().getStringBounds(text, g2D);
                g2D.drawString(text, (int)((double)xLoc - textBounds.getWidth() / 2.0), (int)((double)yLoc + textBounds.getHeight()));
            }
        }
    }

    private static class RepaintPopupMenuListener
    implements PopupMenuListener {
        Component component;

        RepaintPopupMenuListener(Component component) {
            this.component = component;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.component.repaint();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.component.repaint();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.component.repaint();
        }
    }

    private abstract class TrackComponentMouseAdapter<T extends Track>
    extends MouseAdapter {
        protected TrackComponent<T> trackComponent;
        protected PanTool currentTool;

        TrackComponentMouseAdapter(TrackComponent<T> trackComponent) {
            this.trackComponent = trackComponent;
            this.currentTool = new PanTool(null);
            this.currentTool.setReferenceFrame(((TrackComponent)this.trackComponent).frame);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.currentTool.getLastMousePoint() == null) {
                return;
            }
            double diff = (double)e.getX() - this.currentTool.getLastMousePoint().getX();
            boolean hitBounds = SashimiPlot.this.frame.getOrigin() <= SashimiPlot.this.minOrigin && diff > 0.0;
            if (!(hitBounds |= SashimiPlot.this.frame.getEnd() >= SashimiPlot.this.maxEnd && diff < 0.0)) {
                this.currentTool.mouseDragged(e);
                SashimiPlot.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopupMenu(e);
            } else {
                this.currentTool.mouseReleased(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopupMenu(e);
            } else {
                this.currentTool.mousePressed(e);
                super.mousePressed(e);
            }
        }

        protected void doPopupMenu(MouseEvent e) {
            IGVPopupMenu menu = this.getPopupMenu(e);
            if (menu != null) {
                menu.show(this.trackComponent, e.getX(), e.getY());
            }
        }

        protected TrackClickEvent createTrackClickEvent(MouseEvent e) {
            return new TrackClickEvent(e, ((TrackComponent)this.trackComponent).frame);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopupMenu(e);
                return;
            }
            this.currentTool.mouseClicked(e);
            this.handleDataClick(e);
        }

        protected abstract void handleDataClick(MouseEvent var1);

        protected abstract IGVPopupMenu getPopupMenu(MouseEvent var1);
    }

    private class GeneTrackMouseAdapter
    extends TrackComponentMouseAdapter<SelectableFeatureTrack> {
        GeneTrackMouseAdapter(TrackComponent<SelectableFeatureTrack> trackComponent) {
            super(trackComponent);
        }

        @Override
        protected void handleDataClick(MouseEvent e) {
            ((SelectableFeatureTrack)this.trackComponent.track).handleDataClick(this.createTrackClickEvent(e));
            Set<IExon> selectedExon = ((SelectableFeatureTrack)this.trackComponent.track).getSelectedExons();
            for (SpliceJunctionFinderTrack spliceTrack : SashimiPlot.this.spliceJunctionTracks) {
                SashimiPlot.this.getRenderer(spliceTrack).setSelectedExons(selectedExon);
            }
            SashimiPlot.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.trackComponent.updateToolTipText(this.createTrackClickEvent(e));
        }

        @Override
        protected IGVPopupMenu getPopupMenu(MouseEvent e) {
            IGVPopupMenu menu = new IGVPopupMenu();
            TrackMenuUtils.addDisplayModeItems(Arrays.asList(this.trackComponent.track), menu);
            menu.addPopupMenuListener(new RepaintPopupMenuListener(SashimiPlot.this));
            return menu;
        }
    }

    private class JunctionTrackMouseAdapter
    extends TrackComponentMouseAdapter<SpliceJunctionFinderTrack> {
        JunctionTrackMouseAdapter(TrackComponent<SpliceJunctionFinderTrack> trackComponent) {
            super(trackComponent);
        }

        @Override
        protected void handleDataClick(MouseEvent e) {
        }

        @Override
        protected IGVPopupMenu getPopupMenu(MouseEvent e) {
            IGVPopupMenu menu = new IGVPopupMenu();
            CoverageTrack covTrack = SashimiPlot.this.getRenderer((SpliceJunctionFinderTrack)this.trackComponent.track).getCoverageTrack();
            JMenuItem setCoverageDataRange = CoverageTrack.addDataRangeItem(SashimiPlot.this, null, Arrays.asList(covTrack));
            setCoverageDataRange.setText("Set Coverage Data Range");
            menu.add(setCoverageDataRange);
            JMenuItem minJunctionCoverage = new JMenuItem("Set Min Junction Coverage");
            minJunctionCoverage.setToolTipText("Junctions below this threshold will be removed from view");
            minJunctionCoverage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IAlignmentDataManager dataManager = SashimiPlot.this.getRenderer((SpliceJunctionFinderTrack)JunctionTrackMouseAdapter.this.trackComponent.track).getDataManager();
                    SpliceJunctionHelper.LoadOptions loadOptions = dataManager.getSpliceJunctionLoadOptions();
                    String input = JOptionPane.showInputDialog("Set Minimum Junction Coverage", (Object)loadOptions.minJunctionCoverage);
                    if (input == null || input.length() == 0) {
                        return;
                    }
                    try {
                        int newMinJunctionCoverage = Integer.parseInt(input);
                        SashimiPlot.this.setMinJunctionCoverage(JunctionTrackMouseAdapter.this.trackComponent, newMinJunctionCoverage);
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(SashimiPlot.this, input + " is not an integer");
                    }
                }
            });
            JMenuItem maxJunctionCoverageRange = new JMenuItem("Set Max Junction Coverage Range");
            maxJunctionCoverageRange.setToolTipText("The thickness of each line will be proportional to the coverage, up until this value");
            maxJunctionCoverageRange.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String input = JOptionPane.showInputDialog("Set Max Junction Coverage", (Object)SashimiPlot.this.getRenderer((SpliceJunctionFinderTrack)JunctionTrackMouseAdapter.this.trackComponent.track).getMaxDepth());
                    if (input == null || input.length() == 0) {
                        return;
                    }
                    try {
                        int newMaxDepth = Integer.parseInt(input);
                        SashimiPlot.this.setMaxCoverageDepth(JunctionTrackMouseAdapter.this.trackComponent, newMaxDepth);
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(SashimiPlot.this, input + " is not an integer");
                    }
                }
            });
            JMenuItem colorItem = new JMenuItem("Set Color");
            colorItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = UIUtilities.showColorChooserDialog("Select Track Color", ((SpliceJunctionFinderTrack)JunctionTrackMouseAdapter.this.trackComponent.track).getColor());
                    SashimiPlot.this.toFront();
                    if (color == null) {
                        return;
                    }
                    ((SpliceJunctionFinderTrack)JunctionTrackMouseAdapter.this.trackComponent.track).setColor(color);
                    JunctionTrackMouseAdapter.this.trackComponent.repaint();
                }
            });
            JMenuItem saveImageItem = new JMenuItem("Save Image...");
            saveImageItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File defaultFile = new File("Sashimi.png");
                    IGV.getInstance().createSnapshot(SashimiPlot.this.getContentPane(), defaultFile);
                }
            });
            menu.add(minJunctionCoverage);
            menu.add(maxJunctionCoverageRange);
            menu.add(colorItem);
            menu.add(saveImageItem);
            return menu;
        }
    }

    private static class TrackComponent<T extends Track>
    extends JComponent {
        private T track;
        private ReferenceFrame frame;
        private String toolTipText = null;

        public TrackComponent(ReferenceFrame frame, T track) {
            this.frame = frame;
            this.track = track;
        }

        public void updateToolTipText(TrackClickEvent tce) {
            this.toolTipText = this.track.getValueStringAt(tce.getFrame().getChrName(), tce.getChromosomePosition(), tce.getMouseEvent().getY(), tce.getFrame());
            this.toolTipText = "<html>" + this.toolTipText;
            this.setToolTipText(this.toolTipText);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle visibleRect = this.getVisibleRect();
            RenderContextImpl context = new RenderContextImpl(this, (Graphics2D)g, this.frame, visibleRect);
            this.track.render(context, visibleRect);
        }
    }
}

