/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicBorders;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.IGVCommandBar;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.ApplicationStatusBar;

public class IGVContentPane
extends JPanel {
    private static Logger log = Logger.getLogger(IGVContentPane.class);
    private JPanel commandBarPanel;
    private IGVCommandBar igvCommandBar;
    private MainPanel mainPanel;
    private ApplicationStatusBar statusBar;
    private IGV igv;

    public IGVContentPane(IGV igv) {
        this.igv = igv;
        this.setLayout(new BorderLayout());
        this.commandBarPanel = new JPanel();
        BoxLayout layout = new BoxLayout(this.commandBarPanel, 3);
        this.commandBarPanel.setLayout(layout);
        this.add((Component)this.commandBarPanel, "North");
        this.igvCommandBar = new IGVCommandBar();
        this.igvCommandBar.setMinimumSize(new Dimension(250, 33));
        this.igvCommandBar.setBorder(new BasicBorders.MenuBarBorder(Color.GRAY, Color.GRAY));
        this.igvCommandBar.setAlignmentX(1.0f);
        this.commandBarPanel.add(this.igvCommandBar);
        this.mainPanel = new MainPanel(igv);
        this.add((Component)this.mainPanel, "Center");
        this.statusBar = new ApplicationStatusBar();
        this.statusBar.setDebugGraphicsOptions(-1);
        this.add((Component)this.statusBar, "South");
    }

    public void addCommandBar(JComponent component) {
        component.setBorder(new BasicBorders.MenuBarBorder(Color.GRAY, Color.GRAY));
        component.setAlignmentX(1.0f);
        this.commandBarPanel.add(component);
        this.commandBarPanel.invalidate();
    }

    public void removeCommandBar(JComponent component) {
        this.commandBarPanel.remove(component);
        this.commandBarPanel.invalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        return UIConstants.preferredSize;
    }

    public void repaintDataPanels() {
        for (TrackPanel tp : this.mainPanel.getTrackPanels()) {
            tp.getScrollPane().getDataPanel().repaint();
        }
    }

    public void revalidateDataPanels() {
        for (TrackPanel tp : this.mainPanel.getTrackPanels()) {
            tp.getScrollPane().getDataPanel().revalidate();
        }
    }

    public final void doRefresh() {
        this.mainPanel.revalidate();
        this.repaint();
    }

    public void resetStatusMessage() {
        this.statusBar.setMessage("" + this.igv.getVisibleTrackCount() + " tracks loaded");
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public IGVCommandBar getCommandBar() {
        return this.igvCommandBar;
    }

    public void chromosomeChanged(String chrName) {
        this.igvCommandBar.chromosomeChanged(chrName);
    }

    public void updateCurrentCoordinates() {
        this.igvCommandBar.updateCurrentCoordinates();
    }

    public ApplicationStatusBar getStatusBar() {
        return this.statusBar;
    }
}

