/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.reader.AlignmentParser;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.DotAlignedParser;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.sam.reader.GeraldParser;
import org.broad.igv.sam.reader.PSLAlignmentParser;
import org.broad.igv.sam.reader.SamUtils;
import org.broad.tribble.readers.AsciiLineReader;

public class GeraldReader
implements AlignmentReader {
    private static Logger log = Logger.getLogger(GeraldReader.class);
    static int MAX_READ_LENGTH = 100;
    static int maxTileCount = 20;
    String alignmentFile;
    FeatureIndex featureIndex;
    FileInputStream is;
    AlignmentParser parser;

    public GeraldReader(String alignmentFile, boolean requireIndex) {
        this.alignmentFile = alignmentFile;
        this.parser = GeraldReader.getParserFor(alignmentFile);
        try {
            this.is = new FileInputStream(alignmentFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        if (requireIndex) {
            this.featureIndex = SamUtils.getIndexFor(alignmentFile);
            if (this.featureIndex == null) {
                throw new DataLoadException("Could not locate index file.", alignmentFile);
            }
        }
    }

    private static AlignmentParser getParserFor(String fn) {
        if (fn.endsWith(".aligned") || fn.endsWith(".aligned.txt")) {
            return new DotAlignedParser();
        }
        if (fn.endsWith(".bedz") || fn.endsWith(".bed")) {
            return new DotAlignedParser(true);
        }
        if (fn.endsWith(".psl") || fn.endsWith(".psxl")) {
            return new PSLAlignmentParser();
        }
        return new GeraldParser();
    }

    private FeatureIndex getIndex() {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.alignmentFile);
        }
        return this.featureIndex;
    }

    @Override
    public List<String> getSequenceNames() {
        FeatureIndex idx = this.getIndex();
        if (idx == null) {
            return null;
        }
        return new ArrayList<String>(idx.getIndexedChromosomes());
    }

    @Override
    public Set<String> getPlatforms() {
        return null;
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.alignmentFile);
        }
        if (this.featureIndex == null) {
            throw new UnsupportedOperationException("SAM files must be indexed to support query methods");
        }
        if (!this.featureIndex.containsChromosome(sequence)) {
            return EmptyAlignmentIterator.getInstance();
        }
        return new GeraldQueryIterator(sequence, start, end, contained);
    }

    @Override
    public boolean hasIndex() {
        return this.getIndex() != null;
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        return new GeraldIterator();
    }

    class GeraldQueryIterator
    extends GeraldIterator {
        public GeraldQueryIterator(String sequence, int start, int end, boolean contained) {
            this.chr = sequence;
            this.start = start;
            this.end = end;
            this.contained = contained;
            this.seekToStart();
            this.reader = new AsciiLineReader((InputStream)GeraldReader.this.is);
            this.advanceToFirstRecord();
        }

        private boolean withinBounds(Alignment alignment) {
            boolean within;
            boolean bl = within = alignment.getEnd() <= this.end && alignment.getStart() >= this.start;
            if (this.contained) {
                return within;
            }
            within |= alignment.getStart() <= this.start && alignment.getEnd() > this.start;
            return within |= alignment.getStart() >= this.start && alignment.getStart() < this.end;
        }

        private void advanceToFirstRecord() {
            this.nextRecord = this.parseNextRecord();
            while (this.nextRecord != null && this.nextRecord.getChr().equals(this.chr) && !this.withinBounds(this.nextRecord)) {
                this.readNextRecord();
            }
        }

        @Override
        protected Alignment readNextRecord() {
            this.advance();
            while (this.nextRecord != null && !this.withinBounds(this.nextRecord)) {
                this.advance();
            }
            return this.nextRecord;
        }

        private void advance() {
            if (this.hasNext()) {
                this.nextRecord = this.parseNextRecord();
                if (this.nextRecord == null) {
                    return;
                }
                if (this.nextRecord.getStart() >= this.end) {
                    this.nextRecord = null;
                }
            } else {
                this.nextRecord = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextRecord == null || !this.chr.equals(this.nextRecord.getChr())) {
                return false;
            }
            return this.contained ? this.nextRecord.getEnd() <= this.end : this.nextRecord.getStart() < this.end;
        }

        private void seekToStart() {
            if (GeraldReader.this.featureIndex == null) {
                throw new UnsupportedOperationException("SAM files must be indexed to support query methods");
            }
            int startAdjustment = this.contained ? 0 : GeraldReader.this.featureIndex.getLongestFeature(this.chr);
            int startTileNumber = Math.max(0, this.start - startAdjustment) / GeraldReader.this.featureIndex.getTileWidth();
            FeatureIndex.TileDef seekPos = GeraldReader.this.featureIndex.getTileDef(this.chr, startTileNumber);
            long startPosition = seekPos == null ? 0L : seekPos.getStartPosition();
            try {
                GeraldReader.this.is = new FileInputStream(GeraldReader.this.alignmentFile);
                GeraldReader.this.is.getChannel().position(startPosition);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    class GeraldIterator
    implements CloseableIterator<Alignment> {
        String chr = null;
        int start;
        int end;
        boolean contained;
        Alignment nextRecord;
        AsciiLineReader reader;

        public GeraldIterator() {
            this.reader = new AsciiLineReader((InputStream)GeraldReader.this.is);
            this.readNextRecord();
        }

        protected Alignment parseNextRecord() {
            Alignment next;
            try {
                next = GeraldReader.this.parser.readNextRecord(this.reader);
            }
            catch (IOException e) {
                log.error((Object)"Error reading Gerald record", (Throwable)e);
                return null;
            }
            return next;
        }

        protected Alignment readNextRecord() {
            this.nextRecord = this.parseNextRecord();
            return this.nextRecord;
        }

        public void close() {
            try {
                GeraldReader.this.is.close();
            }
            catch (IOException ex) {
                log.error((Object)"Error closing alignment file", (Throwable)ex);
            }
        }

        public boolean hasNext() {
            return this.nextRecord != null;
        }

        public Alignment next() {
            Alignment ret = this.nextRecord;
            this.readNextRecord();
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

