/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.IAlignmentDataManager;
import org.broad.igv.sam.SpliceJunctionHelper;

public class MemoryAlignmentDataManager
implements IAlignmentDataManager {
    private SpliceJunctionHelper.LoadOptions loadOptions;
    private Map<String, AlignmentInterval> loadedIntervalMap = new HashMap<String, AlignmentInterval>();

    public MemoryAlignmentDataManager(AlignmentDataManager alignmentDataManager, SpliceJunctionHelper.LoadOptions loadOptions) {
        this.loadOptions = loadOptions;
        for (String intervalName : alignmentDataManager.getLoadedIntervalNames()) {
            this.loadedIntervalMap.put(intervalName, new AlignmentInterval(alignmentDataManager.getLoadedInterval(intervalName)));
        }
    }

    @Override
    public AlignmentInterval getLoadedInterval(String intervalName) {
        return this.loadedIntervalMap.get(intervalName);
    }

    @Override
    public SpliceJunctionHelper.LoadOptions getSpliceJunctionLoadOptions() {
        return this.loadOptions;
    }

    @Override
    public void setMinJunctionCoverage(int minJunctionCoverage) {
        this.loadOptions = new SpliceJunctionHelper.LoadOptions(minJunctionCoverage, this.loadOptions.minReadFlankingWidth);
        for (AlignmentInterval interval : this.getAllLoadedIntervals()) {
            interval.getSpliceJunctionHelper().setLoadOptions(this.loadOptions);
        }
    }

    @Override
    public Collection<AlignmentInterval> getAllLoadedIntervals() {
        return this.loadedIntervalMap.values();
    }
}

