/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.FeatureRenderer;
import org.broad.igv.track.RenderContext;

public class BedRenderer
implements FeatureRenderer {
    @Override
    public void renderAlignments(List<Alignment> alignments, RenderContext context, Rectangle rowRect, Rectangle inputRect, AlignmentTrack.RenderOptions renderOptions, boolean leaveMargin, Map<String, Color> selectedReadNames) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (alignments != null && alignments.size() > 0) {
            for (Alignment alignment : alignments) {
                double pixelStart = ((double)alignment.getStart() - origin) / locScale;
                double pixelEnd = ((double)alignment.getEnd() - origin) / locScale;
                if (!(pixelEnd >= rowRect.getX()) || !(pixelStart <= rowRect.getMaxX())) continue;
                Graphics2D g = context.getGraphic2DForColor(Color.GRAY);
                int w = Math.max(1, (int)(pixelEnd - pixelStart));
                int h = (int)Math.max(1.0, rowRect.getHeight() - 2.0);
                int y = (int)(rowRect.getY() + (rowRect.getHeight() - (double)h) / 2.0);
                g.fillRect((int)pixelStart, y, w, h);
            }
        }
    }
}

