/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import org.broad.igv.Globals;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.igv.peaks.Peak;

public class PeakCodec
extends UCSCCodec<Peak> {
    Genome genome;

    public PeakCodec(Genome genome) {
        super(Peak.class);
        this.genome = genome;
    }

    public Peak decode(String nextLine) {
        if (nextLine.trim().length() == 0 || nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            return null;
        }
        String[] tokens = Globals.singleTabMultiSpacePattern.split(nextLine);
        int tokenCount = tokens.length;
        String chrToken = tokens[0];
        String chr = this.genome == null ? chrToken : this.genome.getChromosomeAlias(chrToken);
        int start = Integer.parseInt(tokens[1]);
        int end = Integer.parseInt(tokens[2]);
        String name = tokens[3];
        float combinedScore = Float.parseFloat(tokens[4]);
        int nTimePoints = tokenCount - 5;
        float[] timePointScores = new float[nTimePoints];
        for (int i = 0; i < nTimePoints; ++i) {
            timePointScores[i] = Float.parseFloat(tokens[5 + i]);
        }
        return new Peak(chr, start, end, name, combinedScore, timePointScores);
    }

    public boolean canDecode(String path) {
        return false;
    }
}

