/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.lists;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.lists.VariantListEntry;
import org.broad.igv.lists.VariantListNavigator;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class VariantListManager {
    static List<VariantListEntry> variantList = new ArrayList<VariantListEntry>();
    static Map<String, String> samplePathMap = new HashMap<String, String>();

    public static void openNavigator(Frame frame) {
        new VariantListNavigator(frame).setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadVariants(ResourceLocator locator) throws IOException {
        BufferedReader reader = null;
        try {
            String nextLine;
            reader = ParsingUtils.openBufferedReader(locator.getPath());
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#")) continue;
                String[] tokens = nextLine.split("\\s+");
                if (tokens.length != 3) {
                    System.err.println("Unexpected number of tokens: " + tokens.length);
                }
                String chr = tokens[0];
                int position = Integer.parseInt(tokens[1]);
                String[] samples = tokens[2].split(",");
                variantList.add(new VariantListEntry(chr, position, samples));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSamplePathMap(ResourceLocator locator) throws IOException {
        BufferedReader reader = null;
        try {
            String nextLine;
            reader = ParsingUtils.openBufferedReader(locator.getPath());
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#")) continue;
                String[] tokens = nextLine.split("\\s+");
                if (tokens.length != 2) {
                    System.err.println("Unexpected number of tokens: " + tokens.length);
                }
                String sample = tokens[0];
                String path = tokens[1];
                samplePathMap.put(sample, path);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

