/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.awt.Color;
import java.util.List;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.MultiMap;
import org.broad.tribble.Feature;

public class VCFFeature
implements IGVFeature,
Feature {
    private String chr;
    private int start;
    private String id = "";
    private String name;
    private String ref;
    private String alt;
    private float quality;
    private String filter;
    private String info;

    public VCFFeature(String chr, int start, String id, String ref, String alt, float quality, String filter, String info) {
        this.chr = chr;
        this.start = start;
        this.id = id;
        this.ref = ref;
        this.alt = alt;
        this.name = "";
        this.quality = quality;
        this.filter = filter;
        this.info = info.replace(";", "<br>");
    }

    @Override
    public float getScore() {
        return this.getQuality();
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        StringBuffer buf = new StringBuffer();
        if (this.id != null && this.id.length() > 0) {
            buf.append(this.id + "<br>");
        }
        buf.append(this.ref + "->" + this.alt + "<br>");
        buf.append("QUAL = " + this.quality + "<br>");
        buf.append("FILTER = " + this.filter + "<br>");
        buf.append("--------------<br>");
        buf.append(this.info);
        return buf.toString();
    }

    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.start + 1;
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    public boolean hasScore() {
        return false;
    }

    public LocusScore copy() {
        throw new UnsupportedOperationException("Copy not supported");
    }

    @Override
    public Strand getStrand() {
        return Strand.NONE;
    }

    public boolean hasStrand() {
        return false;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Copy not supported");
    }

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public boolean contains(IGVFeature feature) {
        return false;
    }

    @Override
    public List<Exon> getExons() {
        return null;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public MultiMap<String, String> getAttributes() {
        return null;
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.start && location < (double)(this.start + 1);
    }

    @Override
    public String getURL() {
        return null;
    }

    public Exon getExonAt(double location) {
        return null;
    }

    @Override
    public void setEnd(int end) {
        throw new UnsupportedOperationException("setEnd not supported");
    }

    @Override
    public String getType() {
        return "VCF";
    }

    public String getChr() {
        return this.chr;
    }

    public void setChr(String chr) {
        throw new UnsupportedOperationException("setEnd not supported");
    }

    public float getQuality() {
        return this.quality;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getInfo() {
        return this.info;
    }

    public String getLocusString() {
        return this.getChr() + ":" + this.getStart() + ":" + this.getEnd();
    }
}

