/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.genome.ChromosomeComparator;
import org.broad.igv.feature.genome.ChromosomeCoordinate;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.track.FeatureTrack;

public class Genome {
    private static Logger log = Logger.getLogger(Genome.class);
    public static final int MAX_WHOLE_GENOME = 10000;
    private String id;
    private String displayName;
    private List<String> chromosomeNames;
    private ArrayList<String> longChromosomeNames;
    private LinkedHashMap<String, Chromosome> chromosomeMap;
    private long totalLength = -1L;
    private long nominalLength = -1L;
    private Map<String, Long> cumulativeOffsets = new HashMap<String, Long>();
    private Map<String, String> chrAliasTable;
    private Sequence sequence;
    private FeatureTrack geneTrack;
    private String species;
    private static Map<String, String> ucscSpeciesMap;

    public Genome(String id, String displayName, Sequence sequence, boolean chromosOrdered) {
        this.id = id;
        this.displayName = displayName;
        this.chrAliasTable = new HashMap<String, String>();
        this.sequence = sequence;
        this.chromosomeNames = sequence.getChromosomeNames();
        ArrayList<Chromosome> tmpChromos = new ArrayList<Chromosome>(this.chromosomeNames.size());
        int maxLength = -1;
        this.chromosomeMap = new LinkedHashMap(tmpChromos.size());
        for (int i = 0; i < this.chromosomeNames.size(); ++i) {
            String chr = this.chromosomeNames.get(i);
            int length = sequence.getChromosomeLength(chr);
            maxLength = Math.max(maxLength, length);
            Chromosome chromo = new Chromosome(i, chr, length);
            tmpChromos.add(chromo);
            if (!chromosOrdered) continue;
            this.chromosomeMap.put(chr, chromo);
        }
        if (!chromosOrdered) {
            ChromosomeComparator.sortChromosomeList(tmpChromos, maxLength / 10, this.chromosomeMap);
            this.chromosomeNames = new ArrayList<String>(this.chromosomeMap.keySet());
        }
        this.initializeChromosomeAliases();
    }

    public Genome(String id, List<Chromosome> chromosomes) {
        this.id = id;
        this.displayName = id;
        this.chrAliasTable = new HashMap<String, String>();
        this.sequence = null;
        this.chromosomeNames = new ArrayList<String>(chromosomes.size());
        this.chromosomeMap = new LinkedHashMap(chromosomes.size());
        for (Chromosome chromosome : chromosomes) {
            this.chromosomeNames.add(chromosome.getName());
            this.chromosomeMap.put(chromosome.getName(), chromosome);
        }
        this.initializeChromosomeAliases();
    }

    public String getChromosomeAlias(String str) {
        if (str == null) {
            return str;
        }
        if (!this.chrAliasTable.containsKey(str)) {
            this.chrAliasTable.put(str, str);
        }
        return this.chrAliasTable.get(str);
    }

    public Map<String, String> getChrAliasTable() {
        return this.chrAliasTable;
    }

    public void addChrAliases(Collection<Collection<String>> synonymsList) {
        if (this.chrAliasTable == null) {
            this.chrAliasTable = new HashMap<String, String>();
        }
        HashSet<String> chrNameSet = new HashSet<String>(this.chromosomeNames);
        for (Collection<String> synonyms : synonymsList) {
            String chr = null;
            for (String syn : synonyms) {
                if (!chrNameSet.contains(syn)) continue;
                chr = syn;
                break;
            }
            if (chr == null) continue;
            for (String syn : synonyms) {
                this.chrAliasTable.put(syn, chr);
            }
        }
    }

    void initializeChromosomeAliases() {
        this.chrAliasTable.putAll(this.getAutoAliases());
    }

    Map<String, String> getAutoAliases() {
        HashMap<String, String> autoAliases = new HashMap<String, String>();
        for (String name : this.chromosomeNames) {
            if (!name.startsWith("gi|")) continue;
            String string = Genome.getNCBIName(name);
            autoAliases.put(string, name);
        }
        if (this.chromosomeNames.size() < 10000) {
            for (String name : this.chromosomeNames) {
                if (name.toLowerCase().startsWith("chr")) {
                    autoAliases.put(name.substring(3), name);
                    continue;
                }
                autoAliases.put("chr" + name, name);
            }
            if (this.id.startsWith("hg") || this.id.equalsIgnoreCase("1kg_ref")) {
                autoAliases.put("23", "chrX");
                autoAliases.put("24", "chrY");
                autoAliases.put("MT", "chrM");
            } else if (this.id.startsWith("mm")) {
                autoAliases.put("21", "chrX");
                autoAliases.put("22", "chrY");
                autoAliases.put("MT", "chrM");
            } else if (this.id.equals("b37")) {
                autoAliases.put("chrM", "MT");
                autoAliases.put("chrX", "23");
                autoAliases.put("chrY", "24");
            }
            ArrayList aliasEntries = new ArrayList(autoAliases.entrySet());
            for (Map.Entry entry : aliasEntries) {
                String illuminaName;
                String alias = (String)entry.getKey();
                String chr = (String)entry.getValue();
                if (!alias.endsWith(".fa")) {
                    illuminaName = alias + ".fa";
                    autoAliases.put(illuminaName, chr);
                }
                if (chr.endsWith(".fa")) continue;
                illuminaName = chr + ".fa";
                autoAliases.put(illuminaName, chr);
            }
        }
        return autoAliases;
    }

    public static String getNCBIName(String name) {
        String[] tokens = name.split("\\|");
        return tokens[tokens.length - 1];
    }

    public String getHomeChromosome() {
        if (this.chromosomeNames.size() == 1 || this.chromosomeNames.size() > 10000) {
            return this.chromosomeNames.get(0);
        }
        return "All";
    }

    public Chromosome getChromosome(String chrName) {
        return this.chromosomeMap.get(this.getChromosomeAlias(chrName));
    }

    public List<String> getAllChromosomeNames() {
        return this.chromosomeNames;
    }

    public Collection<Chromosome> getChromosomes() {
        return this.chromosomeMap.values();
    }

    public long getTotalLength() {
        if (this.totalLength < 0L) {
            this.totalLength = 0L;
            for (Chromosome chr : this.chromosomeMap.values()) {
                this.totalLength += (long)chr.getLength();
            }
        }
        return this.totalLength;
    }

    public long getCumulativeOffset(String chr) {
        Long cumOffset = this.cumulativeOffsets.get(chr);
        if (cumOffset == null) {
            long offset = 0L;
            for (String c : this.getLongChromosomeNames()) {
                if (chr.equals(c)) break;
                offset += (long)this.getChromosome(c).getLength();
            }
            cumOffset = new Long(offset);
            this.cumulativeOffsets.put(chr, cumOffset);
        }
        return cumOffset;
    }

    public int getGenomeCoordinate(String chr, int locationBP) {
        return (int)((this.getCumulativeOffset(chr) + (long)locationBP) / 1000L);
    }

    public ChromosomeCoordinate getChromosomeCoordinate(int genomeKBP) {
        long cumOffset = 0L;
        List<String> wgChrNames = this.getLongChromosomeNames();
        for (String c : wgChrNames) {
            int chrLen = this.getChromosome(c).getLength();
            if ((cumOffset + (long)chrLen) / 1000L > (long)genomeKBP) {
                int bp = (int)((long)(genomeKBP * 1000) - cumOffset);
                return new ChromosomeCoordinate(c, bp);
            }
            cumOffset += (long)chrLen;
        }
        String c = wgChrNames.get(wgChrNames.size() - 1);
        int bp = (int)((long)genomeKBP - cumOffset) * 1000;
        return new ChromosomeCoordinate(c, bp);
    }

    public String getId() {
        return this.id;
    }

    public String getSpecies() {
        if (this.species == null) {
            this.species = Genome.getSpeciesForID(this.id);
        }
        return this.species;
    }

    public String getNextChrName(String chr) {
        List<String> chrList = this.getLongChromosomeNames();
        for (int i = 0; i < chrList.size() - 1; ++i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i + 1);
        }
        return null;
    }

    public String getPrevChrName(String chr) {
        List<String> chrList = this.getLongChromosomeNames();
        for (int i = chrList.size() - 1; i > 0; --i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i - 1);
        }
        return null;
    }

    public byte[] getSequence(String chr, int start, int end) {
        if (this.sequence == null) {
            return null;
        }
        Chromosome c = this.getChromosome(chr);
        if (c == null) {
            return null;
        }
        if ((end = Math.min(end, c.getLength())) <= start) {
            return null;
        }
        return this.sequence.getSequence(chr, start, end);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public byte getReference(String chr, int pos) {
        return this.sequence == null ? null : Byte.valueOf(this.sequence.getBase(chr, pos));
    }

    public void setCytobands(LinkedHashMap<String, List<Cytoband>> chrCytoMap) {
        for (Map.Entry<String, List<Cytoband>> entry : chrCytoMap.entrySet()) {
            String chr = entry.getKey();
            List<Cytoband> cytobands = entry.getValue();
            Chromosome chromosome = this.chromosomeMap.get(chr);
            if (chromosome == null) continue;
            chromosome.setCytobands(cytobands);
        }
    }

    public void setGeneTrack(FeatureTrack geneFeatureTrack) {
        this.geneTrack = geneFeatureTrack;
    }

    public FeatureTrack getGeneTrack() {
        return this.geneTrack;
    }

    public List<String> getLongChromosomeNames() {
        if (this.longChromosomeNames == null) {
            int length;
            Chromosome chr;
            this.longChromosomeNames = new ArrayList(this.getAllChromosomeNames().size());
            long genomeLength = this.getTotalLength();
            int maxChromoLength = -1;
            for (String chrName : this.getAllChromosomeNames()) {
                chr = this.getChromosome(chrName);
                length = chr.getLength();
                maxChromoLength = Math.max(maxChromoLength, length);
                if ((long)length <= genomeLength / 3000L) continue;
                this.longChromosomeNames.add(chrName);
            }
            if (this.longChromosomeNames.size() == 0) {
                for (String chrName : this.getAllChromosomeNames()) {
                    chr = this.getChromosome(chrName);
                    length = chr.getLength();
                    if (length <= maxChromoLength / 2) continue;
                    this.longChromosomeNames.add(chrName);
                }
            }
        }
        return this.longChromosomeNames;
    }

    public long getNominalLength() {
        if (this.nominalLength < 0L) {
            this.nominalLength = 0L;
            for (String chrName : this.getLongChromosomeNames()) {
                Chromosome chr = this.getChromosome(chrName);
                this.nominalLength += (long)chr.getLength();
            }
        }
        return this.nominalLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getSpeciesForID(String id) {
        if (ucscSpeciesMap == null) {
            ucscSpeciesMap = new HashMap<String, String>();
            InputStream is = null;
            try {
                String nextLine;
                is = Genome.class.getResourceAsStream("speciesMapping.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((nextLine = br.readLine()) != null) {
                    if (nextLine.startsWith("#")) continue;
                    String[] tokens = Globals.tabPattern.split(nextLine);
                    if (tokens.length == 2) {
                        ucscSpeciesMap.put(tokens[0], tokens[1]);
                        continue;
                    }
                    log.error((Object)("Unexpected number of tokens in species mapping file for line: " + nextLine));
                }
            }
            catch (IOException e) {
                log.error((Object)"Error reading species mapping table", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"", (Throwable)e);
                    }
                }
            }
        }
        for (Map.Entry<String, String> entry : ucscSpeciesMap.entrySet()) {
            if (!id.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }
}

