/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.broad.igv.dev.db.DBManager;
import org.broad.igv.dev.db.DBProfile;
import org.broad.igv.dev.db.DBReader;
import org.broad.igv.util.ResourceLocator;

public abstract class WholeTableDBReader<T>
extends DBReader {
    private static Logger log = Logger.getLogger(WholeTableDBReader.class);

    public WholeTableDBReader(DBProfile.DBTable table) {
        super(table);
    }

    public WholeTableDBReader(ResourceLocator locator, String tableName, String baseQueryString) {
        super(locator, tableName, baseQueryString);
    }

    public T load() {
        T obj = null;
        ResultSet rs = null;
        try {
            rs = super.executeQuery(this.baseQueryString);
            obj = this.processResultSet(rs);
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Database error", (Throwable)e);
                throw new RuntimeException("Database error", e);
            }
            catch (Throwable throwable) {
                DBManager.closeAll(rs);
                throw throwable;
            }
        }
        DBManager.closeAll(rs);
        return obj;
    }

    protected abstract T processResultSet(ResultSet var1) throws SQLException;
}

