/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import org.broad.igv.data.BasicScore;
import org.broad.igv.track.WindowFunction;

public class Segment
extends BasicScore {
    private int extendedStart = -1;
    private int extendedEnd = -1;
    private String description;

    public Segment(int start, int end, float score) {
        super(start, end, score);
        if (this.extendedStart < 0) {
            this.extendedStart = start;
        }
        if (this.extendedEnd < 0) {
            this.extendedEnd = end;
        }
    }

    public Segment(int start, int origStart, int end, int origEnd, float value, String description) {
        super(start, end, value);
        this.extendedStart = origStart;
        this.extendedEnd = origEnd;
        this.description = description;
    }

    @Override
    public Segment copy() {
        return new Segment(this.start, this.extendedStart, this.end, this.extendedEnd, this.score, this.description);
    }

    @Override
    public String getValueString(double position, WindowFunction ignored) {
        String valueString = "Value: " + this.getScore();
        if (this.description != null) {
            valueString = valueString + this.description;
        }
        return valueString;
    }

    public String getDescription() {
        return this.description;
    }
}

