/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.rnai;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.expression.ProbeToLocusMap;
import org.broad.igv.data.rnai.RNAIDataSource;
import org.broad.igv.data.rnai.RNAIGeneScore;
import org.broad.igv.data.rnai.RNAIHairpinCache;
import org.broad.igv.data.rnai.RNAIHairpinValue;
import org.broad.igv.exceptions.LoadResourceFromServerException;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.readers.AsciiLineReader;

public class RNAIGCTDatasetParser {
    private static Logger log = Logger.getLogger(RNAIGCTDatasetParser.class);
    private ResourceLocator dataFileLocator;
    private int dataStartColumn = 2;
    private int descriptionColumn = 1;
    Genome genome;
    public static final String RNAI_MAPPING_URL_KEY = "RNAI_MAPPING_URL";
    private static final String DEFAULT_RNAI_MAPPING_URL = "http://www.broadinstitute.org/igv/resources/probes/rnai/RNAI_probe_mapping.txt.gz";
    private static String RNAI_MAPPING_URL = IGV.hasInstance() ? IGV.getInstance().getSession().getPersistent("RNAI_MAPPING_URL", "http://www.broadinstitute.org/igv/resources/probes/rnai/RNAI_probe_mapping.txt.gz") : PreferenceManager.getInstance().getPersistent("RNAI_MAPPING_URL", "http://www.broadinstitute.org/igv/resources/probes/rnai/RNAI_probe_mapping.txt.gz");
    private static Map<String, String[]> rnaiProbeMap = null;

    public RNAIGCTDatasetParser(ResourceLocator gctFile, Genome genome) {
        this.dataFileLocator = gctFile;
        this.genome = genome;
        this.dataStartColumn = 2;
    }

    public Collection<RNAIDataSource> parse() {
        AsciiLineReader reader = null;
        List dataSources = null;
        String nextLine = null;
        InputStream probeMappingStream = null;
        try {
            reader = ParsingUtils.openAsciiReader(this.dataFileLocator);
            String headerLine = null;
            nextLine = reader.readLine();
            nextLine = reader.readLine();
            headerLine = reader.readLine();
            int skip = 1;
            String[] tokens = Globals.tabPattern.split(headerLine, -1);
            int nTokens = tokens.length;
            String description = nTokens > this.descriptionColumn ? new String(tokens[this.descriptionColumn]) : null;
            int nColumns = (nTokens - this.dataStartColumn) / skip;
            String[] columnHeadings = new String[nColumns];
            for (int i = 0; i < nColumns; ++i) {
                String heading;
                columnHeadings[i] = heading = tokens[this.dataStartColumn + i * skip].replace('\"', ' ').trim();
            }
            Map<String, String[]> rnaiProbeMap = RNAIGCTDatasetParser.getProbeMap();
            HashMap<String, HashMap<String, Float>> sampleGeneScoreMap = new HashMap<String, HashMap<String, Float>>();
            while ((nextLine = reader.readLine()) != null) {
                tokens = Globals.tabPattern.split(nextLine, -1);
                nTokens = tokens.length;
                String probeId = new String(tokens[0]);
                float[] values = new float[nColumns];
                String[] identifiers = rnaiProbeMap.get(probeId);
                String identifier = null;
                if (identifiers == null || identifiers.length == 0) {
                    log.info((Object)("Could not find mapping for: " + probeId));
                    continue;
                }
                identifier = identifiers[0];
                NamedFeature gene = FeatureDB.getFeature(identifier.toUpperCase());
                if (gene == null) {
                    log.debug((Object)("Unknown identifier: " + identifier));
                    continue;
                }
                for (int i = 0; i < nColumns; ++i) {
                    try {
                        Float geneScore;
                        int dataIndex = this.dataStartColumn + i * skip;
                        values[i] = dataIndex >= nTokens || tokens[dataIndex].length() == 0 ? Float.NaN : Float.parseFloat(tokens[dataIndex]);
                        String sample = columnHeadings[i];
                        RNAIHairpinValue hairpin = new RNAIHairpinValue(probeId, values[i]);
                        RNAIHairpinCache.getInstance().addHairpinScore(sample, gene.getName(), hairpin);
                        HashMap<String, Float> geneScoreMap = sampleGeneScoreMap.get(sample);
                        if (geneScoreMap == null) {
                            geneScoreMap = new HashMap();
                            sampleGeneScoreMap.put(sample, geneScoreMap);
                        }
                        if ((geneScore = geneScoreMap.get(gene.getName())) == null) {
                            geneScore = Float.valueOf(values[i]);
                            geneScoreMap.put(gene.getName(), geneScore);
                            continue;
                        }
                        geneScore = new Float(Math.min(values[i], geneScore.floatValue()));
                        geneScoreMap.put(gene.getName(), geneScore);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        values[i] = Float.NaN;
                    }
                }
            }
            dataSources = this.computeGeneScores(sampleGeneScoreMap);
        }
        catch (IOException ex) {
            log.error((Object)"Error parsing RNAi file", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (probeMappingStream != null) {
                try {
                    probeMappingStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing probe mapping stream", (Throwable)e);
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
        return dataSources;
    }

    private List computeGeneScores(HashMap<String, HashMap<String, Float>> sampleGeneScoreMap) {
        int confidence = 3;
        ArrayList<RNAIDataSource> dataSources = new ArrayList<RNAIDataSource>();
        for (String sample : sampleGeneScoreMap.keySet()) {
            HashMap<String, Float> geneMap = sampleGeneScoreMap.get(sample);
            RNAIDataSource ds = new RNAIDataSource(sample, "", this.genome);
            for (String gene : geneMap.keySet()) {
                Float score = geneMap.get(gene);
                Collection<RNAIHairpinValue> hairpins = RNAIHairpinCache.getInstance().getHairpinScores(sample, gene);
                int numHairpins = hairpins == null ? 0 : hairpins.size();
                ds.addGeneScore(new RNAIGeneScore(sample, FeatureDB.getFeature(gene), score.floatValue(), numHairpins));
            }
            dataSources.add(ds);
        }
        return dataSources;
    }

    private static synchronized Map<String, String[]> getProbeMap() throws IOException {
        if (rnaiProbeMap == null) {
            rnaiProbeMap = Collections.synchronizedMap(new HashMap(20000));
            URL url = new URL(RNAI_MAPPING_URL);
            InputStream probeMappingStream = null;
            try {
                probeMappingStream = new GZIPInputStream(HttpUtils.getInstance().openConnectionStream(url));
                AsciiLineReader br = new AsciiLineReader(probeMappingStream);
                ProbeToLocusMap.getInstance().loadMapping(br, rnaiProbeMap);
            }
            catch (Exception e) {
                throw new LoadResourceFromServerException(e.getMessage(), RNAI_MAPPING_URL, e.getClass().getSimpleName());
            }
            finally {
                if (probeMappingStream != null) {
                    probeMappingStream.close();
                }
            }
        }
        return rnaiProbeMap;
    }
}

