/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.broad.igv.data.FeatureBin;
import org.broad.igv.feature.LocusScore;

public class FeatureBinCalculator {
    public List<FeatureBin> computeFeatureBins(List<? extends LocusScore> features, int nFeatureBins, double binSize, int startLocation, int endLocation) {
        TreeMap<Integer, FeatureBin> featureBins = new TreeMap<Integer, FeatureBin>();
        for (LocusScore locusScore : features) {
            int binStart = (int)((double)(locusScore.getStart() - startLocation) / binSize);
            int binEnd = (int)((double)(locusScore.getEnd() - startLocation) / binSize);
            if (binEnd < 0 || binStart >= nFeatureBins) continue;
            int lastBin = Math.min(binEnd + 1, nFeatureBins);
            for (int b = Math.max(0, binStart); b < lastBin; ++b) {
                FeatureBin fBin = (FeatureBin)featureBins.get(b);
                if (fBin == null) {
                    int location = (int)((double)startLocation + (double)b * binSize);
                    fBin = new FeatureBin(location);
                    featureBins.put(b, fBin);
                }
                fBin.addFeature(locusScore);
            }
        }
        Collection c = featureBins.values();
        return new ArrayList<FeatureBin>(featureBins.values());
    }
}

