/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin.ui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.ui.ArgumentPanel;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.variant.VariantTrack;

public class TrackArgument
extends ArgumentPanel {
    private JComboBox trackComboBox;

    public TrackArgument(Argument argument) {
        this.initComponents();
        super.initCommon(argument);
        if (argument != null) {
            Class clazz;
            List<Track> trackList = IGV.getInstance().getAllTracks();
            Iterable tracks = Iterables.filter(trackList, (Class)(clazz = this.getTrackClass(argument)));
            ArrayList filteredTrackList = Lists.newArrayList((Iterable)tracks);
            if (filteredTrackList.size() == 0) {
                throw new IllegalStateException("No tracks found of appropriate type; make sure data is loaded");
            }
            this.trackComboBox.setModel(new DefaultComboBoxModel<Object>(filteredTrackList.toArray()));
            this.trackComboBox.setRenderer(new TrackComboBoxRenderer());
        }
    }

    private void initComponents() {
        this.trackComboBox = new JComboBox();
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.trackComboBox);
    }

    @Override
    public Track getValue() {
        return (Track)this.trackComboBox.getSelectedItem();
    }

    public Class getTrackClass(Argument argument) {
        switch (argument.getType()) {
            case VARIANT_TRACK: {
                return VariantTrack.class;
            }
            case FEATURE_TRACK: {
                return FeatureTrack.class;
            }
            case ALIGNMENT_TRACK: {
                return AlignmentTrack.class;
            }
            case DATA_TRACK: {
                return DataTrack.class;
            }
        }
        throw new IllegalArgumentException("Argument does not specify a track type; specifies " + (Object)((Object)argument.getType()));
    }

    public static class TrackComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Track track = (Track)value;
            String toShow = "No Tracks Found";
            if (track != null) {
                toShow = track.getName();
            }
            return super.getListCellRendererComponent((JList<?>)list, toShow, index, isSelected, cellHasFocus);
        }
    }
}

