/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.AsciiDecoder;
import org.broad.igv.cli_plugin.AsciiEncoder;
import org.broad.igv.cli_plugin.FeatureCodecDecoder;
import org.broad.igv.cli_plugin.FeatureDecoder;
import org.broad.igv.cli_plugin.FeatureEncoder;
import org.broad.igv.cli_plugin.LineFeatureDecoder;
import org.broad.igv.cli_plugin.LineFeatureEncoder;
import org.broad.igv.cli_plugin.PluginSpecReader;
import org.broad.igv.cli_plugin.SamAlignmentEncoder;
import org.broad.igv.cli_plugin.VCFEncoder;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.RuntimeUtils;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.bed.SimpleBEDFeature;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class PluginSource<E extends Feature, D extends Feature> {
    private static Logger log = Logger.getLogger(PluginSource.class);
    @XmlList
    @XmlAttribute
    protected List<String> commands;
    @XmlJavaTypeAdapter(value=MyMapAdapter.class)
    protected LinkedHashMap<Argument, Object> arguments;
    @XmlElement
    protected PluginSpecReader.Parser parser;
    protected URL[] decodingLibURLs = new URL[0];
    @XmlAttribute
    protected String specPath = null;
    protected List<Map<String, Object>> attributes = new ArrayList<Map<String, Object>>(2);
    protected String lastRunId;
    private static final String RUN_ID_ATTR = "RUN_ID";

    protected PluginSource() {
    }

    public PluginSource(List<String> commands, LinkedHashMap<Argument, Object> arguments, PluginSpecReader.Output outputAttrs, String specPath) {
        this.commands = commands;
        this.arguments = arguments;
        this.parser = outputAttrs.parser;
        this.specPath = specPath;
        String[] libs = this.parser.libs;
        libs = libs != null ? libs : new String[]{};
        try {
            this.decodingLibURLs = PluginSpecReader.getLibURLs(libs, FileUtils.getParent(specPath));
        }
        catch (MalformedURLException e) {
            log.error((Object)"Error parsing library URL", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected final Map<String, Object> writeFeaturesToStream(OutputStream outputStream, Iterator features, Argument argument) throws IOException {
        Map<String, Object> attributes = null;
        if (features != null) {
            FeatureEncoder<E> codec = this.getEncodingCodec(argument);
            attributes = codec.encodeAll(outputStream, features);
        }
        outputStream.flush();
        outputStream.close();
        return attributes;
    }

    protected final String[] genFullCommand(String chr, int start, int end, int zoom) throws IOException {
        ArrayList<String> fullCmd = new ArrayList<String>(this.commands);
        this.attributes.clear();
        String runId = this.createNewRunId();
        HashMap<String, String> idVariables = new HashMap<String, String>(this.arguments.size());
        idVariables.put(RUN_ID_ATTR, runId);
        block8: for (Map.Entry<Argument, Object> entry : this.arguments.entrySet()) {
            Argument arg = entry.getKey();
            if (!arg.isValidValue(entry.getValue())) {
                String msg = "Type: " + (Object)((Object)arg.getType()) + " value: " + entry.getValue();
                throw new IllegalArgumentException(msg);
            }
            String[] sVal = null;
            String ts = null;
            switch (arg.getType()) {
                case BOOL: {
                    boolean selected = (Boolean)entry.getValue();
                    if (!selected) continue block8;
                    break;
                }
                case LONGTEXT: 
                case TEXT: {
                    ts = (String)entry.getValue();
                    if (ts == null || ts.trim().length() == 0) continue block8;
                    sVal = new String[]{ts};
                    if (arg.getType() != Argument.InputType.TEXT) break;
                    sVal = ts.split("\\s+");
                    break;
                }
                case ALIGNMENT_TRACK: {
                    ts = this.createTempFile((AlignmentTrack)entry.getValue(), arg, chr, start, end, zoom);
                    sVal = new String[]{ts};
                    break;
                }
                case VARIANT_TRACK: 
                case FEATURE_TRACK: 
                case DATA_TRACK: {
                    ts = this.createTempFile((Track)entry.getValue(), arg, chr, start, end, zoom);
                    sVal = new String[]{ts};
                    break;
                }
                case MULTI_FEATURE_TRACK: {
                    sVal = this.createTempFiles((List)entry.getValue(), arg, chr, start, end, zoom);
                    break;
                }
                case LOCUS: {
                    ts = this.writeLocus(arg, chr, start, end);
                    sVal = new String[]{ts};
                }
            }
            if (arg.getId() != null && sVal != null) {
                idVariables.put(arg.getId(), sVal[0]);
            }
            if (!arg.isOutput()) continue;
            String cmdArg = arg.getCmdArg();
            if (cmdArg.trim().length() > 0) {
                cmdArg = this.replaceStringsFromIds(cmdArg, idVariables);
                fullCmd.add(cmdArg);
            }
            if (sVal == null) continue;
            fullCmd.addAll(Arrays.asList(sVal));
        }
        this.parser.source = this.replaceStringsFromIds(this.parser.source, idVariables);
        return fullCmd.toArray(new String[0]);
    }

    protected String writeLocus(Argument arg, String chr, int start, int end) throws IOException {
        SimpleBEDFeature feat = new SimpleBEDFeature(start, end, chr);
        return this.createTempFile(Arrays.asList(feat), arg);
    }

    private String replaceStringsFromIds(String inputString, Map<String, String> idVariables) {
        for (String argId : idVariables.keySet()) {
            inputString = inputString.replace("$" + argId, idVariables.get(argId));
        }
        return inputString;
    }

    protected String createNewRunId() {
        this.lastRunId = "" + System.currentTimeMillis();
        return this.lastRunId;
    }

    String getLastRunId() {
        return this.lastRunId;
    }

    private String[] createTempFiles(List<FeatureTrack> tracks, Argument argument, String chr, int start, int end, int zoom) throws IOException {
        String[] fileNames = new String[tracks.size()];
        int fi = 0;
        for (FeatureTrack track : tracks) {
            fileNames[fi++] = this.createTempFile(track, argument, chr, start, end, zoom);
        }
        return fileNames;
    }

    protected abstract String createTempFile(Track var1, Argument var2, String var3, int var4, int var5, int var6) throws IOException;

    protected final String createTempFile(List features, Argument argument) throws IOException {
        String ext = ".tmp";
        switch (argument.getType()) {
            case ALIGNMENT_TRACK: {
                ext = ext + ".sam";
                break;
            }
            case LOCUS: {
                ext = ext + ".bed";
            }
        }
        File outFile = File.createTempFile("features", ext, null);
        outFile.deleteOnExit();
        Map<String, Object> attributes = this.writeFeaturesToStream(new FileOutputStream(outFile), features.iterator(), argument);
        String path = outFile.getAbsolutePath();
        this.attributes.add(attributes);
        return path;
    }

    protected List<Alignment> getAlignmentsForRange(AlignmentTrack track, String chr, int start, int end, int zoom) throws IOException {
        Collection<AlignmentInterval> loadedIntervals = track.getDataManager().getAllLoadedIntervals();
        ArrayList<Alignment> alignments = new ArrayList<Alignment>();
        for (AlignmentInterval interval : loadedIntervals) {
            if (!interval.overlaps(chr, start, end)) continue;
            Iterator<Alignment> iter = interval.getAlignmentIterator();
            while (iter.hasNext()) {
                Alignment al = iter.next();
                if (al.getStart() > end || al.getEnd() < start) continue;
                alignments.add(al);
            }
        }
        return alignments;
    }

    protected final Iterator<D> getFeatures(String chr, int start, int end, int zoom) throws IOException {
        File inFile;
        if (this.parser.source == null) {
            throw new IllegalStateException("Null value for source");
        }
        boolean rerun = true;
        InputStream dataStream = null;
        if (!rerun && (inFile = new File(this.parser.source)).canRead()) {
            dataStream = new FileInputStream(this.parser.source);
        }
        if (dataStream == null) {
            String[] fullCmd = this.genFullCommand(chr, start, end, zoom);
            Process pr = RuntimeUtils.startExternalProcess(fullCmd, null, null);
            if (this.parser.source.equals(PluginSpecReader.Parser.SOURCE_STDOUT)) {
                dataStream = pr.getInputStream();
            } else {
                try {
                    pr.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                dataStream = new FileInputStream(this.parser.source);
            }
        }
        FeatureDecoder<D> codec = this.getDecodingCodec();
        return codec.decodeAll(dataStream, this.parser.strict);
    }

    protected final FeatureEncoder<E> getEncodingCodec(Argument argument) {
        FeatureEncoder codec = this.instantiateEncodingCodec(argument);
        codec.setInputs(Collections.unmodifiableList(this.commands), Collections.unmodifiableMap(this.arguments), argument);
        return codec;
    }

    private final FeatureEncoder instantiateEncodingCodec(Argument argument) {
        String encodingCodec = argument.getEncodingCodec();
        if (encodingCodec == null) {
            switch (argument.getType()) {
                case FEATURE_TRACK: 
                case MULTI_FEATURE_TRACK: 
                case LOCUS: {
                    return new AsciiEncoder<Feature>(new IGVBEDCodec());
                }
                case ALIGNMENT_TRACK: {
                    return new SamAlignmentEncoder();
                }
                case VARIANT_TRACK: {
                    return new VCFEncoder();
                }
            }
            throw new IllegalArgumentException("No encoding codec provided and default not available");
        }
        try {
            URLClassLoader loader;
            Class<?> clazz;
            Constructor<?> constructor;
            Object ocodec;
            URL[] libURLs = PluginSpecReader.getLibURLs(argument.getLibPaths(), FileUtils.getParent(this.specPath));
            if (libURLs == null) {
                libURLs = new URL[]{};
            }
            AsciiEncoder codec = !((ocodec = (constructor = (clazz = (loader = URLClassLoader.newInstance(libURLs, this.getClass().getClassLoader())).loadClass(encodingCodec)).getConstructor(new Class[0])).newInstance(new Object[0])) instanceof FeatureEncoder) && ocodec instanceof LineFeatureEncoder ? new AsciiEncoder((LineFeatureEncoder)ocodec) : (AsciiEncoder)ocodec;
            return codec;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not find class " + encodingCodec), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Malformed library URL", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            log.error((Object)"Exception getting encoding codec", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected final FeatureDecoder<D> getDecodingCodec() {
        FeatureDecoder<D> codec = this.instantiateDecodingCodec(this.parser.decodingCodec, this.decodingLibURLs);
        codec.setInputs(Collections.unmodifiableList(this.commands), Collections.unmodifiableMap(this.arguments));
        codec.setAttributes(Collections.unmodifiableList(this.attributes));
        return codec;
    }

    protected final FeatureDecoder<D> instantiateDecodingCodec(String decodingCodec, URL[] libURLs) {
        if (decodingCodec == null) {
            FeatureCodec knownCodec = CodecFactory.getCodec("." + this.parser.format, GenomeManager.getInstance().getCurrentGenome());
            if (knownCodec == null) {
                throw new IllegalArgumentException("Unable to find codec for format " + this.parser.format);
            }
            if (knownCodec instanceof AsciiFeatureCodec) {
                return new AsciiDecoder.DecoderWrapper((AsciiFeatureCodec)knownCodec);
            }
            return new FeatureCodecDecoder(knownCodec);
        }
        try {
            URLClassLoader loader;
            Class<?> clazz;
            Constructor<?> constructor;
            Object codec;
            if (libURLs == null) {
                libURLs = new URL[]{};
            }
            if (!((codec = (constructor = (clazz = (loader = URLClassLoader.newInstance(libURLs, this.getClass().getClassLoader())).loadClass(decodingCodec)).getConstructor(new Class[0])).newInstance(new Object[0])) instanceof FeatureDecoder) && codec instanceof LineFeatureDecoder) {
                return new AsciiDecoder((LineFeatureDecoder)codec);
            }
            return (FeatureDecoder)codec;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not find class " + decodingCodec), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            log.error((Object)"Exception getting decoding codec", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void getPersistentState() {
    }

    public void updateTrackReferences(List<Track> allTracks) {
        MyMapAdapter.updateTrackReferences(this.arguments, allTracks);
    }

    public static final class MyMapAdapter
    extends XmlAdapter<XmlMap, LinkedHashMap<Argument, Object>> {
        public LinkedHashMap<Argument, Object> unmarshal(XmlMap v) throws Exception {
            LinkedHashMap<Argument, Object> argumentMap = new LinkedHashMap<Argument, Object>(v.arg.size());
            for (Argument argument : v.arg) {
                Object oVal = null;
                switch (argument.getType()) {
                    case BOOL: {
                        oVal = Boolean.parseBoolean(argument.value.get(0));
                        break;
                    }
                    case LONGTEXT: 
                    case TEXT: {
                        oVal = argument.value.get(0);
                        break;
                    }
                    case ALIGNMENT_TRACK: 
                    case FEATURE_TRACK: 
                    case DATA_TRACK: 
                    case MULTI_FEATURE_TRACK: {
                        oVal = MyMapAdapter.findTrackReference(argument, null);
                    }
                }
                argumentMap.put(argument, oVal);
            }
            return argumentMap;
        }

        private static Object findTrackReference(Argument argument, List<Track> allTracks) {
            Object oVal = null;
            switch (argument.getType()) {
                case MULTI_FEATURE_TRACK: {
                    ArrayList<FeatureTrack> inputTracks = new ArrayList<FeatureTrack>(argument.value.size());
                    for (String trackId : argument.value) {
                        inputTracks.add((FeatureTrack)IGVSessionReader.getMatchingTrack(trackId, allTracks));
                    }
                    oVal = inputTracks;
                    break;
                }
                case ALIGNMENT_TRACK: 
                case FEATURE_TRACK: 
                case DATA_TRACK: {
                    String trackId = argument.value.get(0);
                    oVal = IGVSessionReader.getMatchingTrack(trackId, allTracks);
                }
            }
            return oVal;
        }

        public static void updateTrackReferences(Map<Argument, Object> argumentMap, List<Track> allTracks) {
            for (Argument argument : argumentMap.keySet()) {
                if (argumentMap.get(argument) != null) continue;
                Object oVal = MyMapAdapter.findTrackReference(argument, allTracks);
                argumentMap.put(argument, oVal);
            }
        }

        public XmlMap marshal(LinkedHashMap<Argument, Object> v) throws Exception {
            XmlMap outMap = new XmlMap();
            for (Map.Entry<Argument, Object> loopEntry : v.entrySet()) {
                Argument argument = loopEntry.getKey();
                List<Object> values = null;
                switch (argument.getType()) {
                    case MULTI_FEATURE_TRACK: {
                        List lVal = (List)loopEntry.getValue();
                        values = new ArrayList(lVal.size());
                        for (FeatureTrack fTrack : lVal) {
                            values.add(fTrack.getId());
                        }
                        break;
                    }
                    case BOOL: {
                        String sval = Boolean.toString((Boolean)loopEntry.getValue());
                        values = Arrays.asList(sval);
                        break;
                    }
                    case LONGTEXT: 
                    case TEXT: {
                        String sval = (String)loopEntry.getValue();
                        values = Arrays.asList(sval);
                        break;
                    }
                    case ALIGNMENT_TRACK: 
                    case FEATURE_TRACK: 
                    case DATA_TRACK: {
                        String sval = ((Track)loopEntry.getValue()).getId();
                        values = Arrays.asList(sval);
                    }
                }
                argument.value = values;
                outMap.arg.add(argument);
            }
            return outMap;
        }
    }

    static class XmlMap {
        public List<Argument> arg = new ArrayList<Argument>();

        XmlMap() {
        }
    }
}

