/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.PluginSource;
import org.broad.igv.cli_plugin.PluginSpecReader;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.tribble.Feature;

public class PluginFeatureSource<E extends Feature, D extends Feature>
extends PluginSource
implements FeatureSource {
    private static Logger log = Logger.getLogger(PluginFeatureSource.class);
    @XmlAttribute
    private boolean forbidEmptyOutput;

    private PluginFeatureSource() {
    }

    public PluginFeatureSource(List<String> commands, LinkedHashMap<Argument, Object> arguments, PluginSpecReader.Output outputAttrs, String specPath) {
        this(commands, arguments, outputAttrs, specPath, false);
    }

    public PluginFeatureSource(List<String> commands, LinkedHashMap<Argument, Object> arguments, PluginSpecReader.Output outputAttrs, String specPath, boolean forbidEmptyOutput) {
        super(commands, arguments, outputAttrs, specPath);
        this.forbidEmptyOutput = forbidEmptyOutput;
    }

    @Override
    protected String createTempFile(Track track, Argument argument, String chr, int start, int end, int zoom) throws IOException {
        if (track instanceof AlignmentTrack) {
            List<Alignment> alignments = this.getAlignmentsForRange((AlignmentTrack)track, chr, start, end, zoom);
            return super.createTempFile(alignments, argument);
        }
        FeatureTrack fTrack = (FeatureTrack)track;
        List<Feature> features = fTrack.getFeatures(chr, start, end);
        if (features.size() == 0 && this.forbidEmptyOutput) {
            features = Arrays.asList(new Locus("XXXchr0XXX", 0, 1));
        }
        return super.createTempFile(features, argument);
    }

    public final Iterator<D> getFeatures(String chr, int start, int end) throws IOException {
        return super.getFeatures(chr, start, end, -1);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public final int getFeatureWindowSize() {
        int featureWindowSize = this.getMinSizeFromTracks(this.arguments.values());
        return featureWindowSize;
    }

    private int getMinSizeFromTracks(Iterable tracks) {
        int featureWindowSize = Integer.MAX_VALUE;
        for (Object val : tracks) {
            int tmpSize = Integer.MAX_VALUE;
            if (val instanceof FeatureTrack) {
                FeatureTrack track = (FeatureTrack)val;
                tmpSize = track.getFeatureWindowSize();
            } else if (val instanceof List) {
                featureWindowSize = this.getMinSizeFromTracks((List)val);
            }
            featureWindowSize = Math.min(featureWindowSize, tmpSize);
        }
        return featureWindowSize;
    }

    @Override
    public final void setFeatureWindowSize(int size) {
    }
}

