/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.PreferenceManager;
import org.broad.igv.charts.Axis;
import org.broad.igv.charts.ChartPanel;
import org.broad.igv.charts.ScatterPlotData;
import org.broad.igv.charts.XYDataModel;
import org.broad.igv.charts.XYDataPoint;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;

public class ScatterPlot {
    public static final Color VERY_LIGHT_GRAY = new Color(250, 250, 250);
    PaletteColorTable colorTable;
    ScatterPlotData spData;
    Axis xAxis = new Axis(Axis.Orientation.HORIZONTAL);
    Axis yAxis = new Axis(Axis.Orientation.VERTICAL);
    private XYDataModel dataModel;
    Set<XYDataPoint> selectedPoints;
    Rectangle pointShape = new Rectangle(7, 7);
    int offsetX;
    int offsetY;
    HashSet<String> filteredSeries;
    Map<TrackType, ContinuousColorScale> colorScales;

    public static boolean isDataCategory(String selectedCategory) {
        return selectedCategory.equals(TrackType.COPY_NUMBER.toString()) || selectedCategory.equals(TrackType.GENE_EXPRESSION.toString()) || selectedCategory.equals(TrackType.DNA_METHYLATION.toString());
    }

    public ScatterPlot(ScatterPlotData spData) {
        this.offsetX = this.pointShape.getBounds().width / 2;
        this.offsetY = this.pointShape.getBounds().height / 2;
        this.filteredSeries = new HashSet();
        this.colorScales = new HashMap<TrackType, ContinuousColorScale>();
        this.spData = spData;
    }

    public synchronized void setModel(XYDataModel dataModel) {
        this.dataModel = dataModel;
        this.colorTable = new PaletteColorTable(ColorUtilities.getPalette("Set 1"));
        double minX = Double.MAX_VALUE;
        double maxX = -minX;
        double minY = minX;
        double maxY = maxX;
        for (String sn : dataModel.getSeriesNames()) {
            List<XYDataPoint> dataPoints = dataModel.getDataPoints(sn);
            for (XYDataPoint dataPoint : dataPoints) {
                double x = dataPoint.getX();
                double y = dataPoint.getY();
                if (Double.isNaN(x) || Double.isNaN(y)) continue;
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
            }
        }
        this.xAxis.setRange(minX, maxX);
        this.yAxis.setRange(minY, maxY);
        this.xAxis.setLabel(dataModel.getXLabel());
        this.yAxis.setLabel(dataModel.getYLabel());
    }

    public void draw(Graphics2D graphics, Rectangle bounds, Rectangle clipRect) {
        if (this.dataModel == null) {
            return;
        }
        Color c = graphics.getColor();
        Stroke s = graphics.getStroke();
        this.drawGrid(graphics, bounds, clipRect);
        graphics.setColor(c);
        graphics.setStroke(s);
        String categoryName = this.dataModel.getCategoryName();
        for (String sn : this.dataModel.getSeriesNames()) {
            int pY;
            int px;
            double x;
            if (this.filteredSeries.contains(sn)) continue;
            Color color = null;
            double[] categoryValues = null;
            if (ScatterPlot.isDataCategory(categoryName)) {
                categoryValues = this.spData.getDataValues(categoryName);
            } else {
                color = this.getColor(categoryName, sn);
                graphics.setColor(color);
            }
            List<XYDataPoint> dataPoints = this.dataModel.getDataPoints(sn);
            for (XYDataPoint dataPoint : dataPoints) {
                int pY2;
                int px2;
                double x2 = dataPoint.getX();
                double y = dataPoint.getY();
                if (Double.isNaN(x2) || Double.isNaN(y) || !clipRect.contains(px2 = this.xAxis.getPixelForValue(x2), pY2 = this.yAxis.getPixelForValue(y))) continue;
                if (ScatterPlot.isDataCategory(categoryName)) {
                    color = this.getDataColor(categoryName, categoryValues[dataPoint.getIdx()]);
                    graphics.setColor(color);
                }
                graphics.fillOval(px2 - this.offsetX, pY2 - this.offsetY, this.pointShape.width, this.pointShape.height);
            }
            Stroke stroke = graphics.getStroke();
            BasicStroke thickLine = new BasicStroke(2.0f);
            graphics.setStroke(thickLine);
            graphics.setColor(Color.black);
            for (XYDataPoint dataPoint : dataPoints) {
                x = dataPoint.getX();
                double y = dataPoint.getY();
                if (Double.isNaN(x) || Double.isNaN(y) || !clipRect.contains(px = this.xAxis.getPixelForValue(x), pY = this.yAxis.getPixelForValue(y)) || dataPoint.getMutationCount() <= 0) continue;
                graphics.drawOval(px - this.offsetX - 1, pY - this.offsetY - 1, this.pointShape.width + 1, this.pointShape.height + 1);
            }
            graphics.setStroke(stroke);
            if (this.selectedPoints == null) continue;
            graphics.setColor(Color.ORANGE);
            for (XYDataPoint dataPoint : dataPoints) {
                if (!this.selectedPoints.contains(dataPoint)) continue;
                x = dataPoint.getX();
                double y = dataPoint.getY();
                if (Double.isNaN(x) || Double.isNaN(y) || !clipRect.contains(px = this.xAxis.getPixelForValue(x), pY = this.yAxis.getPixelForValue(y))) continue;
                graphics.drawRect(px - this.offsetX, pY - this.offsetY, this.pointShape.width, this.pointShape.height);
            }
        }
    }

    private Color getDataColor(String categoryName, double categoryValue) {
        TrackType tt = TrackType.valueOf(categoryName);
        ContinuousColorScale scale = this.colorScales.get((Object)tt);
        if (scale == null) {
            scale = PreferenceManager.getInstance().getColorScale(tt);
        }
        return scale.getColor((float)categoryValue);
    }

    public XYDataPoint getDataPointAtPixel(int px, int py) {
        double x = this.xAxis.getDataValueForPixel(px);
        double y = this.yAxis.getDataValueForPixel(py);
        double toleranceX = (double)(this.pointShape.width + 1) / this.xAxis.getScale() / 2.0;
        double toleranceY = (double)(this.pointShape.height + 1) / this.yAxis.getScale() / 2.0;
        return this.dataModel.getDataPointAtPixel(x, y, toleranceX, toleranceY);
    }

    public Color getColor(String categoryName, String sn) {
        return this.colorTable.get(sn);
    }

    private void drawGrid(Graphics2D graphics, Rectangle bounds, Rectangle clipRect) {
        graphics.setColor(new Color(161, 196, 214));
        graphics.setStroke(ChartPanel.DOT1);
        double[] xticks = this.xAxis.ticks;
        double xtick = xticks[0];
        int px = 0;
        while (px < bounds.x + bounds.width) {
            px = this.xAxis.getPixelForValue(xtick);
            if (px > bounds.x && px < bounds.x + bounds.width) {
                graphics.drawLine(px, bounds.y, px, bounds.y + bounds.height);
            }
            xtick += xticks[1];
        }
        double[] yticks = this.yAxis.ticks;
        double ytick = yticks[0];
        int py = bounds.y + bounds.height;
        while (py > bounds.y) {
            py = this.yAxis.getPixelForValue(ytick);
            if (py > bounds.y && py < bounds.y + bounds.height) {
                graphics.drawLine(bounds.x, py, bounds.x + bounds.width, py);
            }
            ytick += yticks[1];
        }
        graphics.setColor(Color.blue.darker());
        graphics.setStroke(ChartPanel.DOT2);
        px = this.xAxis.getPixelForValue(0.0);
        if (px > clipRect.x && px < clipRect.x + clipRect.width) {
            graphics.drawLine(px, clipRect.y, px, clipRect.y + clipRect.height);
        }
        if ((py = this.yAxis.getPixelForValue(0.0)) > clipRect.y && py < clipRect.y + clipRect.height) {
            graphics.drawLine(clipRect.x, py, clipRect.x + clipRect.width, py);
        }
    }

    public void selectPointsInPath(Path2D path) {
        if (this.dataModel != null) {
            this.selectedPoints = this.dataModel.getDataPointsIn(path);
        }
    }

    public void clearSelections() {
        this.selectedPoints = null;
    }

    public void addSeriesFilter(String sn) {
        this.filteredSeries.add(sn);
    }

    public void removeSeriesFilter(String sn) {
        this.filteredSeries.remove(sn);
    }

    public XYDataModel getDataModel() {
        return this.dataModel;
    }
}

