/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.sf.samtools.seekablestream.SeekableStream;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeChildNodeItem;
import org.broad.igv.bbfile.RPTreeHeader;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.RPTreeNode;
import org.broad.igv.bbfile.RPTreeNodeProxy;
import org.broad.tribble.util.LittleEndianInputStream;

public class RPTree {
    private static Logger log = Logger.getLogger(RPTree.class);
    public static final int RPTREE_NODE_FORMAT_SIZE = 4;
    public static final int RPTREE_NODE_LEAF_ITEM_SIZE = 32;
    public static final int RPTREE_NODE_CHILD_ITEM_SIZE = 24;
    private int uncompressBuffSize;
    private boolean isLowToHigh;
    private long rpTreeOffset;
    private RPTreeHeader rpTreeHeader;
    private RPChromosomeRegion chromosomeBounds;
    private int order;
    private RPTreeNode rootNode;
    private long nodeCount;
    private long leafCount;

    public RPTree(SeekableStream fis, long fileOffset, boolean isLowToHigh, int uncompressBuffSize, boolean forceDescend) {
        this.rpTreeOffset = fileOffset;
        this.uncompressBuffSize = uncompressBuffSize;
        this.isLowToHigh = isLowToHigh;
        this.rpTreeHeader = new RPTreeHeader(fis, this.rpTreeOffset, isLowToHigh);
        if (!this.rpTreeHeader.isHeaderOK()) {
            int badMagic = this.rpTreeHeader.getMagic();
            log.error((Object)("Error reading R+ tree header: bad magic = " + badMagic));
            throw new RuntimeException("Error reading R+ tree header: bad magic = " + badMagic);
        }
        this.order = this.rpTreeHeader.getBlockSize();
        this.chromosomeBounds = new RPChromosomeRegion(this.rpTreeHeader.getStartChromID(), this.rpTreeHeader.getStartBase(), this.rpTreeHeader.getEndChromID(), this.rpTreeHeader.getEndBase());
        long nodeOffset = this.rpTreeOffset + (long)this.rpTreeHeader.getHeaderSize();
        Object parentNode = null;
        this.rootNode = RPTree.readRPTreeNode(fis, nodeOffset, isLowToHigh, forceDescend);
    }

    public RPTree(int order) {
        this.order = order;
        this.chromosomeBounds = null;
    }

    public int getUncompressBuffSize() {
        return this.uncompressBuffSize;
    }

    public boolean isIsLowToHigh() {
        return this.isLowToHigh;
    }

    public int getOrder() {
        return this.order;
    }

    public RPTreeHeader getRPTreeHeader() {
        return this.rpTreeHeader;
    }

    public long getItemCount() {
        return this.rpTreeHeader.getItemCount();
    }

    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    public long getNodeCount() {
        return this.nodeCount;
    }

    public RPChromosomeRegion getChromosomeRegion(int startChromID, int endChromID) {
        RPTreeNode thisNode = this.rootNode;
        RPChromosomeRegion seedRegion = null;
        RPChromosomeRegion region = this.findChromosomeRegion(thisNode, startChromID, endChromID, seedRegion);
        return region;
    }

    public ArrayList<RPChromosomeRegion> getAllChromosomeRegions() {
        RPTreeNode thisNode = this.rootNode;
        ArrayList<RPChromosomeRegion> regionList = new ArrayList<RPChromosomeRegion>();
        this.findAllChromosomeRegions(thisNode, regionList);
        return regionList;
    }

    public ArrayList<RPTreeLeafNodeItem> getChromosomeDataHits(RPChromosomeRegion selectionRegion, boolean contained) {
        ArrayList<RPTreeLeafNodeItem> leafHitItems = new ArrayList<RPTreeLeafNodeItem>();
        if (selectionRegion == null) {
            return leafHitItems;
        }
        this.findChromosomeRegionItems(this.rootNode, selectionRegion, leafHitItems);
        return leafHitItems;
    }

    public void print() {
        if (!this.rpTreeHeader.isHeaderOK()) {
            int badMagic = this.rpTreeHeader.getMagic();
            log.error((Object)("Error reading R+ tree header: bad magic = " + badMagic));
            return;
        }
        this.rpTreeHeader.print();
        if (this.rootNode != null) {
            this.rootNode.printItems();
        }
    }

    private RPChromosomeRegion findChromosomeRegion(RPTreeNode thisNode, int startChromID, int endChromID, RPChromosomeRegion region) {
        if (thisNode.isLeaf()) {
            int nLeaves = thisNode.getItemCount();
            for (int index = 0; index < nLeaves; ++index) {
                RPTreeLeafNodeItem leaf = (RPTreeLeafNodeItem)thisNode.getItem(index);
                RPChromosomeRegion bounds = leaf.getChromosomeBounds();
                if ((startChromID < bounds.getStartChromID() || startChromID > bounds.getEndChromID()) && (endChromID < bounds.getStartChromID() || endChromID > bounds.getEndChromID())) continue;
                region = region == null ? new RPChromosomeRegion(bounds) : region.getExtremes(bounds);
            }
        } else {
            int nNodes = thisNode.getItemCount();
            for (int index = 0; index < nNodes; ++index) {
                RPTreeChildNodeItem childItem = (RPTreeChildNodeItem)thisNode.getItem(index);
                RPChromosomeRegion bounds = childItem.getChromosomeBounds();
                if ((startChromID < bounds.getStartChromID() || startChromID > bounds.getEndChromID()) && (endChromID < bounds.getStartChromID() || endChromID > bounds.getEndChromID())) continue;
                RPTreeNode childNode = childItem.getChildNode();
                region = this.findChromosomeRegion(childNode, startChromID, endChromID, region);
            }
        }
        return region;
    }

    private void findAllChromosomeRegions(RPTreeNode thisNode, ArrayList<RPChromosomeRegion> regionList) {
        if (thisNode.isLeaf()) {
            int nLeaves = thisNode.getItemCount();
            for (int index = 0; index < nLeaves; ++index) {
                RPTreeLeafNodeItem leaf = (RPTreeLeafNodeItem)thisNode.getItem(index);
                RPChromosomeRegion region = leaf.getChromosomeBounds();
                regionList.add(region);
            }
        } else {
            int nNodes = thisNode.getItemCount();
            for (int index = 0; index < nNodes; ++index) {
                RPTreeChildNodeItem childItem = (RPTreeChildNodeItem)thisNode.getItem(index);
                RPTreeNode childNode = childItem.getChildNode();
                this.findAllChromosomeRegions(childNode, regionList);
            }
        }
    }

    private void findChromosomeRegionItems(RPTreeNode thisNode, RPChromosomeRegion selectionRegion, ArrayList<RPTreeLeafNodeItem> leafHitItems) {
        if (selectionRegion == null) {
            return;
        }
        int hitValue = thisNode.compareRegions(selectionRegion);
        if (Math.abs(hitValue) >= 2) {
            return;
        }
        if (thisNode.isLeaf()) {
            int nLeaves = thisNode.getItemCount();
            for (int index = 0; index < nLeaves; ++index) {
                RPTreeLeafNodeItem leafItem = (RPTreeLeafNodeItem)thisNode.getItem(index);
                hitValue = leafItem.compareRegions(selectionRegion);
                if (Math.abs(hitValue) < 2) {
                    leafHitItems.add(leafItem);
                    continue;
                }
                if (hitValue <= 1) {
                    continue;
                }
                break;
            }
        } else {
            int nNodes = thisNode.getItemCount();
            for (int index = 0; index < nNodes; ++index) {
                RPTreeChildNodeItem childItem = (RPTreeChildNodeItem)thisNode.getItem(index);
                hitValue = childItem.compareRegions(selectionRegion);
                if (Math.abs(hitValue) < 2) {
                    RPTreeNode childNode = childItem.getChildNode();
                    this.findChromosomeRegionItems(childNode, selectionRegion, leafHitItems);
                    continue;
                }
                if (hitValue <= 1) {
                    continue;
                }
                break;
            }
        }
    }

    static RPTreeNode readRPTreeNode(SeekableStream fis, long fileOffset, boolean isLowToHigh, boolean forceDescend) {
        LittleEndianInputStream lbdis = null;
        DataInputStream bdis = null;
        byte[] buffer = new byte[4];
        RPTreeNode thisNode = null;
        try {
            int itemCount;
            int itemSize;
            boolean isLeaf;
            fis.seek(fileOffset);
            fis.readFully(buffer);
            if (isLowToHigh) {
                lbdis = new LittleEndianInputStream((InputStream)new ByteArrayInputStream(buffer));
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(buffer));
            }
            byte type = isLowToHigh ? lbdis.readByte() : bdis.readByte();
            if (type == 1) {
                isLeaf = true;
                itemSize = 32;
                thisNode = new RPTreeNode(true);
            } else {
                isLeaf = false;
                itemSize = 24;
                thisNode = new RPTreeNode(false);
            }
            if (isLowToHigh) {
                lbdis.readByte();
                itemCount = lbdis.readShort();
            } else {
                bdis.readByte();
                itemCount = bdis.readShort();
            }
            int itemBlockSize = itemCount * itemSize;
            buffer = new byte[itemBlockSize];
            fis.readFully(buffer);
            if (isLowToHigh) {
                lbdis = new LittleEndianInputStream((InputStream)new ByteArrayInputStream(buffer));
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(buffer));
            }
            for (int item = 0; item < itemCount; ++item) {
                int endBase;
                int endChromID;
                int startBase;
                int startChromID;
                if (isLowToHigh) {
                    startChromID = lbdis.readInt();
                    startBase = lbdis.readInt();
                    endChromID = lbdis.readInt();
                    endBase = lbdis.readInt();
                } else {
                    startChromID = bdis.readInt();
                    startBase = bdis.readInt();
                    endChromID = bdis.readInt();
                    endBase = bdis.readInt();
                }
                if (isLeaf) {
                    long dataSize;
                    long dataOffset;
                    if (isLowToHigh) {
                        dataOffset = lbdis.readLong();
                        dataSize = lbdis.readLong();
                    } else {
                        dataOffset = bdis.readLong();
                        dataSize = bdis.readLong();
                    }
                    thisNode.insertItem(new RPTreeLeafNodeItem(startChromID, startBase, endChromID, endBase, dataOffset, dataSize));
                } else {
                    RPTreeChildNodeItem childNodeItem;
                    long nodeOffset = isLowToHigh ? lbdis.readLong() : bdis.readLong();
                    if (startChromID != endChromID || forceDescend) {
                        RPTreeNode childNode = RPTree.readRPTreeNode(fis, nodeOffset, isLowToHigh, forceDescend);
                        childNodeItem = new RPTreeChildNodeItem(startChromID, startBase, endChromID, endBase, childNode);
                    } else {
                        RPTreeNodeProxy proxy = new RPTreeNodeProxy(fis, nodeOffset, isLowToHigh, startChromID);
                        childNodeItem = new RPTreeChildNodeItem(startChromID, startBase, endChromID, endBase, proxy);
                    }
                    thisNode.insertItem(childNodeItem);
                }
                fileOffset += (long)itemSize;
            }
        }
        catch (IOException ex) {
            log.error((Object)("Error reading in R+ tree nodes: " + ex));
            throw new RuntimeException("Error reading R+ tree nodes: \n", ex);
        }
        return thisNode;
    }
}

