/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.samtools.seekablestream.SeekableStream;
import org.apache.log4j.Logger;
import org.broad.tribble.util.LittleEndianInputStream;

public class BBTotalSummaryBlock {
    private static Logger log = Logger.getLogger(BBTotalSummaryBlock.class);
    public static final int TOTAL_SUMMARY_BLOCK_SIZE = 40;
    private SeekableStream fis;
    private long summaryBlockOffset;
    private long basesCovered;
    private float minVal;
    private float maxVal;
    private float sumData;
    private float sumSquares;

    public BBTotalSummaryBlock(SeekableStream fis, long fileOffset, boolean isLowToHigh) {
        LittleEndianInputStream lbdis = null;
        DataInputStream bdis = null;
        byte[] buffer = new byte[40];
        this.fis = fis;
        this.summaryBlockOffset = fileOffset;
        try {
            fis.seek(fileOffset);
            fis.readFully(buffer);
            if (isLowToHigh) {
                lbdis = new LittleEndianInputStream((InputStream)new ByteArrayInputStream(buffer));
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(buffer));
            }
            if (isLowToHigh) {
                this.basesCovered = lbdis.readLong();
                this.minVal = lbdis.readFloat();
                this.maxVal = lbdis.readFloat();
                this.sumData = lbdis.readFloat();
                this.sumSquares = lbdis.readFloat();
            } else {
                this.basesCovered = bdis.readLong();
                this.minVal = bdis.readFloat();
                this.maxVal = bdis.readFloat();
                this.sumData = bdis.readFloat();
                this.sumSquares = bdis.readFloat();
            }
        }
        catch (IOException ex) {
            log.error((Object)"Error reading Total Summary Block ", (Throwable)ex);
            throw new RuntimeException("Error reading Total Summary Block", ex);
        }
    }

    public BBTotalSummaryBlock(long basesCovered, float minVal, float maxVal, float sumData, float sumSquares) {
        this.basesCovered = basesCovered;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.sumData = sumData;
        this.sumSquares = sumSquares;
    }

    public static int getSummaryBlockSize() {
        return 40;
    }

    public SeekableStream getMBBFis() {
        return this.fis;
    }

    public long getSummaryBlockOffset() {
        return this.summaryBlockOffset;
    }

    public long getBasesCovered() {
        return this.basesCovered;
    }

    public float getMinVal() {
        return this.minVal;
    }

    public float getMaxVal() {
        return this.maxVal;
    }

    public float getSumData() {
        return this.sumData;
    }

    public float getSumSquares() {
        return this.sumSquares;
    }

    public void printTotalSummaryBlock() {
        log.debug((Object)"BBFile TotalSummaryBlock (Table DD):");
        log.debug((Object)("Number of bases covered= " + this.basesCovered));
        log.debug((Object)("MinVal = " + this.minVal));
        log.debug((Object)("MaxVal = " + this.maxVal));
        log.debug((Object)("Sum of data values = " + this.sumData));
        log.debug((Object)("Sum of squares values = " + this.sumSquares));
    }
}

