/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.broad.igv.ui.util.IndefiniteProgressMonitor;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;

public class CancellableProgressDialog
extends JDialog {
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel permText;
    private JLabel statusText;
    private JProgressBar progressBar;
    private JPanel buttonBar;
    private JPanel hSpacer1;
    private JButton cancelButton;
    private JPanel hSpacer2;
    private static Set<CancellableProgressDialog> cancellableDialogs = Collections.synchronizedSet(new HashSet());

    public CancellableProgressDialog(Frame owner) {
        super(owner);
        this.initComponents();
    }

    public CancellableProgressDialog(Dialog owner) {
        super(owner);
        this.initComponents();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.permText = new JLabel();
        this.statusText = new JLabel();
        this.progressBar = new JProgressBar();
        this.buttonBar = new JPanel();
        this.hSpacer1 = new JPanel(null);
        this.cancelButton = new JButton();
        this.hSpacer2 = new JPanel(null);
        this.setAlwaysOnTop(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.contentPanel.add(this.permText);
        this.statusText.setText("...");
        this.contentPanel.add(this.statusText);
        this.contentPanel.add(this.progressBar);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridLayout(1, 3));
        this.buttonBar.add(this.hSpacer1);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CancellableProgressDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add(this.cancelButton);
        this.buttonBar.add(this.hSpacer2);
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void addCancelActionListener(ActionListener cancelActionListener) {
        this.cancelButton.addActionListener(cancelActionListener);
    }

    public void setStatus(final String status) {
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                CancellableProgressDialog.this.statusText.setText(status);
            }
        };
        UIUtilities.invokeOnEventThread(updater);
    }

    public static CancellableProgressDialog showCancellableProgressDialog(Frame dialogsParent, String title, ActionListener cancelActionListener, ProgressMonitor monitor) {
        final CancellableProgressDialog progressDialog = new CancellableProgressDialog(dialogsParent);
        cancellableDialogs.add(progressDialog);
        progressDialog.setTitle(title);
        progressDialog.addCancelActionListener(cancelActionListener);
        progressDialog.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cancellableDialogs.remove(progressDialog);
            }
        });
        if (monitor != null && monitor instanceof IndefiniteProgressMonitor) {
            progressDialog.getProgressBar().setIndeterminate(true);
        }
        if (monitor != null) {
            monitor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("STATUS_STATUS")) {
                        progressDialog.setStatus("" + evt.getNewValue());
                    } else if (evt.getPropertyName().equals("PROGRESS_PROPERTY") && (Integer)evt.getNewValue() >= 100) {
                        progressDialog.cancelButton.doClick(1);
                    }
                }
            });
        }
        progressDialog.setVisible(true);
        progressDialog.toFront();
        return progressDialog;
    }

    public static boolean hasCancellableProgressDialog() {
        return !cancellableDialogs.isEmpty();
    }
}

