/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.DataPanelLayout;
import org.broad.igv.ui.panel.DragAndDropTransferHandler;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.HeaderDropTargetListener;
import org.broad.igv.ui.panel.HeaderPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.ReferenceFrame;

public class HeaderPanelContainer
extends JPanel
implements Paintable {
    private Collection<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
    JPanel contentPanel;

    public HeaderPanelContainer() {
        this.setLayout(new BorderLayout());
        this.init();
        this.createHeaderPanels();
    }

    public void init() {
        this.setTransferHandler(new DragAndDropTransferHandler());
        this.setDropTarget(new DropTarget(this, new HeaderDropTargetListener(this)));
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.contentPanel != null) {
            for (Component c : this.contentPanel.getComponents()) {
                if (!(c instanceof HeaderPanel)) continue;
                c.setBackground(color);
            }
        }
    }

    public void createHeaderPanels() {
        this.removeAll();
        this.frames = FrameManager.getFrames();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new DataPanelLayout());
        for (ReferenceFrame f : this.frames) {
            HeaderPanel dp = new HeaderPanel(f);
            dp.setBackground(this.getBackground());
            this.contentPanel.add(dp);
        }
        this.add((Component)this.contentPanel, "Center");
        if (FrameManager.isGeneListMode()) {
            GeneList gl = IGV.getInstance().getSession().getCurrentGeneList();
            String name = gl.getDisplayName();
            JLabel label = new JLabel(name, 0);
            Border border = BorderFactory.createLineBorder(Color.lightGray);
            label.setBorder(border);
            this.add((Component)label, "North");
        }
        this.invalidate();
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect) {
        this.paint(g);
    }
}

