/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.CytobandPanel;
import org.broad.igv.ui.panel.DragAndDropTransferHandler;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.RegionMenu;
import org.broad.igv.ui.panel.RegionOfInterestPanel;
import org.broad.igv.ui.panel.RulerPanel;
import org.broad.igv.ui.util.SwitchingLabelUI;

public class HeaderPanel
extends JPanel
implements Transferable {
    ReferenceFrame frame;
    private JLabel label;
    public static final Color BUTTON_BACKGROUND = new Color(230, 240, 250);
    static DataFlavor dragAndDropPanelDataFlavor;
    private CytobandPanel cytobandPanel;
    private RulerPanel rulerPanel;
    private RegionOfInterestPanel regionOfInterestPane;
    private JPanel geneListPanel;

    public HeaderPanel(ReferenceFrame frame) {
        this.frame = frame;
        this.init();
    }

    private void init() {
        this.setBackground(new Color(255, 255, 255));
        this.setMinimumSize(new Dimension(700, 0));
        this.setPreferredSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        if (FrameManager.isGeneListMode()) {
            this.geneListPanel = new JPanel();
            this.geneListPanel.setMinimumSize(new Dimension(700, 0));
            this.geneListPanel.setPreferredSize(new Dimension(0, 0));
            this.geneListPanel.setLayout(new BorderLayout());
            this.label = new JLabel(this.frame.getName());
            this.label.setForeground(Color.blue);
            this.label.setUI(new SwitchingLabelUI(10));
            this.label.setToolTipText(this.frame.getName());
            this.label.setPreferredSize(new Dimension(500, 80));
            this.setSize(400, 100);
            this.setVisible(true);
            this.cytobandPanel = new CytobandPanel(this.frame, false);
            this.cytobandPanel.setBackground(new Color(255, 255, 255));
            this.cytobandPanel.setPreferredSize(new Dimension(0, 20));
            this.cytobandPanel.setRequestFocusEnabled(false);
            this.cytobandPanel.setLayout(null);
            MouseAdapter mouseAdapter = new MouseAdapter(){
                boolean isDragging = false;
                Point mousePressPoint;

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() > 1) {
                        IGV.getInstance().setDefaultFrame(HeaderPanel.this.frame.getName());
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        HeaderPanel.this.getPopupMenu(HeaderPanel.this, HeaderPanel.this.frame).show(HeaderPanel.this, evt.getX(), evt.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        HeaderPanel.this.getPopupMenu(HeaderPanel.this, HeaderPanel.this.frame).show(HeaderPanel.this, evt.getX(), evt.getY());
                    }
                    this.isDragging = false;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (this.isDragging) {
                        return;
                    }
                    this.isDragging = true;
                    HeaderPanel c = HeaderPanel.this;
                    TransferHandler handler = c.getTransferHandler();
                    if (handler != null) {
                        handler.exportAsDrag(c, e, 2);
                    }
                }
            };
            this.cytobandPanel.addMouseListener(mouseAdapter);
            this.cytobandPanel.addMouseMotionListener(mouseAdapter);
            this.label.addMouseListener(mouseAdapter);
            this.label.addMouseMotionListener(mouseAdapter);
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
            this.geneListPanel.add((Component)this.cytobandPanel, "Center");
            this.geneListPanel.add((Component)this.label, "South");
            this.add(this.geneListPanel);
            this.setTransferHandler(new DragAndDropTransferHandler());
            this.setDropTarget(new DropTarget(this, new HeaderDropTargetListener(this)));
        } else {
            JPanel panel = new JPanel();
            this.setBorder(BorderFactory.createLineBorder(Color.gray));
            panel.setBackground(new Color(255, 255, 255));
            panel.setMinimumSize(new Dimension(700, 0));
            panel.setPreferredSize(new Dimension(0, 0));
            panel.setLayout(new BorderLayout());
            this.cytobandPanel = new CytobandPanel(this.frame);
            this.cytobandPanel.setBackground(new Color(255, 255, 255));
            this.cytobandPanel.setPreferredSize(new Dimension(0, 50));
            this.cytobandPanel.setRequestFocusEnabled(false);
            this.cytobandPanel.setLayout(null);
            panel.add((Component)this.cytobandPanel, "North");
            this.rulerPanel = new RulerPanel(this.frame);
            this.rulerPanel.setBackground(new Color(255, 255, 255));
            this.rulerPanel.setLayout(null);
            panel.add((Component)this.rulerPanel, "Center");
            this.regionOfInterestPane = new RegionOfInterestPanel(this.frame);
            this.regionOfInterestPane.setBackground(new Color(255, 255, 255));
            this.regionOfInterestPane.setMinimumSize(new Dimension(0, 13));
            panel.add((Component)this.regionOfInterestPane, "South");
            this.add(panel);
        }
    }

    protected JPopupMenu getPopupMenu(final HeaderPanel parent, final ReferenceFrame frame) {
        int start = (int)frame.getOrigin();
        int end = (int)frame.getEnd();
        RegionOfInterest roi = new RegionOfInterest(frame.getChrName(), start, end, "");
        RegionMenu popupMenu = new RegionMenu(roi, frame, "Panel: " + frame.getName());
        ((JPopupMenu)((Object)popupMenu)).addSeparator();
        TrackMenuUtils.addZoomItems((JPopupMenu)((Object)popupMenu), frame);
        ((JPopupMenu)((Object)popupMenu)).addSeparator();
        JMenuItem item1 = new JMenuItem("Switch to standard view");
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGV.getInstance().setDefaultFrame(frame.getName());
            }
        });
        ((JPopupMenu)((Object)popupMenu)).add(item1);
        ((JPopupMenu)((Object)popupMenu)).addSeparator();
        JMenuItem item = new JMenuItem("Remove panel");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                parent.removeFrame(frame);
            }
        });
        ((JPopupMenu)((Object)popupMenu)).add(item);
        return popupMenu;
    }

    private void removeFrame(ReferenceFrame frame) {
        FrameManager.removeFrame(frame);
        List<ReferenceFrame> remainingFrames = FrameManager.getFrames();
        if (remainingFrames.size() == 1) {
            IGV.getInstance().setDefaultFrame(remainingFrames.get(0).getName());
        } else {
            IGV.getInstance().resetFrames();
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.cytobandPanel != null) {
            this.cytobandPanel.setBackground(color);
        }
        if (this.rulerPanel != null) {
            this.rulerPanel.setBackground(color);
        }
        if (this.regionOfInterestPane != null) {
            this.regionOfInterestPane.setBackground(color);
        }
        if (this.geneListPanel != null) {
            this.geneListPanel.setBackground(color);
        }
    }

    public static DataFlavor getDragAndDropPanelDataFlavor() throws Exception {
        if (dragAndDropPanelDataFlavor == null) {
            dragAndDropPanelDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=org.broad.igv.ui.panel.HeaderPanel");
        }
        return dragAndDropPanelDataFlavor;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        DataFlavor thisFlavor = null;
        try {
            thisFlavor = HeaderPanel.getDragAndDropPanelDataFlavor();
        }
        catch (Exception ex) {
            System.err.println("Problem lazy loading: " + ex.getMessage());
            ex.printStackTrace(System.err);
            return null;
        }
        if (thisFlavor != null && flavor.equals(thisFlavor)) {
            return this;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{null};
        try {
            flavors[0] = HeaderPanel.getDragAndDropPanelDataFlavor();
        }
        catch (Exception ex) {
            System.err.println("Problem lazy loading: " + ex.getMessage());
            ex.printStackTrace(System.err);
            return null;
        }
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = new DataFlavor[]{null};
        try {
            flavors[0] = HeaderPanel.getDragAndDropPanelDataFlavor();
        }
        catch (Exception ex) {
            System.err.println("Problem lazy loading: " + ex.getMessage());
            ex.printStackTrace(System.err);
            return false;
        }
        for (DataFlavor f : flavors) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    class HeaderDropTargetListener
    implements DropTargetListener {
        private final HeaderPanel rootPanel;

        public HeaderDropTargetListener(HeaderPanel sheet) {
            this.rootPanel = sheet;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            DataFlavor dragAndDropPanelFlavor = null;
            Object transferableObj = null;
            try {
                dragAndDropPanelFlavor = HeaderPanel.getDragAndDropPanelDataFlavor();
                Transferable transferable = dtde.getTransferable();
                if (transferable.isDataFlavorSupported(dragAndDropPanelFlavor)) {
                    transferableObj = dtde.getTransferable().getTransferData(dragAndDropPanelFlavor);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (transferableObj == null) {
                return;
            }
            HeaderPanel droppedPanel = (HeaderPanel)transferableObj;
            ReferenceFrame droppedFrame = droppedPanel.frame;
            if (droppedFrame == HeaderPanel.this.frame) {
                IGV.getInstance().resetFrames();
            } else {
                int dropXLoc = dtde.getLocation().x;
                boolean before = dropXLoc < HeaderPanel.this.getWidth() / 2;
                List<ReferenceFrame> panels = FrameManager.getFrames();
                ArrayList<ReferenceFrame> orderedPanels = new ArrayList<ReferenceFrame>(panels.size());
                panels.remove(droppedFrame);
                boolean dropAdded = false;
                for (ReferenceFrame frame : panels) {
                    if (HeaderPanel.this.frame == frame) {
                        if (before) {
                            orderedPanels.add(droppedFrame);
                            orderedPanels.add(frame);
                        } else {
                            orderedPanels.add(frame);
                            orderedPanels.add(droppedFrame);
                        }
                        dropAdded = true;
                        continue;
                    }
                    orderedPanels.add(frame);
                }
                FrameManager.setFrames(orderedPanels);
                IGV.getInstance().resetFrames();
            }
        }
    }
}

