/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.exome.ExomeReferenceFrame;
import org.broad.igv.lists.GeneList;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.SearchCommand;
import org.broad.igv.ui.panel.FeatureTrackSelectionDialog;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;

public class FrameManager {
    private static List<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
    private static ReferenceFrame defaultFrame;
    private static boolean exomeMode;
    public static final String DEFAULT_FRAME_NAME = "genome";
    static FeatureTrack exomeTrack;

    public static synchronized ReferenceFrame getDefaultFrame() {
        if (defaultFrame == null) {
            defaultFrame = new ReferenceFrame(DEFAULT_FRAME_NAME);
        }
        return defaultFrame;
    }

    public static boolean setExomeMode(boolean b, boolean showTrackMenu) {
        if (b == exomeMode) {
            return false;
        }
        if (b) {
            return FrameManager.switchToExomeMode(showTrackMenu);
        }
        return FrameManager.switchToGenomeMode();
    }

    public static boolean isExomeMode() {
        return exomeMode;
    }

    private static boolean switchToExomeMode(boolean showTrackMenu) {
        Frame parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
        List<FeatureTrack> featureTracks = IGV.getInstance().getFeatureTracks();
        if (featureTracks.size() == 1) {
            exomeTrack = featureTracks.get(0);
        } else if (exomeTrack == null || showTrackMenu) {
            FeatureTrackSelectionDialog dlg = new FeatureTrackSelectionDialog(parent);
            dlg.setVisible(true);
            if (dlg.getIsCancelled()) {
                return false;
            }
            exomeTrack = dlg.getSelectedTrack();
        }
        if (exomeTrack == null) {
            return false;
        }
        ExomeReferenceFrame exomeFrame = new ExomeReferenceFrame(defaultFrame, exomeTrack);
        Locus locus = new Locus(defaultFrame.getChrName(), (int)defaultFrame.getOrigin(), (int)defaultFrame.getEnd());
        exomeFrame.jumpTo(locus);
        defaultFrame = exomeFrame;
        frames.clear();
        frames.add(defaultFrame);
        exomeMode = true;
        return true;
    }

    private static boolean switchToGenomeMode() {
        ReferenceFrame refFrame = new ReferenceFrame(defaultFrame);
        Locus locus = new Locus(defaultFrame.getChrName(), (int)defaultFrame.getOrigin(), (int)defaultFrame.getEnd());
        refFrame.jumpTo(locus);
        defaultFrame = refFrame;
        frames.clear();
        frames.add(defaultFrame);
        exomeMode = false;
        return true;
    }

    public static List<ReferenceFrame> getFrames() {
        return frames;
    }

    public static void setFrames(List<ReferenceFrame> f) {
        frames = f;
    }

    public static boolean isGeneListMode() {
        return frames.size() > 1;
    }

    public static void setToDefaultFrame(String searchString) {
        Locus locus;
        frames.clear();
        if (searchString != null && (locus = FrameManager.getLocus(searchString, 0)) != null) {
            FrameManager.getDefaultFrame().jumpTo(locus);
        }
        frames.add(FrameManager.getDefaultFrame());
        FrameManager.getDefaultFrame().recordHistory();
    }

    public static void resetFrames(GeneList gl) {
        frames.clear();
        if (gl == null) {
            frames.add(FrameManager.getDefaultFrame());
        } else {
            ArrayList<String> lociNotFound = new ArrayList<String>();
            List<String> loci = gl.getLoci();
            if (loci.size() == 1) {
                Locus locus = FrameManager.getLocus(loci.get(0));
                if (locus == null) {
                    lociNotFound.add(loci.get(0));
                } else {
                    IGV.getInstance().getSession().setCurrentGeneList(null);
                    FrameManager.getDefaultFrame().jumpTo(locus.getChr(), locus.getStart(), locus.getEnd());
                }
            } else {
                for (String searchString : gl.getLoci()) {
                    Locus locus = FrameManager.getLocus(searchString);
                    if (locus == null) {
                        lociNotFound.add(searchString);
                        continue;
                    }
                    ReferenceFrame referenceFrame = new ReferenceFrame(searchString);
                    referenceFrame.jumpTo(locus);
                    frames.add(referenceFrame);
                }
            }
            if (lociNotFound.size() > 1) {
                StringBuffer message = new StringBuffer();
                message.append("<html>The following loci could not be found in the currently loaded annotation sets: <br>");
                for (String s : lociNotFound) {
                    message.append(s + " ");
                }
                MessageUtils.showMessage(message.toString());
            }
        }
    }

    public static double getMinimumScale() {
        double minScale = Double.MAX_VALUE;
        for (ReferenceFrame frame : frames) {
            minScale = Math.min(minScale, frame.getScale());
        }
        return minScale;
    }

    public static Locus getLocus(String searchString) {
        int flankingRegion = PreferenceManager.getInstance().getAsInt("FLAKING_REGIONS");
        return FrameManager.getLocus(searchString, flankingRegion);
    }

    public static Locus getLocus(String searchString, int flankingRegion) {
        SearchCommand cmd = new SearchCommand(FrameManager.getDefaultFrame(), searchString);
        List<SearchCommand.SearchResult> results = cmd.runSearch(searchString);
        Locus locus = null;
        for (SearchCommand.SearchResult result : results) {
            int start;
            if (result.getType() == SearchCommand.ResultType.ERROR) continue;
            int delta = 0;
            if (result.getType() != SearchCommand.ResultType.LOCUS) {
                delta = flankingRegion < 0 ? -flankingRegion * (result.getEnd() - result.getStart()) / 100 : flankingRegion;
            }
            if ((start = result.getStart() - delta) < 0 && result.getStart() >= -1) {
                start = 0;
            }
            locus = new Locus(result.getChr(), start, result.getEnd() + delta);
            break;
        }
        return locus;
    }

    public static void removeFrame(ReferenceFrame frame) {
        frames.remove(frame);
    }

    public static void sortFrames(final Track t) {
        Collections.sort(frames, new Comparator<ReferenceFrame>(){

            @Override
            public int compare(ReferenceFrame o1, ReferenceFrame o2) {
                float s2;
                float s1 = t.getRegionScore(o1.getChromosome().getName(), (int)o1.getOrigin(), (int)o1.getEnd(), o1.getZoom(), RegionScoreType.SCORE, o1.getName());
                return s1 == (s2 = t.getRegionScore(o2.getChromosome().getName(), (int)o2.getOrigin(), (int)o2.getEnd(), o2.getZoom(), RegionScoreType.SCORE, o2.getName())) ? 0 : (s1 > s2 ? -1 : 1);
            }
        });
    }

    static {
        exomeMode = false;
        frames.add(FrameManager.getDefaultFrame());
        exomeTrack = null;
    }
}

