/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.plaf.LookAndFeelFactory;
import jargs.gnu.CmdLineParser;
import java.awt.Color;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.DefaultExceptionHandler;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.ShutdownThread;
import org.broad.igv.ui.event.GlobalKeyDispatcher;
import org.broad.igv.util.HttpUtils;

public class Main {
    private static Logger log = Logger.getLogger(Main.class);

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        Main.initApplication();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        ImageIcon icon = new ImageIcon(Main.class.getResource("mainframeicon.png"));
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        }
        Main.open(frame, args);
    }

    private static void initApplication() {
        DirectoryManager.initializeLog();
        log.info((Object)("Startup  " + Globals.applicationString()));
        log.info((Object)("Java " + System.getProperty("java.version")));
        log.info((Object)("Default User Directory: " + DirectoryManager.getUserDirectory()));
        System.setProperty("http.agent", Globals.applicationString());
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        Main.updateTooltipSettings();
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
    }

    public static void updateTooltipSettings() {
        ToolTipManager.sharedInstance().setEnabled(true);
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        ToolTipManager.sharedInstance().setInitialDelay(prefMgr.getAsInt("TOOLTIP.INITIAL_DELAY"));
        ToolTipManager.sharedInstance().setReshowDelay(prefMgr.getAsInt("TOOLTIP.RESHOW_DELAY"));
        ToolTipManager.sharedInstance().setDismissDelay(prefMgr.getAsInt("TOOLTIP.DISMISS_DELAY"));
    }

    public static void open(Frame frame) {
        Main.open(frame, new String[0]);
    }

    public static void open(Frame frame, String[] args) {
        if (!(frame instanceof JFrame)) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    windowEvent.getComponent().setVisible(false);
                }
            });
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ToolTipManager.sharedInstance().setEnabled(true);
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                this.windowActivated(windowEvent);
            }
        });
        Main.initializeLookAndFeel();
        IGVArgs igvArgs = new IGVArgs(args);
        if (igvArgs.getPropertyOverrides() != null) {
            PreferenceManager.getInstance().loadOverrides(igvArgs.getPropertyOverrides());
        }
        if (igvArgs.getDataServerURL() != null) {
            PreferenceManager.getInstance().overrideDataServerURL(igvArgs.getDataServerURL());
        }
        if (igvArgs.getGenomeServerURL() != null) {
            PreferenceManager.getInstance().overrideGenomeServerURL(igvArgs.getGenomeServerURL());
        }
        HttpUtils.getInstance().updateProxySettings();
        IGV.createInstance(frame).startUp(igvArgs);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new GlobalKeyDispatcher());
    }

    private static void initializeLookAndFeel() {
        try {
            String lnf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(lnf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Globals.IS_LINUX) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                UIManager.put("JideSplitPane.dividerSize", 5);
                UIManager.put("JideSplitPaneDivider.background", Color.darkGray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        LookAndFeelFactory.installJideExtension();
    }

    public static class IGVArgs {
        private String batchFile = null;
        private String sessionFile = null;
        private String dataFileString = null;
        private String locusString = null;
        private String propertyOverrides = null;
        private String genomeId = null;
        private String port = null;
        private String dataServerURL = null;
        private String genomeServerURL = null;
        private String indexFile = null;
        private String name = null;

        IGVArgs(String[] args) {
            if (args != null) {
                this.parseArgs(args);
            }
        }

        private void parseArgs(String[] args) {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option propertyFileOption = parser.addStringOption('o', "preferences");
            CmdLineParser.Option batchFileOption = parser.addStringOption('b', "batch");
            CmdLineParser.Option portOption = parser.addStringOption('p', "port");
            CmdLineParser.Option genomeOption = parser.addStringOption('g', "genome");
            CmdLineParser.Option dataServerOption = parser.addStringOption('d', "dataServerURL");
            CmdLineParser.Option genomeServerOption = parser.addStringOption('u', "genomeServerURL");
            CmdLineParser.Option indexFileOption = parser.addStringOption('i', "indexFileURL");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            try {
                parser.parse(args);
            }
            catch (CmdLineParser.IllegalOptionValueException e) {
                e.printStackTrace();
            }
            catch (CmdLineParser.UnknownOptionException e) {
                e.printStackTrace();
            }
            this.propertyOverrides = (String)parser.getOptionValue(propertyFileOption);
            this.batchFile = (String)parser.getOptionValue(batchFileOption);
            this.port = (String)parser.getOptionValue(portOption);
            this.genomeId = (String)parser.getOptionValue(genomeOption);
            this.dataServerURL = (String)parser.getOptionValue(dataServerOption);
            this.genomeServerURL = (String)parser.getOptionValue(genomeServerOption);
            this.indexFile = (String)parser.getOptionValue(indexFileOption);
            this.name = (String)parser.getOptionValue(nameOption);
            String[] nonOptionArgs = parser.getRemainingArgs();
            if (nonOptionArgs != null && nonOptionArgs.length > 0) {
                String firstArg = nonOptionArgs[0];
                if (firstArg != null && !firstArg.equals("ignore")) {
                    log.info((Object)("Loading: " + firstArg));
                    if (firstArg.endsWith(".xml") || firstArg.endsWith(".php") || firstArg.endsWith(".php3") || firstArg.endsWith(".session")) {
                        this.sessionFile = firstArg;
                    } else {
                        this.dataFileString = firstArg;
                    }
                }
                if (nonOptionArgs.length > 1) {
                    this.locusString = nonOptionArgs[1];
                }
            }
        }

        private String checkEqualsAndExtractParamter(String arg) {
            if (arg == null) {
                return null;
            }
            int eq = arg.indexOf("=");
            if (eq > 0) {
                String key = arg.substring(0, eq);
                String val = arg.substring(eq + 1);
                if (key.equalsIgnoreCase("server")) {
                    PreferenceManager.getInstance().put("IONTORRENT.SERVER", val);
                    log.info((Object)("Got server: " + key + "=" + val));
                    return null;
                }
                if (key.equalsIgnoreCase("sessionURL") || key.equalsIgnoreCase("file")) {
                    if (val.endsWith(".xml") || val.endsWith(".php") || val.endsWith(".php3") || val.endsWith(".session")) {
                        log.info((Object)("Got session: " + key + "=" + val));
                        this.sessionFile = val;
                    } else {
                        log.info((Object)("Got dataFileString: " + key + "=" + val));
                        this.dataFileString = val;
                    }
                    return null;
                }
                if (key.equalsIgnoreCase("locus") || key.equalsIgnoreCase("position")) {
                    log.info((Object)("Got locus: " + key + "=" + val));
                    this.locusString = val;
                    return null;
                }
                log.info((Object)("Currently not handled: " + key + "=" + val));
                return null;
            }
            return arg;
        }

        public String getBatchFile() {
            return this.batchFile;
        }

        public String getSessionFile() {
            return this.sessionFile;
        }

        public String getDataFileString() {
            return this.dataFileString;
        }

        public String getLocusString() {
            return this.locusString;
        }

        public String getPropertyOverrides() {
            return this.propertyOverrides;
        }

        public String getGenomeId() {
            return this.genomeId;
        }

        public String getPort() {
            return this.port;
        }

        public String getDataServerURL() {
            return this.dataServerURL;
        }

        public String getGenomeServerURL() {
            return this.genomeServerURL;
        }

        public String getIndexFile() {
            return this.indexFile;
        }

        public String getName() {
            return this.name;
        }
    }
}

