/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.util.ResourceLocator;

@XmlType(factoryMethod="getNextTrack")
public class MergedTracks
extends DataTrack {
    @XmlAttribute
    protected Class clazz = MergedTracks.class;
    private Collection<DataTrack> memberTracks;
    public static final String MEMBER_TRACK_TAG_NAME = "Track";

    public MergedTracks(String id, String name, Collection<DataTrack> inputTracks) {
        super(null, id, name);
        this.initTrackList(inputTracks);
        this.autoScale = this.getAutoScale();
        this.setTrackAlphas(150);
    }

    private void initTrackList(Collection<DataTrack> inputTracks) {
        this.memberTracks = new ArrayList<DataTrack>(inputTracks.size());
        for (DataTrack inputTrack : inputTracks) {
            if (inputTrack instanceof MergedTracks) {
                this.memberTracks.addAll(((MergedTracks)inputTrack).getMemberTracks());
                continue;
            }
            this.memberTracks.add(inputTrack);
        }
    }

    @Override
    public Collection<ResourceLocator> getResourceLocators() {
        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>(this.memberTracks.size());
        for (DataTrack memTrack : this.memberTracks) {
            locators.addAll(memTrack.getResourceLocators());
        }
        return locators;
    }

    @XmlElement(name="Track")
    private Collection<DataTrack> getMemberTracks() {
        return this.memberTracks;
    }

    private void setTrackAlphas(int alpha) {
        for (DataTrack track : this.memberTracks) {
            track.setColor(ColorUtilities.modifyAlpha(track.getColor(), alpha));
            track.setAltColor(ColorUtilities.modifyAlpha(track.getAltColor(), alpha));
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.resetLastY();
        for (DataTrack track : this.memberTracks) {
            if (this.isRepeatY(rect)) {
                track.overlay(context, rect);
                continue;
            }
            track.render(context, rect);
            this.lastRenderY = rect.y;
        }
    }

    @Override
    public int getHeight() {
        int height = super.getHeight();
        for (DataTrack track : this.memberTracks) {
            height = Math.max(height, track.getHeight());
        }
        return height;
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        for (DataTrack track : this.memberTracks) {
            track.setHeight(height);
        }
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        super.setDataRange(axisDefinition);
        for (DataTrack track : this.memberTracks) {
            track.setDataRange(axisDefinition);
        }
    }

    @Override
    public DataRange getDataRange() {
        if (this.dataRange == null) {
            this.dataRange = DataRange.getFromTracks(this.memberTracks);
        }
        return this.dataRange;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        StringBuilder builder = new StringBuilder(this.memberTracks.size() + 2);
        builder.append(this.getName());
        builder.append("<br/>--------------<br/>");
        for (DataTrack track : this.memberTracks) {
            String curS = track.getValueStringAt(chr, position, y, frame);
            if (curS == null) continue;
            builder.append(curS);
            builder.append("<br/>--------------<br/>");
        }
        return builder.toString();
    }

    @Override
    public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        return null;
    }

    @Override
    public void setRendererClass(Class rc) {
        super.setRendererClass(rc);
        for (DataTrack track : this.memberTracks) {
            track.setRendererClass(rc);
        }
    }

    @Override
    public boolean getAutoScale() {
        boolean autoScale = super.getAutoScale();
        for (DataTrack track : this.memberTracks) {
            autoScale &= track.getAutoScale();
        }
        return autoScale;
    }

    @Override
    public void setAutoScale(boolean autoScale) {
        super.setAutoScale(autoScale);
        for (DataTrack track : this.memberTracks) {
            track.setAutoScale(autoScale);
        }
    }

    @Override
    public ContinuousColorScale getColorScale() {
        return super.getColorScale();
    }

    @Override
    public void setColorScale(ContinuousColorScale colorScale) {
        super.setColorScale(colorScale);
        for (DataTrack track : this.memberTracks) {
            track.setColorScale(colorScale);
        }
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
        super.setWindowFunction(type);
        for (DataTrack track : this.memberTracks) {
            track.setWindowFunction(type);
        }
    }

    @Override
    public void setShowDataRange(boolean showDataRange) {
        super.setShowDataRange(showDataRange);
        for (DataTrack track : this.memberTracks) {
            track.setShowDataRange(showDataRange);
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        final List<Track> selfAsList = Arrays.asList(this);
        menu.add(TrackMenuUtils.getTrackRenameItem(selfAsList));
        JMenu setPosColorMenu = new JMenu("Change Track Color (Positive Values)");
        JMenu setNegColorMenu = new JMenu("Change Track Color (Negative Values)");
        for (DataTrack track : this.memberTracks) {
            ColorIcon posColorIcon = new ColorIcon(track.getColor());
            JMenuItem posItem = new JMenuItem(track.getName(), posColorIcon);
            posItem.addActionListener(new ChangeTrackColorActionListener(track, ChangeTrackMethod.POSITIVE));
            setPosColorMenu.add(posItem);
            ColorIcon negColorIcon = new ColorIcon(track.getAltColor());
            JMenuItem negItem = new JMenuItem(track.getName(), negColorIcon);
            negItem.addActionListener(new ChangeTrackColorActionListener(track, ChangeTrackMethod.NEGATIVE));
            setNegColorMenu.add(negItem);
        }
        menu.add(setPosColorMenu);
        menu.add(setNegColorMenu);
        menu.add(TrackMenuUtils.getChangeTrackHeightItem(selfAsList));
        menu.add(TrackMenuUtils.getChangeFontSizeItem(selfAsList));
        menu.addSeparator();
        TrackMenuUtils.addDataItems(menu, selfAsList);
        for (Component c : menu.getComponents()) {
            if (!(c instanceof JMenuItem)) continue;
            String text = ((JMenuItem)c).getText();
            String string = text = text != null ? text.toLowerCase() : "null";
            if (!text.contains("heatmap")) continue;
            c.setEnabled(false);
        }
        menu.addSeparator();
        JMenuItem unmergeItem = new JMenuItem("Separate Tracks");
        unmergeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackPanel panel = TrackPanel.getParentPanel(MergedTracks.this);
                MergedTracks.this.setTrackAlphas(255);
                panel.addTracks(MergedTracks.this.memberTracks);
                panel.moveSelectedTracksTo(MergedTracks.this.memberTracks, MergedTracks.this, true);
                IGV.getInstance().removeTracks(selfAsList);
            }
        });
        menu.add(unmergeItem);
        menu.add(TrackMenuUtils.getRemoveMenuItem(selfAsList));
        return menu;
    }

    private MergedTracks() {
        super(null, null, null);
    }

    private static MergedTracks getNextTrack() {
        MergedTracks out = (MergedTracks)IGVSessionReader.getNextTrack();
        if (out == null) {
            out = new MergedTracks();
        }
        return out;
    }

    private static class ColorIcon
    implements Icon {
        private Color color;
        private int iconSize;

        ColorIcon(Color color) {
            this(color, 16);
        }

        ColorIcon(Color color, int iconSize) {
            this.color = color;
            this.iconSize = iconSize;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics cg = g.create();
            cg.setColor(this.color);
            if (this.iconSize > c.getHeight()) {
                this.iconSize = c.getHeight();
            }
            cg.fillRect(x, y, this.iconSize, this.iconSize);
        }

        @Override
        public int getIconWidth() {
            return this.iconSize;
        }

        @Override
        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class ChangeTrackColorActionListener
    implements ActionListener {
        private Track mTrack;
        private ChangeTrackMethod method;

        private ChangeTrackColorActionListener(Track track, ChangeTrackMethod method) {
            this.mTrack = track;
            this.method = method;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.method) {
                case POSITIVE: {
                    TrackMenuUtils.changeTrackColor(Arrays.asList(this.mTrack));
                    break;
                }
                case NEGATIVE: {
                    TrackMenuUtils.changeAltTrackColor(Arrays.asList(this.mTrack));
                    break;
                }
                default: {
                    throw new IllegalStateException("Method not understood: " + (Object)((Object)this.method));
                }
            }
        }
    }

    private static enum ChangeTrackMethod {
        POSITIVE,
        NEGATIVE;

    }
}

