/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.PluginFeatureSource;
import org.broad.igv.cli_plugin.PluginSource;
import org.broad.igv.feature.CachingFeatureSource;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.tools.FeatureSearcher;
import org.broad.igv.tools.motiffinder.MotifFinderSource;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrackUtils;
import org.broad.igv.track.PackedFeatures;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.event.DataLoadedEvent;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.variant.VariantTrack;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlType(factoryMethod="getNextTrack")
@XmlSeeAlso(value={VariantTrack.class, PluginFeatureSource.class, MotifFinderSource.class})
public class FeatureTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(FeatureTrack.class);
    @XmlAttribute
    protected Class clazz = FeatureTrack.class;
    public static final int MINIMUM_FEATURE_SPACING = 5;
    public static final int DEFAULT_MARGIN = 5;
    public static final int NO_FEATURE_ROW_SELECTED = -1;
    protected static final Color SELECTED_FEATURE_ROW_COLOR = new Color(100, 100, 100, 30);
    private static final int DEFAULT_EXPANDED_HEIGHT = 35;
    private static final int DEFAULT_SQUISHED_HEIGHT = 12;
    private int expandedRowHeight = 35;
    private int squishedRowHeight = 12;
    boolean fatalLoadError = false;
    Track.DisplayMode lastFeatureMode = null;
    protected List<Rectangle> levelRects = new ArrayList<Rectangle>();
    protected Map<String, PackedFeatures<IGVFeature>> packedFeaturesMap = Collections.synchronizedMap(new HashMap());
    private FeatureRenderer renderer;
    private DataRenderer coverageRenderer;
    private boolean showFeatures = true;
    protected FeatureSource source;
    protected boolean featuresLoading = false;
    protected int selectedFeatureRowIndex = -1;
    protected IGVFeature selectedFeature = null;
    int margin = 5;
    private static boolean drawBorder = true;
    private boolean alternateExonColor = false;
    private static final String PLUGIN_SOURCE = "PluginSource";
    private static final String SEQUENCE_MATCH_SOURCE = "SequenceMatchSource";
    private static Object loadLock = new Object();

    public FeatureTrack(String id, String name) {
        super(id, name);
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, String id, String name) {
        super(locator, id, name);
        this.setSortable(false);
    }

    public FeatureTrack(String id, String name, FeatureSource source) {
        super(id, name);
        this.init(source, null);
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, String id, String name, FeatureSource source) {
        super(locator, id, name);
        this.init(source, locator.getPath());
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, FeatureSource source) {
        super(locator);
        this.init(source, locator != null ? locator.getPath() : null);
        this.setSortable(false);
    }

    public FeatureTrack(ResourceLocator locator, String id, FeatureSource source) {
        super(locator, id);
        this.init(source, locator.getPath());
    }

    public FeatureTrack(FeatureTrack featureTrack) {
        this(featureTrack.getId(), featureTrack.getName(), featureTrack.source);
    }

    protected void init(FeatureSource source, String path) {
        this.source = source;
        this.setMinimumHeight(10);
        this.setColor(Color.blue.darker());
        this.coverageRenderer = new BarChartRenderer();
        if (source.getFeatureWindowSize() > 0) {
            this.visibilityWindow = source.getFeatureWindowSize();
        }
        this.renderer = path != null && path.endsWith("junctions.bed") ? new SpliceJunctionRenderer() : new IGVFeatureRenderer();
    }

    @Override
    public boolean isFilterable() {
        return false;
    }

    @Override
    public int getHeight() {
        if (!this.isVisible()) {
            return 0;
        }
        int rowHeight = this.getDisplayMode() == Track.DisplayMode.SQUISHED ? this.squishedRowHeight : this.expandedRowHeight;
        int minHeight = rowHeight * Math.max(1, this.getNumberOfFeatureLevels());
        return Math.max(minHeight, super.getHeight());
    }

    public int getExpandedRowHeight() {
        return this.expandedRowHeight;
    }

    public void setExpandedRowHeight(int expandedRowHeight) {
        this.expandedRowHeight = expandedRowHeight;
    }

    public int getSquishedRowHeight() {
        return this.squishedRowHeight;
    }

    public void setSquishedRowHeight(int squishedRowHeight) {
        this.squishedRowHeight = squishedRowHeight;
    }

    public int getFeatureWindowSize() {
        return this.source.getFeatureWindowSize();
    }

    @Override
    public void setRendererClass(Class rc) {
        try {
            this.renderer = (FeatureRenderer)rc.newInstance();
        }
        catch (Exception ex) {
            log.error((Object)"Error instatiating renderer ", (Throwable)ex);
        }
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    @Override
    public void setProperties(TrackProperties trackProperties) {
        super.setProperties(trackProperties);
        if (trackProperties.getFeatureVisibilityWindow() >= 0) {
            this.setVisibilityWindow(trackProperties.getFeatureVisibilityWindow());
        }
        this.alternateExonColor = trackProperties.isAlternateExonColor();
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfFeatureLevels() {
        if (this.areFeaturesStacked() && this.packedFeaturesMap.size() > 0) {
            int n = 0;
            Map<String, PackedFeatures<IGVFeature>> map = this.packedFeaturesMap;
            synchronized (map) {
                for (PackedFeatures<IGVFeature> pf : this.packedFeaturesMap.values()) {
                    if (pf == null) continue;
                    n = Math.max(n, pf.getRowCount());
                }
            }
            return n;
        }
        return 1;
    }

    protected boolean areFeaturesStacked() {
        return this.getDisplayMode() != Track.DisplayMode.COLLAPSED;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType scoreType, String frameName) {
        try {
            Iterator features = this.source.getFeatures(chr, start, end);
            if (features != null) {
                if (scoreType == RegionScoreType.MUTATION_COUNT && this.getTrackType() == TrackType.MUTATION) {
                    Feature f;
                    int count = 0;
                    while (features.hasNext() && (f = (Feature)features.next()).getStart() <= end) {
                        if (f.getEnd() < start) continue;
                        ++count;
                    }
                    return count;
                }
                if (scoreType == RegionScoreType.SCORE) {
                    float regionScore = 0.0f;
                    int nValues = 0;
                    while (features.hasNext()) {
                        Feature f = (Feature)features.next();
                        if (!(f instanceof IGVFeature) || f.getEnd() < start || f.getStart() > end) continue;
                        float value = ((IGVFeature)f).getScore();
                        regionScore += value;
                        ++nValues;
                    }
                    if (nValues == 0) {
                        return -3.4028235E38f;
                    }
                    return regionScore / (float)nValues;
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Error counting features.", (Throwable)e);
        }
        return -3.4028235E38f;
    }

    @Override
    public FeatureRenderer getRenderer() {
        if (this.renderer == null) {
            this.setRendererClass(IGVFeatureRenderer.class);
        }
        return this.renderer;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        if (this.showFeatures) {
            List<Feature> allFeatures = this.getAllFeatureAt(position, y, frame);
            if (allFeatures == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            boolean firstFeature = true;
            int maxNumber = 10;
            int n = 1;
            for (Feature feature : allFeatures) {
                if (feature != null && feature instanceof IGVFeature) {
                    String url;
                    if (!firstFeature) {
                        buf.append("<br/>--------------<br/>");
                    }
                    IGVFeature igvFeature = (IGVFeature)feature;
                    String vs = igvFeature.getValueString(position, null);
                    buf.append(vs);
                    if (IGV.getInstance().isShowDetailsOnClick() && (url = this.getFeatureURL(igvFeature)) != null) {
                        buf.append("<br/><a href=\"" + url + "\">" + url + "</a>");
                    }
                    firstFeature = false;
                    if (n > maxNumber) {
                        buf.append("...");
                        break;
                    }
                }
                ++n;
            }
            return buf.toString();
        }
        int zoom = Math.max(0, frame.getZoom());
        if (this.source == null) {
            return null;
        }
        List<LocusScore> scores = this.source.getCoverageScores(chr, (int)position - 10, (int)position + 10, zoom);
        if (scores == null) {
            return "";
        }
        double bpPerPixel = frame.getScale();
        int minWidth = (int)(2.0 * bpPerPixel);
        LocusScore score = FeatureUtils.getFeatureAt(position, minWidth, scores);
        return score == null ? null : "Mean count: " + score.getScore();
    }

    private String getFeatureURL(IGVFeature igvFeature) {
        String trackURL;
        String url = igvFeature.getURL();
        if (url == null && (trackURL = this.getUrl()) != null && igvFeature.getIdentifier() != null) {
            String encodedID = StringUtils.encodeURL(igvFeature.getIdentifier());
            url = trackURL.replaceAll("\\$\\$", encodedID);
        }
        return url;
    }

    public List<Feature> getFeatures(String chr, int start, int end) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        try {
            Iterator iter = this.source.getFeatures(chr, start, end);
            while (iter.hasNext()) {
                features.add((Feature)iter.next());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return features;
    }

    private List<Feature> getAllFeatureAt(double position, int y, ReferenceFrame frame) {
        int featureRow = this.getFeatureRow(y);
        return this.getFeaturesAtPositionInFeatureRow(position, featureRow, frame);
    }

    private int getFeatureRow(int y) {
        int featureRow = 0;
        if (this.levelRects != null) {
            for (int i = 0; i < this.levelRects.size(); ++i) {
                Rectangle r = this.levelRects.get(i);
                if (y < r.y || !((double)y <= r.getMaxY())) continue;
                featureRow = i;
                break;
            }
        }
        return featureRow;
    }

    public List<Feature> getFeaturesAtPositionInFeatureRow(double position, int featureRow, ReferenceFrame frame) {
        PackedFeatures<IGVFeature> packedFeatures = this.packedFeaturesMap.get(frame.getName());
        if (packedFeatures == null) {
            return null;
        }
        int nLevels = this.areFeaturesStacked() ? packedFeatures.getRowCount() : 1;
        List<IGVFeature> possFeatures = null;
        possFeatures = nLevels > 1 && featureRow < nLevels ? packedFeatures.getRows().get(featureRow).getFeatures() : packedFeatures.getFeatures();
        List<Feature> featureList = null;
        if (possFeatures != null) {
            double bpPerPixel = frame.getScale();
            double minWidth = 5.0 * bpPerPixel;
            int maxFeatureLength = packedFeatures.getMaxFeatureLength();
            featureList = FeatureUtils.getAllFeaturesAt(position, maxFeatureLength, minWidth, possFeatures);
        }
        return featureList;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return WindowFunction.count;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        if (this.areFeaturesStacked() && this.levelRects != null) {
            for (int i = 0; i < this.levelRects.size(); ++i) {
                Rectangle rect = this.levelRects.get(i);
                if (!rect.contains(e.getPoint())) continue;
                if (i == this.selectedFeatureRowIndex) {
                    this.setSelectedFeatureRowIndex(-1);
                } else {
                    this.setSelected(true);
                    this.setSelectedFeatureRowIndex(i);
                }
                IGV.getInstance().doRefresh();
                break;
            }
        }
        this.selectedFeature = null;
        Feature f = this.getFeatureAtMousePosition(te);
        if (f != null && f instanceof IGVFeature) {
            IGVFeature igvFeature = (IGVFeature)f;
            this.selectedFeature = this.selectedFeature != null && igvFeature.contains(this.selectedFeature) && this.selectedFeature.contains(igvFeature) ? null : igvFeature;
            if (IGV.getInstance().isShowDetailsOnClick()) {
                this.openTooltipWindow(te);
            } else {
                String url = this.getFeatureURL(igvFeature);
                if (url != null) {
                    try {
                        BrowserLauncher.openURL(url);
                    }
                    catch (IOException e1) {
                        log.error((Object)("Error launching url: " + url));
                    }
                    e.consume();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Feature getFeatureAtMousePosition(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        ReferenceFrame referenceFrame = te.getFrame();
        if (referenceFrame != null) {
            double location = referenceFrame.getChromosomePosition(e.getX());
            List<Feature> features = this.getAllFeatureAt(location, e.getY(), referenceFrame);
            return features != null && features.size() > 0 ? features.get(0) : null;
        }
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    @Override
    public void overlay(RenderContext context, Rectangle rect) {
        this.renderFeatures(context, rect);
    }

    @Override
    public void setDisplayMode(Track.DisplayMode mode) {
        this.lastFeatureMode = null;
        super.setDisplayMode(mode);
    }

    @Override
    public void load(RenderContext context) {
        ReferenceFrame frame = context.getReferenceFrame();
        PackedFeatures<IGVFeature> packedFeatures = this.packedFeaturesMap.get(frame.getName());
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation();
        if (packedFeatures == null || !packedFeatures.containsInterval(chr, start, end)) {
            try {
                context.getReferenceFrame().getEventBus().unregister((Object)this);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            this.loadFeatures(frame.getChrName(), (int)frame.getOrigin(), (int)frame.getEnd(), context);
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        Rectangle renderRect = new Rectangle(rect);
        renderRect.y += this.margin;
        renderRect.height -= this.margin;
        this.showFeatures = this.isShowFeatures(context);
        if (this.showFeatures) {
            if (this.lastFeatureMode != null) {
                super.setDisplayMode(this.lastFeatureMode);
                this.lastFeatureMode = null;
            }
            this.renderFeatures(context, renderRect);
        } else {
            if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED && !(this instanceof VariantTrack)) {
                this.lastFeatureMode = this.getDisplayMode();
                super.setDisplayMode(Track.DisplayMode.COLLAPSED);
            }
            this.renderCoverage(context, renderRect);
        }
        if (drawBorder) {
            Graphics2D borderGraphics = context.getGraphic2DForColor(UIConstants.TRACK_BORDER_GRAY);
            borderGraphics.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
            borderGraphics.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        }
    }

    protected boolean isShowFeatures(RenderContext context) {
        if (context.getChr().equals("All")) {
            return false;
        }
        double windowSize = context.getEndLocation() - context.getOrigin();
        int vw = this.getVisibilityWindow();
        return vw <= 0 || windowSize <= (double)vw;
    }

    protected void renderCoverage(RenderContext context, Rectangle inputRect) {
        List<LocusScore> scores;
        if (this.source == null) {
            return;
        }
        String chr = context.getChr();
        List<LocusScore> list = scores = chr.equals("All") ? this.source.getCoverageScores(chr, (int)context.getOrigin(), (int)context.getEndLocation(), context.getZoom()) : null;
        if (scores == null) {
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            Rectangle textRect = new Rectangle(inputRect);
            textRect.height = Math.min(inputRect.height, 20);
            String message = chr.equals("All") ? "Zoom in to see features." : "Zoom in to see features, or right-click to increase Feature Visibility Window.";
            GraphicUtils.drawCenteredText(message, textRect, g);
        } else {
            float max = this.getMaxEstimate(scores);
            ContinuousColorScale cs = this.getColorScale();
            if (cs != null) {
                cs.setPosEnd(max);
            }
            this.setDataRange(new DataRange(0.0f, 0.0f, max));
            this.coverageRenderer.render(scores, context, inputRect, (Track)this);
        }
    }

    private float getMaxEstimate(List<LocusScore> scores) {
        float max = 0.0f;
        int n = Math.min(200, scores.size());
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, scores.get(i).getScore());
        }
        return max;
    }

    protected void renderFeatures(RenderContext context, Rectangle inputRect) {
        block6: {
            if (this.featuresLoading || this.fatalLoadError) {
                return;
            }
            if (log.isTraceEnabled()) {
                String msg = String.format("renderFeatures: %s frame: %s", this.getName(), context.getReferenceFrame().getName());
                log.trace((Object)msg);
            }
            this.load(context);
            PackedFeatures<IGVFeature> packedFeatures = this.packedFeaturesMap.get(context.getReferenceFrame().getName());
            if (packedFeatures == null || !packedFeatures.overlapsInterval(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation() + 1)) {
                return;
            }
            try {
                this.renderFeatureImpl(context, inputRect, packedFeatures);
            }
            catch (TribbleException e) {
                log.error((Object)"Tribble error", (Throwable)e);
                if (this.fatalLoadError) break block6;
                this.fatalLoadError = true;
                boolean unload = MessageUtils.confirm("<html> Error loading features: " + e.getMessage() + "<br>Unload track " + this.getName() + "?");
                if (unload) {
                    List<Track> tmp = Arrays.asList(this);
                    IGV.getInstance().removeTracks(tmp);
                    IGV.getInstance().doRefresh();
                }
                this.fatalLoadError = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFeatureImpl(RenderContext context, Rectangle inputRect, PackedFeatures packedFeatures) {
        FeatureRenderer renderer = this.getRenderer();
        if (this.areFeaturesStacked()) {
            List<PackedFeatures.FeatureRow> rows = packedFeatures.getRows();
            if (rows != null && rows.size() > 0) {
                int nLevels = rows.size();
                List<Rectangle> list = this.levelRects;
                synchronized (list) {
                    this.levelRects.clear();
                    double h = inputRect.getHeight() / (double)nLevels;
                    Rectangle rect = new Rectangle(inputRect.x, inputRect.y, inputRect.width, (int)h);
                    int i = 0;
                    renderer.reset();
                    for (PackedFeatures.FeatureRow row : rows) {
                        this.levelRects.add(new Rectangle(rect));
                        renderer.render(row.features, context, this.levelRects.get(i), this);
                        if (this.selectedFeatureRowIndex == i) {
                            Graphics2D fontGraphics = context.getGraphic2DForColor(SELECTED_FEATURE_ROW_COLOR);
                            fontGraphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                        }
                        rect.y = (int)((double)rect.y + h);
                        ++i;
                    }
                }
            }
        } else {
            List features = packedFeatures.getFeatures();
            if (features != null) {
                renderer.render(features, context, inputRect, this);
            }
        }
    }

    protected void loadFeatures(final String chr, final int start, final int end, final RenderContext context) {
        boolean aSync = !(this.source instanceof FeatureCollectionSource);
        NamedRunnable runnable = new NamedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    FeatureTrack.this.featuresLoading = true;
                    Object object = loadLock;
                    synchronized (object) {
                        Iterator iter;
                        Chromosome c;
                        Genome genome;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("Loading features: %s:%d-%d", chr, start, end));
                        }
                        int delta = (end - start) / 2;
                        int expandedStart = start - delta;
                        int expandedEnd = end + delta;
                        if (start >= 0) {
                            expandedStart = Math.max(0, expandedStart);
                        }
                        if ((genome = GenomeManager.getInstance().getCurrentGenome()) != null && (c = genome.getChromosome(chr)) != null && end < c.getLength()) {
                            expandedEnd = Math.min(c.getLength(), expandedEnd);
                        }
                        if ((iter = FeatureTrack.this.source.getFeatures(chr, expandedStart, expandedEnd)) == null) {
                            PackedFeatures pf = new PackedFeatures(chr, expandedStart, expandedEnd);
                            FeatureTrack.this.packedFeaturesMap.put(context.getReferenceFrame().getName(), pf);
                        } else {
                            PackedFeatures pf = new PackedFeatures(chr, expandedStart, expandedEnd, iter, this.getName());
                            FeatureTrack.this.packedFeaturesMap.put(context.getReferenceFrame().getName(), pf);
                        }
                    }
                    context.getReferenceFrame().getEventBus().post((Object)new DataLoadedEvent(context));
                }
                catch (Exception e) {
                    PackedFeatures pf = new PackedFeatures(chr, start, end);
                    FeatureTrack.this.packedFeaturesMap.put(context.getReferenceFrame().getName(), pf);
                    String msg = "Error loading features for interval: " + chr + ":" + start + "-" + end + " <br>" + e.toString();
                    MessageUtils.showMessage(msg);
                    log.error((Object)msg, (Throwable)e);
                }
                finally {
                    FeatureTrack.this.featuresLoading = false;
                }
            }

            @Override
            public String getName() {
                return "Load features: " + FeatureTrack.this.getName();
            }
        };
        if (aSync) {
            context.getReferenceFrame().getEventBus().register((Object)this);
            LongRunningTask.submit(runnable);
        } else {
            runnable.run();
        }
    }

    @Subscribe
    private void receiveDataLoaded(DataLoadedEvent event) {
        JComponent panel;
        if (IGV.hasInstance()) {
            IGV.getInstance().layoutMainPanel();
        }
        if ((panel = event.context.getPanel()) != null) {
            panel.repaint();
        }
    }

    public Feature nextFeature(String chr, double center, boolean forward, ReferenceFrame frame) throws IOException {
        Feature f = null;
        boolean canScroll = forward && !frame.windowAtEnd() || !forward && frame.getOrigin() > 0.0;
        PackedFeatures<IGVFeature> packedFeatures = this.packedFeaturesMap.get(frame.getName());
        if (packedFeatures != null && packedFeatures.containsInterval(chr, (int)center - 1, (int)center + 1)) {
            if (packedFeatures.getFeatures().size() > 0 && canScroll) {
                Feature feature = f = forward ? FeatureUtils.getFeatureAfter(center + 1.0, packedFeatures.getFeatures()) : FeatureUtils.getFeatureBefore(center - 1.0, packedFeatures.getFeatures());
            }
            if (f == null) {
                FeatureSource rawSource = this.source;
                if (this.source instanceof CachingFeatureSource) {
                    rawSource = ((CachingFeatureSource)this.source).getSource();
                }
                if (rawSource instanceof MotifFinderSource || rawSource instanceof PluginFeatureSource) {
                    FeatureTrackUtils.nextFeatureSearch(this.source, chr, packedFeatures.getStart(), packedFeatures.getEnd(), forward, new FeatureSearcher.GotoFeatureHandler());
                } else {
                    f = FeatureTrackUtils.nextFeature(this.source, chr, packedFeatures.getStart(), packedFeatures.getEnd(), forward);
                }
            }
        }
        return f;
    }

    @Override
    public void setVisibilityWindow(int windowSize) {
        super.setVisibilityWindow(windowSize);
        this.packedFeaturesMap.clear();
        this.source.setFeatureWindowSize(this.visibilityWindow);
    }

    public int getSelectedFeatureRowIndex() {
        return this.selectedFeatureRowIndex;
    }

    public void setSelectedFeatureRowIndex(int selectedFeatureRowIndex) {
        this.selectedFeatureRowIndex = selectedFeatureRowIndex;
    }

    public IGVFeature getSelectedFeature() {
        return this.selectedFeature;
    }

    public static boolean isDrawBorder() {
        return drawBorder;
    }

    public static void setDrawBorder(boolean drawBorder) {
        FeatureTrack.drawBorder = drawBorder;
    }

    public boolean isAlternateExonColor() {
        return this.alternateExonColor;
    }

    private static FeatureTrack getNextTrack() {
        FeatureTrack out = (FeatureTrack)IGVSessionReader.getNextTrack();
        if (out == null) {
            out = new FeatureTrack((String)null, null);
        }
        return out;
    }

    @Override
    public void restorePersistentState(Node node, int version) throws JAXBException {
        super.restorePersistentState(node, version);
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            for (int ii = 0; ii < childNodes.getLength(); ++ii) {
                Node child = childNodes.item(ii);
                String nodeName = child.getNodeName();
                if (nodeName.contains("#text")) continue;
                if (nodeName.equalsIgnoreCase(PLUGIN_SOURCE)) {
                    this.source = (FeatureSource)IGVSessionReader.getJAXBContext().createUnmarshaller().unmarshal(child, PluginFeatureSource.class).getValue();
                    continue;
                }
                if (nodeName.equalsIgnoreCase(SEQUENCE_MATCH_SOURCE)) {
                    FeatureSource rawSource = (FeatureSource)IGVSessionReader.getJAXBContext().createUnmarshaller().unmarshal(child, MotifFinderSource.class).getValue();
                    this.source = new CachingFeatureSource(rawSource);
                    continue;
                }
                try {
                    FeatureSource newSource;
                    this.source = newSource = (FeatureSource)IGVSessionReader.getJAXBContext().createUnmarshaller().unmarshal(child, Class.forName(nodeName)).getValue();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void marshalSource(Marshaller m, Element trackElement) throws JAXBException {
        if (this.source == null) {
            return;
        }
        FeatureSource rawSource = this.source;
        if (rawSource instanceof CachingFeatureSource) {
            rawSource = ((CachingFeatureSource)rawSource).getSource();
        }
        if (rawSource instanceof PluginSource) {
            JAXBElement element = new JAXBElement(new QName("", PLUGIN_SOURCE), PluginSource.class, (Object)((PluginSource)((Object)rawSource)));
            m.marshal((Object)element, (Node)trackElement);
        } else if (rawSource instanceof MotifFinderSource) {
            JAXBElement element = new JAXBElement(new QName("", SEQUENCE_MATCH_SOURCE), MotifFinderSource.class, (Object)((MotifFinderSource)rawSource));
            m.marshal((Object)element, (Node)trackElement);
        } else {
            Class<?> srcClazz = rawSource.getClass();
            JAXBElement element = new JAXBElement(new QName("", srcClazz.getName()), srcClazz, (Object)rawSource);
            try {
                m.marshal((Object)element, (Node)trackElement);
            }
            catch (MarshalException e) {
                // empty catch block
            }
        }
    }

    public void updateTrackReferences(List<Track> allTracks) {
        if (this.source instanceof PluginSource) {
            ((PluginSource)((Object)this.source)).updateTrackReferences(allTracks);
        }
    }

    public void clearPackedFeatures() {
        this.packedFeaturesMap.clear();
    }
}

