/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.broad.igv.tools.IgvTools;

public class IndexGui
extends JDialog {
    IgvTools igvTools = new IgvTools();
    private JPanel mainPanel;
    private JPanel requiredPanel;
    private JLabel outputLabel;
    private JButton outputButton;
    private JTextField inputField;
    private JButton inputButton;
    private JTextField outputField;
    private JButton genomeButton;
    private JPanel buttonPanel;
    private JButton runButton;
    private JButton closeButton;
    private JPanel OutputPanel;
    private JScrollPane outputScroll;
    private JTextArea outputText;
    private JProgressBar progressBar;

    public IndexGui() {
        this.initComponents();
        this.setTitle("Create Index");
        this.outputLabel.setVisible(true);
        this.outputField.setVisible(true);
        this.outputButton.setVisible(true);
    }

    private void inputFieldFocusLost(FocusEvent e) {
    }

    private void inputFieldActionPerformed(ActionEvent e) {
    }

    private void inputButtonActionPerformed(ActionEvent e) {
    }

    private void doIndex() {
        SwingWorker swingWorker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    IndexGui.this.setCursor(Cursor.getPredefinedCursor(3));
                    String ifile = IndexGui.this.inputField.getText();
                    int indexType = 1;
                    int binSize = 16000;
                    IndexGui.this.runButton.setEnabled(false);
                    IndexGui.this.igvTools.doIndex(ifile, null, indexType, binSize);
                }
                catch (Exception e) {
                    IndexGui.this.showMessage("Error: " + e.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                IndexGui.this.runButton.setEnabled(true);
                IndexGui.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        swingWorker.execute();
    }

    private void showMessage(String tool) {
        JOptionPane.showMessageDialog(this, tool);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.requiredPanel = new JPanel();
        JLabel label2 = new JLabel();
        this.outputLabel = new JLabel();
        this.outputButton = new JButton();
        this.inputField = new JTextField();
        this.inputButton = new JButton();
        this.outputField = new JTextField();
        this.genomeButton = new JButton();
        this.buttonPanel = new JPanel();
        this.runButton = new JButton();
        this.closeButton = new JButton();
        this.OutputPanel = new JPanel();
        this.outputScroll = new JScrollPane();
        this.outputText = new JTextArea();
        JSeparator separator1 = new JSeparator();
        this.progressBar = new JProgressBar();
        this.mainPanel.setBorder(new TitledBorder(new EtchedBorder(), ""));
        this.mainPanel.setLayout(new GridBagLayout());
        this.requiredPanel.setLayout(new GridBagLayout());
        label2.setText("Input File");
        this.requiredPanel.add((Component)label2, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.outputLabel.setText("Output File");
        this.requiredPanel.add((Component)this.outputLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.outputButton.setText("Browse");
        this.requiredPanel.add((Component)this.outputButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                IndexGui.this.inputFieldFocusLost(e);
            }
        });
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexGui.this.inputFieldActionPerformed(e);
            }
        });
        this.requiredPanel.add((Component)this.inputField, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.inputButton.setText("Browse");
        this.inputButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexGui.this.inputButtonActionPerformed(e);
            }
        });
        this.requiredPanel.add((Component)this.inputButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.requiredPanel.add((Component)this.outputField, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.genomeButton.setText("Browse");
        this.requiredPanel.add((Component)this.genomeButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.requiredPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.runButton.setText("Run");
        this.buttonPanel.add((Component)this.runButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.closeButton.setText("Close");
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.OutputPanel.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), "Messages", 4, 2));
        this.OutputPanel.setLayout(null);
        this.outputText.setEditable(false);
        this.outputText.setText("");
        this.outputText.setRows(10);
        this.outputScroll.setViewportView(this.outputText);
        this.OutputPanel.add(this.outputScroll);
        this.outputScroll.setBounds(4, 20, 881, this.outputScroll.getPreferredSize().height);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.OutputPanel.getComponentCount(); ++i) {
            Rectangle bounds = this.OutputPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.OutputPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.OutputPanel.setMinimumSize(preferredSize);
        this.OutputPanel.setPreferredSize(preferredSize);
        this.mainPanel.add((Component)this.OutputPanel, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.mainPanel.add((Component)separator1, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.mainPanel.add((Component)this.progressBar, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public static void launch(boolean modal) {
        IndexGui mainWindow = new IndexGui();
        mainWindow.pack();
        mainWindow.setModal(modal);
        mainWindow.setDefaultCloseOperation(2);
        mainWindow.setResizable(false);
        mainWindow.setVisible(true);
    }
}

