/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broad.igv.peaks.PeakTrack;
import org.broad.igv.ui.IGV;

public class PeakControlDialog
extends JDialog {
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JSlider scoreSlider;
    private JLabel label1;
    private JLabel label2;
    private JSlider foldChangeSlider;

    public PeakControlDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.scoreSlider.setValue((int)PeakTrack.getScoreThreshold());
        this.foldChangeSlider.setValue((int)PeakTrack.getFoldChangeThreshold());
        this.setAlwaysOnTop(true);
        this.setLocation(owner.getBounds().width - 200, 50);
    }

    private void scoreSliderStateChanged(ChangeEvent e) {
        PeakTrack.setScoreThreshold(this.scoreSlider.getValue());
        IGV.getInstance().repaintDataPanels();
    }

    private void foldChangeSliderStateChanged(ChangeEvent e) {
        PeakTrack.setFoldChangeThreshold(this.foldChangeSlider.getValue());
        IGV.getInstance().repaintDataPanels();
    }

    private void slider1PropertyChange(PropertyChangeEvent e) {
    }

    private void slider1StateChanged(ChangeEvent e) {
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.scoreSlider = new JSlider();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.foldChangeSlider = new JSlider();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(null);
        this.scoreSlider.setPaintTicks(true);
        this.scoreSlider.setPaintLabels(true);
        this.scoreSlider.setToolTipText("Adjust score threshold");
        this.scoreSlider.setMajorTickSpacing(20);
        this.scoreSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PeakControlDialog.this.scoreSliderStateChanged(e);
            }
        });
        this.contentPanel.add(this.scoreSlider);
        this.scoreSlider.setBounds(5, 15, 215, this.scoreSlider.getPreferredSize().height);
        this.label1.setText("Score threshold:");
        this.contentPanel.add(this.label1);
        this.label1.setBounds(new Rectangle(new Point(5, 0), this.label1.getPreferredSize()));
        this.label2.setText("Fold change threshold:");
        this.contentPanel.add(this.label2);
        this.label2.setBounds(new Rectangle(new Point(5, 85), this.label2.getPreferredSize()));
        this.foldChangeSlider.setPaintTicks(true);
        this.foldChangeSlider.setPaintLabels(true);
        this.foldChangeSlider.setToolTipText("Adjust score threshold");
        this.foldChangeSlider.setMajorTickSpacing(2);
        this.foldChangeSlider.setMinorTickSpacing(1);
        this.foldChangeSlider.setMaximum(10);
        this.foldChangeSlider.setValue(0);
        this.foldChangeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PeakControlDialog.this.foldChangeSliderStateChanged(e);
            }
        });
        this.contentPanel.add(this.foldChangeSlider);
        this.foldChangeSlider.setBounds(5, 100, 215, 52);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            Rectangle bounds = this.contentPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.contentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.contentPanel.setMinimumSize(preferredSize);
        this.contentPanel.setPreferredSize(preferredSize);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

