/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.Globals;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.LineFeatureDecoder;
import org.broad.igv.cli_plugin.LineFeatureEncoder;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.StringUtils;
import org.broad.tribble.Feature;

public class DGVCodec
extends UCSCCodec<BasicFeature>
implements LineFeatureEncoder<Feature>,
LineFeatureDecoder<BasicFeature> {
    static final Pattern BR_PATTERN = Pattern.compile("<br>");
    static final Pattern EQ_PATTERN = Pattern.compile("=");
    Genome genome;
    static String[] attributeLabels = new String[]{"Type", "Reference", "PubMed ID", "Method", "Platform", "Merged variants", "Supporting variants", "Sample size", "Observed gains", "Observed losses", "Cohort description", "Genes", "Samples"};

    public DGVCodec() {
        this((Genome)null);
    }

    public DGVCodec(Genome genome) {
        super(BasicFeature.class);
        this.genome = genome;
    }

    public BasicFeature decode(String[] tokens) {
        int tokenCount = tokens.length;
        String c = tokens[0];
        String chr = this.genome == null ? c : this.genome.getChromosomeAlias(c);
        int start = Integer.parseInt(tokens[1]);
        int end = Integer.parseInt(tokens[2]);
        BasicFeature feature = new BasicFeature(chr, start, end);
        String name = tokens[3].replaceAll("\"", "");
        feature.setName(name);
        feature.setIdentifier(name);
        String colorString = tokens[4];
        if (colorString.trim().length() > 0 && !colorString.equals(".")) {
            feature.setColor(ColorUtilities.stringToColor(colorString));
        }
        for (int i = 5; i < tokens.length; ++i) {
            if (tokens[i].length() <= 0) continue;
            feature.setAttribute(attributeLabels[i - 5], tokens[i]);
        }
        return feature;
    }

    @Override
    public BasicFeature decode(String nextLine) {
        if (nextLine.trim().length() == 0) {
            return null;
        }
        if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            this.readHeaderLine(nextLine);
            return null;
        }
        String[] tokens = Globals.tabPattern.split(nextLine);
        return this.decode(tokens);
    }

    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".bed");
    }

    @Override
    public String encode(Feature feature) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(feature.getChr());
        buffer.append("\t");
        int featureStart = feature.getStart();
        buffer.append(String.valueOf(featureStart));
        buffer.append("\t");
        buffer.append(String.valueOf(feature.getEnd()));
        BasicFeature basicFeature = null;
        if (!(feature instanceof BasicFeature)) {
            return buffer.toString();
        }
        basicFeature = (BasicFeature)feature;
        if (basicFeature.getName() != null || this.gffTags && basicFeature.getDescription() != null) {
            boolean more;
            buffer.append("\t");
            if (this.gffTags && basicFeature.getDescription() != null) {
                String[] attrs = BR_PATTERN.split(basicFeature.getDescription());
                buffer.append("\"");
                for (String att : attrs) {
                    String[] kv = EQ_PATTERN.split(att, 2);
                    if (kv.length <= 1) continue;
                    buffer.append(kv[0].trim());
                    buffer.append("=");
                    String value = kv[1].trim();
                    buffer.append(StringUtils.encodeURL(value));
                    buffer.append(";");
                }
                buffer.append("\"");
            } else {
                buffer.append(basicFeature.getName());
            }
            boolean bl = more = !Float.isNaN(basicFeature.getScore()) || basicFeature.getStrand() != Strand.NONE || basicFeature.getColor() != null || basicFeature.getExonCount() > 0;
            if (more) {
                buffer.append("\t");
                float score = basicFeature.getScore();
                if (Float.isNaN(score)) {
                    buffer.append("1000");
                } else {
                    boolean isInt = Math.floor(score) == (double)score;
                    buffer.append(String.valueOf(isInt ? (float)((int)score) : score));
                }
                boolean bl2 = more = basicFeature.getStrand() != Strand.NONE || basicFeature.getColor() != null || basicFeature.getExonCount() > 0;
                if (more) {
                    buffer.append("\t");
                    Strand strand = basicFeature.getStrand();
                    if (strand == Strand.NONE) {
                        buffer.append(" ");
                    } else if (strand == Strand.POSITIVE) {
                        buffer.append("+");
                    } else if (strand == Strand.NEGATIVE) {
                        buffer.append("-");
                    }
                    boolean bl3 = more = basicFeature.getColor() != null || basicFeature.getExonCount() > 0;
                    if (more) {
                        List<Exon> exons = basicFeature.getExons();
                        if (basicFeature.getColor() != null || exons != null) {
                            buffer.append("\t");
                            buffer.append(String.valueOf(basicFeature.getThickStart()));
                            buffer.append("\t");
                            buffer.append(String.valueOf(basicFeature.getThickEnd()));
                            buffer.append("\t");
                            Color c = basicFeature.getColor();
                            buffer.append(c == null ? "." : ColorUtilities.colorToString(c));
                            buffer.append("\t");
                            if (exons != null && exons.size() > 0) {
                                buffer.append(String.valueOf(exons.size()));
                                buffer.append("\t");
                                for (Exon exon : exons) {
                                    buffer.append(String.valueOf(exon.getLength()));
                                    buffer.append(",");
                                }
                                buffer.append("\t");
                                for (Exon exon : exons) {
                                    int exonStart = exon.getStart() - featureStart;
                                    buffer.append(String.valueOf(exonStart));
                                    buffer.append(",");
                                }
                            }
                        }
                    }
                }
            }
        }
        return buffer.toString();
    }

    @Override
    public int getNumCols(String line) {
        return line.split("\t").length;
    }

    @Override
    public String getHeader() {
        return null;
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap, Argument argument) {
    }
}

