/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.AbstractCacher;
import org.broad.igv.feature.tribble.IGVFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureReader;

public class CachingFeatureReader
extends AbstractCacher
implements IGVFeatureReader {
    private static Logger log = Logger.getLogger(CachingFeatureReader.class);
    private static int maxBinCount = 1000;
    private static int defaultBinSize = 16000;
    private FeatureReader tribbleFeatureReader;

    public CachingFeatureReader(FeatureReader tribbleFeatureReader) {
        this(tribbleFeatureReader, maxBinCount, defaultBinSize);
    }

    public CachingFeatureReader(FeatureReader tribbleFeatureReader, int binCount, int binSize) {
        super(binCount, binSize);
        this.tribbleFeatureReader = tribbleFeatureReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iterator<Feature> queryRaw(String chr, int start, int end) throws IOException {
        CloseableTribbleIterator iter = null;
        try {
            Feature f;
            iter = this.tribbleFeatureReader.query(chr, start, end);
            ArrayList<Feature> featureList = new ArrayList<Feature>();
            while (iter.hasNext() && (f = (Feature)iter.next()).getStart() <= end) {
                if (f.getEnd() < start) continue;
                featureList.add(f);
            }
            Iterator<Feature> iterator = featureList.iterator();
            return iterator;
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return this.tribbleFeatureReader.getSequenceNames();
    }

    @Override
    public Object getHeader() {
        return this.tribbleFeatureReader.getHeader();
    }

    public Iterator query(String chr, int start, int end) throws IOException {
        return this.queryCached(chr, start, end);
    }

    public Iterator iterator() throws IOException {
        return this.tribbleFeatureReader.iterator();
    }
}

