/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.feature.AbstractCacher;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.FeatureSource;
import org.broad.tribble.Feature;

public class CachingFeatureSource
extends AbstractCacher
implements FeatureSource {
    private static final int maxBinCount = 1000;
    private static final int defaultBinSize = 16000;
    private FeatureSource source;

    public CachingFeatureSource(FeatureSource source) {
        this(source, 1000, 16000);
    }

    public CachingFeatureSource(FeatureSource source, int binCount, int binSize) {
        super(binCount, binSize);
        this.source = source;
    }

    @Override
    protected Iterator<Feature> queryRaw(String chr, int start, int end) throws IOException {
        return this.source.getFeatures(chr, start, end);
    }

    public Iterator getFeatures(String chr, int start, int end) throws IOException {
        return super.queryCached(chr, start, end);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return this.source.getCoverageScores(chr, start, end, zoom);
    }

    @Override
    public int getFeatureWindowSize() {
        return this.source.getFeatureWindowSize();
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.source.setFeatureWindowSize(size);
    }

    public FeatureSource getSource() {
        return this.source;
    }
}

