/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IExon;
import org.broad.igv.feature.IGVFeature;
import org.jgrapht.graph.DefaultDirectedGraph;

public class AlternativeSpliceGraph<T>
extends DefaultDirectedGraph<IExon, Object> {
    private IExon lastExon = null;
    private Map<IExon, T> parameters = new HashMap<IExon, T>();

    public AlternativeSpliceGraph() {
        super(Object.class);
    }

    public AlternativeSpliceGraph(Collection<? extends IGVFeature> features) {
        this();
        super.addFeatures(features);
    }

    public boolean put(IExon exon, T parameter) {
        this.parameters.put(exon, parameter);
        return this.addExon(exon);
    }

    public T getParameter(IExon exon) {
        return this.parameters.get(exon);
    }

    public boolean hasParameter(IExon exon) {
        return this.parameters.containsKey(exon);
    }

    public boolean addExon(IExon exon) {
        boolean added = this.addVertex(exon);
        if (this.lastExon != null && this.getEdge(this.lastExon, exon) == null) {
            this.addEdge(this.lastExon, exon);
        }
        this.lastExon = exon;
        return added;
    }

    private void addFeature(IGVFeature feature) {
        this.startFeature();
        for (Exon exon : feature.getExons()) {
            this.addExon(exon);
        }
    }

    private void addFeatures(Collection<? extends IGVFeature> features) {
        for (IGVFeature iGVFeature : features) {
            this.addFeature(iGVFeature);
        }
    }

    public void startFeature() {
        this.lastExon = null;
    }
}

