/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.broad.igv.data.seg.SegmentedAsciiDataSet;
import org.broad.igv.dev.db.WholeTableDBReader;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.util.ResourceLocator;

public class SegmentedSQLReader
extends WholeTableDBReader<SegmentedAsciiDataSet> {
    private static Logger log = Logger.getLogger(SegmentedSQLReader.class);
    private Genome genome;

    public SegmentedSQLReader(ResourceLocator locator, String tableName, Genome genome) {
        super(locator, tableName, null);
        this.genome = genome;
    }

    @Override
    protected SegmentedAsciiDataSet processResultSet(ResultSet rs) throws SQLException {
        SegmentedAsciiDataSet dataset = new SegmentedAsciiDataSet(this.genome);
        while (rs.next()) {
            String sample = rs.getString("Sample");
            String chr = rs.getString("chr");
            int start = rs.getInt("start");
            int end = rs.getInt("end");
            float value = rs.getFloat("value");
            String description = rs.getString("description");
            dataset.addSegment(sample, chr, start, end, value, description);
        }
        dataset.sortLists();
        return dataset;
    }
}

