/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.broad.igv.dev.db.DBProfile;
import org.broad.igv.dev.db.WholeTableDBReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.util.ResourceLocator;

public class SampleInfoSQLReader
extends WholeTableDBReader<Void> {
    private static Logger log = Logger.getLogger(SampleInfoSQLReader.class);
    String sampleColumn;

    public SampleInfoSQLReader(DBProfile.DBTable table, String sampleColumn) {
        super(table);
        this.sampleColumn = sampleColumn;
    }

    public SampleInfoSQLReader(ResourceLocator locator, String tableName, String sampleColumn) {
        super(locator, tableName, null);
        this.sampleColumn = sampleColumn;
    }

    @Override
    protected Void processResultSet(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int nCol = metaData.getColumnCount();
        String[] columnNames = new String[nCol];
        for (int i = 0; i < nCol; ++i) {
            columnNames[i] = metaData.getColumnName(i + 1);
        }
        while (rs.next()) {
            String sample = rs.getString(this.sampleColumn);
            for (String col : columnNames) {
                if (col.equals(this.sampleColumn)) continue;
                String value = rs.getString(col);
                AttributeManager.getInstance().addAttribute(sample, col, value);
            }
        }
        return null;
    }
}

