/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import org.broad.igv.data.Interval;
import org.broad.igv.data.cufflinks.FPKMSampleValue;

public class FPKMValue
extends Interval {
    float[] fpkm;
    float[] fpkmLo;
    float[] fpkmHi;
    String gene;

    public FPKMValue(String chr, int start, int end, String gene, float[] fpkm, float[] fpkmLo, float[] fpkmHi) {
        super(chr, start, end);
        this.gene = gene;
        assert (fpkm.length == fpkmLo.length && fpkm.length == fpkmHi.length);
        this.fpkm = fpkm;
        this.fpkmLo = fpkmLo;
        this.fpkmHi = fpkmHi;
    }

    public FPKMSampleValue getSampleValue(int sampleIndex) {
        return new FPKMSampleValue(this.chr, this.start, this.end, this.gene, this.fpkm[sampleIndex], this.fpkmLo[sampleIndex], this.fpkmHi[sampleIndex]);
    }

    public String getGene() {
        return this.gene;
    }

    public int getNumSamples() {
        return this.fpkm.length;
    }
}

