/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.FeatureDecoder;
import org.broad.igv.cli_plugin.PluginSource;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.readers.PositionalBufferedStream;

public class FeatureCodecDecoder<D extends Feature>
implements FeatureDecoder<D> {
    private static Logger log = Logger.getLogger(PluginSource.class);
    private FeatureCodec<D, PositionalBufferedStream> codec;

    public FeatureCodecDecoder(FeatureCodec<D, PositionalBufferedStream> codec) {
        this.codec = codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<D> decodeAll(InputStream is, boolean strictParsing) throws IOException {
        PositionalBufferedStream pis = new PositionalBufferedStream(is);
        this.codec.readHeader((Object)pis);
        ArrayList<Feature> features = new ArrayList<Feature>();
        while (!pis.isDone()) {
            try {
                Feature feature = this.codec.decode((Object)pis);
                if (feature == null) continue;
                features.add(feature);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (!strictParsing) continue;
                throw new RuntimeException(e);
            }
            finally {
                pis.close();
            }
        }
        return features.iterator();
    }

    @Override
    public void setAttributes(List<Map<String, Object>> attributes) {
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap) {
    }
}

