/*
 * Decompiled with CFR 0.152.
 */
package com.iontorrent.views;

import com.iontorrent.data.FlowDistribution;
import com.iontorrent.utils.FileTools;
import com.iontorrent.utils.LocationListener;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGV;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class FlowSignalDistributionPanel
extends JPanel {
    public static final int TYPE_BAR = 0;
    public static final int TYPE_LINE = 1;
    public static final int TYPE_AREA = 2;
    public static final int TYPE_STACKED = 3;
    private static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(FlowSignalDistributionPanel.class);
    private int chart_type = -1;
    private FlowDistribution[] distributions;
    private int location;
    private int binsize;
    private String filename;
    private JComponent chartpanel;
    private JFreeChart freechart;
    private LocationListener listener;
    private Font font = new Font("SansSerif", 0, 10);
    static final String BASES = "ACGT";
    Shape shapea = this.getGlyphShape("A");
    Shape shapec = this.getGlyphShape("C");
    Shape shapeg = this.getGlyphShape("G");
    Shape shapet = this.getGlyphShape("T");
    Shape shapex = this.getGlyphShape("?");
    Color colA = new Color(0, 150, 30);
    Color colC = Color.BLUE.darker();
    Color colT = Color.RED.darker();
    Color colG = new Color(30, 30, 30);
    Color colX = Color.orange;
    Color[] colors = new Color[]{this.colA, this.colC, this.colG, this.colT, this.colX};
    Shape[] shapes = new Shape[]{this.shapea, this.shapec, this.shapeg, this.shapet, this.shapex};
    float[] dash = new float[]{8.0f};
    BasicStroke dashedStroke = new BasicStroke(2.0f, 0, 0, 8.0f, this.dash, 0.0f);
    private int maxx;
    private boolean ignore_events;
    private JButton btnConfigure;
    private JButton btnCopy;
    private JButton btnCopyJson;
    private JButton btnLeft;
    private JButton btnRight;
    private JButton btnSave;
    private JButton btnTSL;
    private JToolBar buttonToolBar;
    private JButton jButton1;
    private JLabel jLabel1;
    private JSpinner spinBin;

    public FlowSignalDistributionPanel(FlowDistribution[] distributions) {
        this.distributions = distributions;
        this.initComponents();
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FlowSignalDistributionPanel.this.formKeyTyped(evt);
            }
        });
        this.recreateChart();
    }

    private void getPreferences() {
        String type = PreferenceManager.getInstance().get("IONTORRENT.FLOWDIST_CHARTTYPE");
        if (type == null) {
            type = "LINE";
        }
        if (type.equalsIgnoreCase("LINE")) {
            this.chart_type = 1;
        } else if (type.equalsIgnoreCase("AREA")) {
            this.chart_type = 2;
        } else if (type.equalsIgnoreCase("BAR")) {
            this.chart_type = 0;
        } else if (type.equalsIgnoreCase("STACKED")) {
            this.chart_type = 3;
        }
        this.binsize = PreferenceManager.getInstance().getAsInt("IONTORRENT.FLOWDIST_BINSIZE");
        if (this.binsize < 1) {
            this.binsize = 25;
        }
        if (this.binsize > 100) {
            this.binsize = 100;
        }
    }

    private void moveLeft() {
        if (this.getListener() != null) {
            this.getListener().locationChanged(this.location - 1);
        }
    }

    private void moveRight() {
        if (this.getListener() != null) {
            this.getListener().locationChanged(this.location + 1);
        }
    }

    private void recreateChart() {
        this.getPreferences();
        if (this.distributions == null || this.distributions.length < 1) {
            JOptionPane.showMessageDialog(this, "I got no flow signal distribution data");
            return;
        }
        if (this.chartpanel != null) {
            this.remove(this.chartpanel);
        }
        this.chartpanel = this.createChart();
        this.add("Center", this.chartpanel);
        this.invalidate();
        this.chartpanel.invalidate();
        this.chartpanel.repaint();
        this.repaint();
        this.paintAll(this.getGraphics());
    }

    private CategoryDataset createCategoryDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < this.distributions.length; ++i) {
            int[] data = this.distributions[i].getBinnedData(this.binsize);
            String seriename = this.distributions[i].getName();
            for (int j = 0; j < data.length; ++j) {
                String cat = "" + this.binsize * j;
                dataset.addValue((double)data[j], (Comparable)((Object)seriename), (Comparable)((Object)cat));
            }
        }
        return dataset;
    }

    private XYSeriesCollection createXYDataset() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (int i = 0; i < this.distributions.length; ++i) {
            TreeMap<Short, Integer> map = this.distributions[i].getMap();
            dataset.addSeries(this.createDataset(this.distributions[i]));
        }
        return dataset;
    }

    private JComponent createChart() {
        Color c;
        int which;
        int s;
        int series;
        CategoryDataset dataset;
        this.maxx = 0;
        this.location = this.distributions[0].getLocation();
        String information = this.distributions[0].getInformation();
        String plotTitle = "Flow Signal Distribution";
        String xaxis = "flow signal value";
        String yaxis = "count";
        NumberAxis xax = new NumberAxis(xaxis);
        NumberAxis yax = new NumberAxis(yaxis);
        this.freechart = null;
        if (this.chart_type == 0 || this.chart_type == 3) {
            StackedBarRenderer renderer;
            dataset = this.createCategoryDataset();
            this.freechart = ChartFactory.createBarChart((String)plotTitle, (String)xaxis, (String)yaxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            CategoryPlot plot = this.freechart.getCategoryPlot();
            plot.setForegroundAlpha(0.5f);
            if (this.chart_type == 3) {
                renderer = new StackedBarRenderer();
                plot.setRenderer((CategoryItemRenderer)renderer);
            } else {
                BarRenderer bar = (BarRenderer)plot.getRenderer();
                bar.setShadowVisible(false);
                bar.setItemMargin(0.0);
                bar.setDrawBarOutline(false);
                renderer = bar;
            }
            series = dataset.getRowCount();
            for (s = 0; s < series; ++s) {
                char base = this.distributions[s].getBase();
                which = BASES.indexOf(base);
                if (which < 0) {
                    which = 4;
                }
                c = this.colors[which];
                if (this.distributions[s].isReverse() && !this.distributions[s].isForward()) {
                    renderer.setSeriesOutlineStroke(s, (Stroke)this.dashedStroke);
                    renderer.setSeriesStroke(s, (Stroke)this.dashedStroke);
                    c = c.darker();
                } else if (!this.distributions[s].isReverse() && this.distributions[s].isForward()) {
                    c = c.brighter();
                }
                renderer.setSeriesOutlinePaint(s, (Paint)c);
                renderer.setSeriesItemLabelPaint(s, (Paint)c);
                renderer.setSeriesPaint(s, (Paint)c);
            }
        } else {
            dataset = null;
            XYLineAndShapeRenderer renderer = null;
            dataset = this.createXYDataset();
            XYPlot plot = null;
            if (this.chart_type == 1) {
                renderer = new XYLineAndShapeRenderer();
                plot = new XYPlot((XYDataset)dataset, (ValueAxis)xax, (ValueAxis)yax, (XYItemRenderer)renderer);
                this.freechart = new JFreeChart((Plot)plot);
                plot.setForegroundAlpha(0.75f);
            } else if (this.chart_type == 2) {
                renderer = new XYAreaRenderer(5);
                plot = new XYPlot((XYDataset)dataset, (ValueAxis)xax, (ValueAxis)yax, (XYItemRenderer)renderer);
                plot.setForegroundAlpha(0.5f);
                this.freechart = new JFreeChart((Plot)plot);
            }
            plot.setDomainGridlinesVisible(true);
            series = dataset.getSeriesCount();
            for (int x = 100; x < this.maxx; x += 100) {
                ValueMarker line = new ValueMarker((double)x);
                line.setPaint((Paint)Color.gray.darker());
                plot.addDomainMarker((Marker)line);
            }
            for (s = 0; s < series; ++s) {
                char base = this.distributions[s].getBase();
                which = BASES.indexOf(base);
                if (which < 0) {
                    which = 4;
                }
                c = this.colors[which];
                if (this.distributions[s].isReverse() && !this.distributions[s].isForward()) {
                    renderer.setSeriesOutlineStroke(s, (Stroke)this.dashedStroke);
                    renderer.setSeriesStroke(s, (Stroke)this.dashedStroke);
                    c = c.darker();
                } else if (!this.distributions[s].isReverse() && this.distributions[s].isForward()) {
                    c = c.brighter();
                }
                renderer.setSeriesFillPaint(s, (Paint)c);
                renderer.setSeriesOutlinePaint(s, (Paint)c);
                renderer.setSeriesItemLabelPaint(s, (Paint)c);
                renderer.setSeriesPaint(s, (Paint)c);
            }
        }
        xax.setMinorTickCount(1);
        xax.setTickUnit(new NumberTickUnit(50.0));
        xax.setTickMarksVisible(true);
        xax.setMinorTickMarksVisible(true);
        this.freechart.setTitle(plotTitle);
        String bininfo = "bin size=" + this.binsize;
        int totflows = 0;
        for (FlowDistribution dist : this.distributions) {
            totflows += dist.getNrFlows();
        }
        bininfo = bininfo + ", nr reads=" + totflows;
        if (information == null) {
            this.freechart.addSubtitle((Title)new TextTitle(bininfo));
        } else {
            this.freechart.addSubtitle((Title)new TextTitle(information + ", " + bininfo));
        }
        ChartPanel chartPanel = new ChartPanel(this.freechart);
        chartPanel.setPreferredSize(new Dimension(800, 600));
        return chartPanel;
    }

    public Shape getGlyphShape(String strGlyphs) {
        AffineTransform transform = new AffineTransform();
        transform.scale(1.0, 1.0);
        return this.getGlyphShapes(this.font, strGlyphs, transform)[0];
    }

    public Shape[] getGlyphShapes(Font font, String strGlyphs, AffineTransform transform) {
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector glyphs = font.createGlyphVector(frc, strGlyphs);
        int count = glyphs.getNumGlyphs();
        Shape[] shapes = new Shape[count];
        for (int i = 0; i < count; ++i) {
            GeneralPath path = (GeneralPath)glyphs.getGlyphOutline(i);
            shapes[i] = path.createTransformedShape(transform);
        }
        return shapes;
    }

    private XYSeries createDataset(FlowDistribution dist) {
        int[] bins = dist.getBinnedData(this.binsize);
        if (this.maxx < dist.getMaxX()) {
            this.maxx = dist.getMaxX();
        }
        XYSeries xy = new XYSeries((Comparable)((Object)dist.getName()));
        for (int b = 0; b < bins.length; ++b) {
            xy.add((double)(b * this.binsize), (double)bins[b]);
        }
        return xy;
    }

    private String getCsvString() {
        StringBuilder csv = new StringBuilder();
        for (int i = 0; i < this.distributions.length; ++i) {
            csv = csv.append(this.distributions[i].toCsv(this.binsize));
        }
        return csv.toString();
    }

    private String getJsonString() {
        StringBuilder json = new StringBuilder();
        for (int i = 0; i < this.distributions.length; ++i) {
            json = json.append("\n").append(this.distributions[i].toJson());
        }
        return json.toString();
    }

    private String getReadString() {
        StringBuilder rinfo = new StringBuilder();
        for (int i = 0; i < this.distributions.length; ++i) {
            rinfo = rinfo.append("\n").append(this.distributions[i].getReadInfoString());
        }
        return rinfo.toString();
    }

    private String getReadNames() {
        StringBuilder rinfo = new StringBuilder();
        for (int i = 0; i < this.distributions.length; ++i) {
            rinfo = rinfo.append("_").append(this.distributions[i].getReadNames());
        }
        return rinfo.toString();
    }

    private void p(String msg) {
        log.info((Object)msg);
    }

    private void err(String msg) {
        log.error((Object)msg);
    }

    private void initComponents() {
        this.buttonToolBar = new JToolBar();
        this.btnCopy = new JButton();
        this.btnCopyJson = new JButton();
        this.jButton1 = new JButton();
        this.btnSave = new JButton();
        this.btnConfigure = new JButton();
        this.btnTSL = new JButton();
        this.jLabel1 = new JLabel();
        this.spinBin = new JSpinner();
        this.btnLeft = new JButton();
        this.btnRight = new JButton();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FlowSignalDistributionPanel.this.formKeyTyped(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.buttonToolBar.setRollover(true);
        this.btnCopy.setIcon(new ImageIcon(this.getClass().getResource("/com/iontorrent/views/copy.png")));
        this.btnCopy.setToolTipText("Copy the data to the clipboard");
        this.btnCopy.setFocusable(false);
        this.btnCopy.setHorizontalTextPosition(0);
        this.btnCopy.setVerticalTextPosition(3);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlowSignalDistributionPanel.this.btnCopyActionPerformed(evt);
            }
        });
        this.buttonToolBar.add(this.btnCopy);
        this.btnCopyJson.setIcon(new ImageIcon(this.getClass().getResource("/com/iontorrent/views/copyj.png")));
        this.btnCopyJson.setToolTipText("copy to clip board in Json format");
        this.btnCopyJson.setFocusable(false);
        this.btnCopyJson.setHorizontalTextPosition(0);
        this.btnCopyJson.setVerticalTextPosition(3);
        this.btnCopyJson.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlowSignalDistributionPanel.this.btnCopyJsonActionPerformed(evt);
            }
        });
        this.buttonToolBar.add(this.btnCopyJson);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/iontorrent/views/copyr.png")));
        this.jButton1.setToolTipText("show read info");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlowSignalDistributionPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.buttonToolBar.add(this.jButton1);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/iontorrent/views/save.png")));
        this.btnSave.setToolTipText("Save data in .csv file (to be used in Excel for instance)");
        this.btnSave.setFocusable(false);
        this.btnSave.setHorizontalTextPosition(0);
        this.btnSave.setVerticalTextPosition(3);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlowSignalDistributionPanel.this.btnSaveActionPerformed(evt);
            }
        });
        this.buttonToolBar.add(this.btnSave);
        this.btnConfigure.setIcon(new ImageIcon(this.getClass().getResource("/com/iontorrent/views/configure.png")));
        this.btnConfigure.setToolTipText("Change settings such as the bin size, chart type and whether or not to use the first/last HP");
        this.btnConfigure.setFocusable(false);
        this.btnConfigure.setHorizontalTextPosition(0);
        this.btnConfigure.setVerticalTextPosition(3);
        this.btnConfigure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlowSignalDistributionPanel.this.btnConfigureActionPerformed(evt);
            }
        });
        this.buttonToolBar.add(this.btnConfigure);
        this.btnTSL.setIcon(new ImageIcon(this.getClass().getResource("/com/iontorrent/views/chip_16.png")));
        this.btnTSL.setToolTipText("Open Torrent Scout light in a browser and load the currently shown reads");
        this.btnTSL.setFocusable(false);
        this.btnTSL.setHorizontalTextPosition(0);
        this.btnTSL.setVerticalTextPosition(3);
        this.btnTSL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlowSignalDistributionPanel.this.btnTSLActionPerformed(evt);
            }
        });
        this.buttonToolBar.add(this.btnTSL);
        this.jLabel1.setText("Bin size:");
        this.buttonToolBar.add(this.jLabel1);
        this.spinBin.setModel(new SpinnerNumberModel(25, 1, 200, 5));
        this.spinBin.setMaximumSize(new Dimension(50, 19));
        this.spinBin.setMinimumSize(new Dimension(47, 18));
        this.spinBin.setPreferredSize(new Dimension(47, 18));
        this.spinBin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FlowSignalDistributionPanel.this.spinBinStateChanged(evt);
            }
        });
        this.buttonToolBar.add(this.spinBin);
        this.btnLeft.setIcon(new ImageIcon(this.getClass().getResource("/com/iontorrent/views/arrow-left.png")));
        this.btnLeft.setToolTipText("move to the next bas on the left");
        this.btnLeft.setFocusable(false);
        this.btnLeft.setHorizontalTextPosition(0);
        this.btnLeft.setVerticalTextPosition(3);
        this.btnLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlowSignalDistributionPanel.this.btnLeftActionPerformed(evt);
            }
        });
        this.buttonToolBar.add(this.btnLeft);
        this.btnRight.setIcon(new ImageIcon(this.getClass().getResource("/com/iontorrent/views/arrow-right.png")));
        this.btnRight.setToolTipText("move to the next base on the right");
        this.btnRight.setFocusable(false);
        this.btnRight.setHorizontalTextPosition(0);
        this.btnRight.setVerticalTextPosition(3);
        this.btnRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlowSignalDistributionPanel.this.btnRightActionPerformed(evt);
            }
        });
        this.buttonToolBar.add(this.btnRight);
        this.add((Component)this.buttonToolBar, "First");
    }

    private void btnConfigureActionPerformed(ActionEvent evt) {
        IGV.getInstance().doViewPreferences("IonTorrent");
        this.refresh();
    }

    public void refresh() {
        this.getListener().locationChanged(this.location);
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        Object[] options = new String[2];
        String msg = "1) Save image of chart\n";
        msg = msg + "2) Save data in .csv file\n";
        options[0] = "1) Image";
        options[1] = "2) Data";
        int ans = JOptionPane.showOptionDialog(this, msg, "Export", 2, 3, null, options, options[0]);
        if (ans < 0) {
            return;
        }
        if (ans == 0) {
            this.doSaveImageAction();
        } else if (ans == 1) {
            this.doSaveDataAction();
        }
    }

    private void doSaveImageAction() {
        this.filename = FileTools.getFile("File to store chart image", ".png", this.filename, true);
        if (this.filename == null || this.filename.length() < 1) {
            return;
        }
        try {
            ChartUtilities.saveChartAsJPEG((File)new File(this.filename), (JFreeChart)this.freechart, (int)800, (int)600);
        }
        catch (IOException ex) {
            Logger.getLogger(FlowSignalDistributionPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void doSaveDataAction() {
        this.filename = FileTools.getFile("File to store flow chart distribution", ".csv", this.filename, true);
        if (this.filename == null || this.filename.length() < 1) {
            return;
        }
        String csv = this.getCsvString();
        File fileToSave = new File(this.filename);
        FileTools.writeStringToFile(fileToSave, csv, false);
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        String csv = this.getCsvString();
        StringSelection stringSelection = new StringSelection(csv);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
        JTextArea area = new JTextArea(15, 30);
        area.setText(csv);
        JOptionPane.showMessageDialog(this, new JScrollPane(area), "Data to paste to Excel (it is already in the clipboard)", 1);
    }

    private void btnCopyJsonActionPerformed(ActionEvent evt) {
        String json = this.getJsonString();
        StringSelection stringSelection = new StringSelection(json);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
        JTextArea area = new JTextArea(15, 30);
        area.setText(json);
        JOptionPane.showMessageDialog(this, new JScrollPane(area), "Json string (it is already in the clipboard)", 1);
    }

    private void btnLeftActionPerformed(ActionEvent evt) {
        this.moveLeft();
    }

    private void btnRightActionPerformed(ActionEvent evt) {
        this.moveRight();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String readinfo = this.getReadString();
        StringSelection stringSelection = new StringSelection(readinfo);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
        JTextArea area = new JTextArea(15, 30);
        area.setText(readinfo);
        JOptionPane.showMessageDialog(this, new JScrollPane(area), "Read info string (it is already in the clipboard)", 1);
    }

    private void btnTSLActionPerformed(ActionEvent evt) {
        String readnames;
        String server = PreferenceManager.getInstance().get("IONTORRENT.SERVER");
        String res = PreferenceManager.getInstance().get("IONTORRENT.RESULTS");
        String bam = null;
        if (res.endsWith(".bam")) {
            bam = res;
            File f = new File(bam);
            res = f.getParent().toString();
        }
        if (server == null || server.length() < 1) {
            server = "ioneast.ite";
        }
        if (!server.startsWith("http")) {
            server = "http://" + server;
        }
        if (server.lastIndexOf(":") < 7) {
            server = server + ":8080";
        }
        String url = server + "/TSL?restartApplication";
        if (res != null && res.length() > 0) {
            url = url + "&res_dir=" + res;
        }
        if (bam != null && bam.length() > 0) {
            url = url + "&bam=" + bam;
        }
        if ((readnames = this.getReadNames()) != null && readnames.length() > 0) {
            url = url + "&read_names=" + readnames;
        }
        JTextField txt = new JTextField();
        txt.setText(url);
        if (!Desktop.isDesktopSupported()) {
            JOptionPane.showMessageDialog(this, txt, "Please open a browser and paste the url below:", 0);
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            URI uri = new URI(url);
            desktop.browse(uri);
            JOptionPane.showMessageDialog(this, "Raw data", "When TSL opens, pick the folder with the raw data to view raw traces\nand specify the .sff file to see ionograms", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, txt, "Please open a browser and paste the url below:", 0);
        }
    }

    private void spinBinStateChanged(ChangeEvent evt) {
        if (this.ignore_events) {
            return;
        }
        if (this.spinBin.getValue() != null) {
            this.changeBinSize((Integer)this.spinBin.getValue());
        }
    }

    private void changeBinSize(int newbinsize) {
        this.binsize = newbinsize;
        PreferenceManager pref = PreferenceManager.getInstance();
        pref.put("IONTORRENT.FLOWDIST_BINSIZE", "" + this.binsize);
        this.refresh();
        if ((Integer)this.spinBin.getValue() != newbinsize) {
            this.ignore_events = true;
            this.spinBin.setValue(newbinsize);
            this.ignore_events = false;
        }
    }

    private void formKeyTyped(KeyEvent evt) {
        this.handleKeyEvent(evt);
    }

    public void handleKeyEvent(KeyEvent e) {
        int c = e.getKeyCode();
        this.p("Got key: " + c + ", left/right etc: " + 37 + "/" + 39 + "/" + 38 + "/" + 40 + "/" + 127);
        if (c == 37 || c == 37) {
            this.moveLeft();
        } else if (c == 39 || c == 39) {
            this.moveRight();
        } else if (c == 38 || c == 33 || c == 38) {
            this.changeBinSize(this.binsize + 5);
        } else if (c == 40 || c == 34 || c == 40) {
            this.changeBinSize(this.binsize - 5);
        }
    }

    public void setDistributions(FlowDistribution[] newdist) {
        this.distributions = newdist;
        this.recreateChart();
    }

    public LocationListener getListener() {
        return this.listener;
    }

    public void setListener(LocationListener listener) {
        this.listener = listener;
    }
}

