/*
 * Decompiled with CFR 0.152.
 */
package com.iontorrent.utils;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringTools {
    public static ArrayList<Integer> parseInts(String pattern) {
        ArrayList<String> items = StringTools.parseList(pattern, ",");
        ArrayList<Integer> flows = new ArrayList<Integer>();
        for (String it : items) {
            if (it.indexOf("-") > 0) {
                ArrayList<Integer> nrs = StringTools.parseListtoInt(it, "-");
                if (nrs == null || nrs.size() != 2) continue;
                int a = nrs.get(0);
                int b = nrs.get(1);
                for (int f = a; f <= b; ++f) {
                    flows.add(f);
                }
                continue;
            }
            try {
                int f = Integer.parseInt(it);
                flows.add(f);
            }
            catch (Exception e) {
            }
        }
        return flows;
    }

    public static String addNL(String desc, String nl, int WIDTH) {
        if (desc == null || desc.length() < WIDTH) {
            return desc;
        }
        int oldnewlinepos = 0;
        int len = desc.length();
        StringBuffer newdesc = new StringBuffer(len + len / WIDTH + 1);
        int sp = desc.indexOf(" ");
        int oldsp = -1;
        int pos = 0;
        int newlinepos = 0;
        while (pos < desc.length()) {
            int linelen = sp - oldnewlinepos;
            if (linelen > WIDTH + 5) {
                newlinepos = oldsp;
                if (newlinepos < oldnewlinepos) {
                    newlinepos = sp;
                }
                if ((double)(linelen = newlinepos - oldnewlinepos) > 1.5 * (double)WIDTH) {
                    newlinepos = oldnewlinepos + WIDTH;
                }
                newdesc = newdesc.append(desc.substring(oldnewlinepos, newlinepos));
                newdesc = newdesc.append(nl);
                oldnewlinepos = newlinepos;
                pos = newlinepos + 1;
            } else {
                pos = sp + 1;
            }
            oldsp = sp;
            if (sp + 1 > desc.length()) break;
            sp = desc.indexOf(" ", pos);
            if (sp >= 0) continue;
            sp = desc.length() - 1;
        }
        pos = Math.max(oldnewlinepos, newlinepos);
        while (len - pos > WIDTH) {
            newdesc = newdesc.append(desc.substring(pos, pos + WIDTH));
            newdesc = newdesc.append(nl);
            pos += WIDTH;
        }
        newdesc = newdesc.append(desc.substring(pos, len));
        return newdesc.toString();
    }

    public static String replace(String source, String tag, String with) {
        if (source == null || tag == null || tag.length() == 0 || with == null || tag.equals(with)) {
            return source;
        }
        if (tag.indexOf(with) >= 0) {
            String s = source;
            int tagpos = -1;
            while ((tagpos = s.indexOf(tag)) >= 0) {
                StringBuffer result = new StringBuffer();
                result.append(s.subSequence(0, tagpos));
                result.append(with);
                result.append(s.subSequence(tagpos + tag.length(), s.length()));
                s = result.toString();
            }
            return s;
        }
        StringBuffer result = new StringBuffer();
        int pos = 0;
        while (pos < source.length()) {
            int tagpos = source.indexOf(tag, pos);
            if (tagpos != -1) {
                if (tagpos > pos) {
                    result.append(source.substring(pos, tagpos));
                }
                result.append(with);
                pos = tagpos + tag.length();
                continue;
            }
            result.append(source.substring(pos));
            break;
        }
        return result.toString();
    }

    public static String getEnumeration(String[] list) {
        String result = "";
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                String element = list[i];
                result = result + element;
                if (i + 1 >= list.length) continue;
                result = result + ", ";
            }
        }
        return result;
    }

    public static ArrayList<String> parseList(String list, String sep) {
        if (list == null) {
            return null;
        }
        if ((list = list.trim()).startsWith("[")) {
            list = list.substring(1);
        }
        if (list.endsWith("]")) {
            list = list.substring(0, list.length() - 1);
        }
        ArrayList<String> items = StringTools.splitString(list, sep);
        return items;
    }

    public static ArrayList<Double> parseListToDouble(String list, String sep) {
        if (list == null) {
            return null;
        }
        if ((list = list.trim()).startsWith("[")) {
            list = list.substring(1);
        }
        if (list.endsWith("]")) {
            list = list.substring(0, list.length() - 1);
        }
        ArrayList<Double> res = new ArrayList<Double>();
        ArrayList<String> items = StringTools.splitString(list, sep);
        for (String it : items) {
            double d = 0.0;
            try {
                d = Double.parseDouble(it);
            }
            catch (Exception e) {
                // empty catch block
            }
            res.add(d);
        }
        return res;
    }

    public static ArrayList<Long> parseListToLong(String list, String sep) {
        if (list == null) {
            return null;
        }
        if ((list = list.trim()).startsWith("[")) {
            list = list.substring(1);
        }
        if (list.endsWith("]")) {
            list = list.substring(0, list.length() - 1);
        }
        ArrayList<Long> res = new ArrayList<Long>();
        ArrayList<String> items = StringTools.splitString(list, sep);
        for (String it : items) {
            long d = 0L;
            try {
                d = Long.parseLong(it);
            }
            catch (Exception e) {}
        }
        return res;
    }

    public static ArrayList<Integer> parseListtoInt(String list, String sep) {
        return StringTools.parseListtoInt(list, sep, Integer.MAX_VALUE);
    }

    public static ArrayList<Integer> parseListtoInt(String list, String sep, int max) {
        if (list == null) {
            return null;
        }
        if ((list = list.trim()).startsWith("[")) {
            list = list.substring(1);
        }
        if (list.endsWith("]")) {
            list = list.substring(0, list.length() - 1);
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        ArrayList<String> items = StringTools.splitString(list, sep);
        for (String it : items) {
            int val = 0;
            try {
                val = Integer.parseInt(it);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (val > max) {
                StringTools.warn("Value too large:" + val + ", should be < " + max);
                val = max;
            }
            res.add(val);
        }
        return res;
    }

    public static double[] parseListTodouble(String list, String sep) {
        ArrayList<Double> res = StringTools.parseListToDouble(list, sep);
        if (res == null) {
            return null;
        }
        double[] dd = new double[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            dd[i] = res.get(i);
        }
        return dd;
    }

    public static ArrayList<String> splitString(String line, String delim) {
        if (line == null) {
            StringTools.err("splitString: line is null");
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, delim);
        while (tokenizer.hasMoreElements()) {
            String next = tokenizer.nextToken().trim();
            if (next.startsWith("\"")) {
                next = next.substring(1, next.length());
            }
            if (next.endsWith("\"")) {
                next = next.substring(0, next.length() - 1);
            }
            res.add(next);
        }
        return res;
    }

    public static ArrayList<Long> splitStringToLongs(String line, String delim) {
        if (line == null) {
            StringTools.err("splitString: line is null");
            return null;
        }
        ArrayList<Long> res = new ArrayList<Long>();
        StringTokenizer tokenizer = new StringTokenizer(line, delim);
        while (tokenizer.hasMoreElements()) {
            String next = tokenizer.nextToken().trim();
            if (next.startsWith("\"")) {
                next = next.substring(1, next.length());
            }
            if (next.endsWith("\"")) {
                next = next.substring(0, next.length() - 1);
            }
            long d = 0L;
            try {
                d = Long.parseLong(next);
            }
            catch (Exception e) {
                // empty catch block
            }
            res.add(d);
        }
        return res;
    }

    public static String toStringList(ArrayList v) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; v != null && i < v.size(); ++i) {
            String s = v.get(i).toString();
            sb = sb.append(s);
            if (i + 1 >= v.size()) continue;
            sb = sb.append(";");
        }
        return sb.toString();
    }

    public static String toStringList(String[] v) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; v != null && i < v.length; ++i) {
            String s = v[i];
            sb = sb.append(s);
            if (i + 1 >= v.length) continue;
            sb = sb.append(";");
        }
        return sb.toString();
    }

    public static String[] toString(ArrayList v) {
        if (v == null || v.size() < 1) {
            return null;
        }
        String[] ss = new String[v.size()];
        for (int i = 0; v != null && i < v.size(); ++i) {
            ss[i] = v.get(i).toString();
        }
        return ss;
    }

    public static ArrayList<String> toArrayList(String[] ss) {
        if (ss == null || ss.length < 1) {
            return null;
        }
        ArrayList<String> v = new ArrayList<String>(ss.length);
        for (int i = 0; ss != null && i < ss.length; ++i) {
            v.add(ss[i]);
        }
        return v;
    }

    public static String getEnglishEnumeration(ArrayList<String> list) {
        String result = "";
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String element = list.get(i);
                result = result + element;
                if (i + 2 < list.size()) {
                    result = result + ", ";
                }
                if (i + 2 != list.size()) continue;
                result = result + " and ";
            }
        }
        return result;
    }

    public static ArrayList<String> parseList(String list) {
        list = StringTools.replace(list, " ", ",");
        return StringTools.parseList(list, ",");
    }

    private void err(String msg, Exception ex) {
        Logger.getLogger(StringTools.class.getName()).log(Level.SEVERE, msg, ex);
    }

    private static void err(String msg) {
        Logger.getLogger(StringTools.class.getName()).log(Level.SEVERE, msg);
    }

    private static void warn(String msg) {
        Logger.getLogger(StringTools.class.getName()).log(Level.WARNING, msg);
    }

    private void p(String msg) {
    }
}

