/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.math.BigDecimal;

public class MathUtil {
    public static final double MAX_PROB_BELOW_ONE = 0.9999999999999999;

    public static double mean(double[] in, int start, int stop) {
        double total = 0.0;
        for (int i = start; i < stop; ++i) {
            total += in[i];
        }
        return total / (double)(stop - start);
    }

    public static double stddev(double[] in, int start, int length) {
        return MathUtil.stddev(in, start, length, MathUtil.mean(in, start, length));
    }

    public static double stddev(double[] in, int start, int stop, double mean) {
        double total = 0.0;
        for (int i = start; i < stop; ++i) {
            total += in[i] * in[i];
        }
        return Math.sqrt(total / (double)(stop - start) - mean * mean);
    }

    public static int compare(int v1, int v2) {
        return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
    }

    public static Double percentageOrNull(Long numerator, Long denominator) {
        if (numerator != null && denominator != null && denominator != 0L) {
            return numerator.doubleValue() / denominator.doubleValue();
        }
        return null;
    }

    public static double round(double num, int precision) {
        BigDecimal bd = new BigDecimal(num);
        bd = bd.setScale(precision, 4);
        return bd.doubleValue();
    }

    public static double max(double[] nums) {
        double max = nums[0];
        for (int i = 1; i < nums.length; ++i) {
            if (!(nums[i] > max)) continue;
            max = nums[i];
        }
        return max;
    }

    public static double min(double[] nums) {
        double min = nums[0];
        for (int i = 1; i < nums.length; ++i) {
            if (!(nums[i] < min)) continue;
            min = nums[i];
        }
        return min;
    }

    public static double[] promote(int[] is) {
        double[] ds = new double[is.length];
        for (int i = 0; i < is.length; ++i) {
            ds[i] = is[i];
        }
        return ds;
    }

    public static double[] logLikelihoodsToProbs(double[] likelihoods) {
        double maxLikelihood = MathUtil.max(likelihoods);
        double bump = 300.0 - maxLikelihood;
        double[] tmp = new double[likelihoods.length];
        double total = 0.0;
        for (int i = 0; i < likelihoods.length; ++i) {
            tmp[i] = Math.pow(10.0, likelihoods[i] + bump);
            total += tmp[i];
        }
        double maxP = 0.9999999999999999;
        double minP = (double)1.110223E-16f / (double)(tmp.length - 1);
        for (int i = 0; i < likelihoods.length; ++i) {
            int n = i;
            tmp[n] = tmp[n] / total;
            if (tmp[i] > 0.9999999999999999) {
                tmp[i] = 0.9999999999999999;
                continue;
            }
            if (!(tmp[i] < minP)) continue;
            tmp[i] = minP;
        }
        return tmp;
    }
}

