/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.CycleFilesIterator;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.QseqReadParser;
import net.sf.picard.illumina.parser.Range;
import net.sf.picard.illumina.parser.readers.TileMetricsOutReader;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.util.StringUtil;

public class IlluminaFileUtil {
    private final File intensityLaneDir;
    private final File basecallDir;
    private final int lane;
    private final QSeqIlluminaFileUtil qseq;
    private final PerTilePerCycleFileUtil bcl;
    private final PerTilePerCycleFileUtil cif;
    private final PerTilePerCycleFileUtil cnf;
    private final PerTileFileUtil pos;
    private final PerTileFileUtil locs;
    private final PerTileFileUtil clocs;
    private final PerTileFileUtil filter;
    private final PerTileFileUtil barcode;
    private final File tileMetricsOut;
    private final Map<SupportedIlluminaFormat, ParameterizedFileUtil> utils;
    public static String UNPARAMETERIZED_PER_TILE_PATTERN = "s_(\\d+)_(\\d{1,4})";
    public static String UNPARAMETERIZED_QSEQ_PATTERN = "s_(\\d+)_(\\d)_(\\d{4})_qseq\\.txt(\\.gz|\\.bz2)?";
    private static final Pattern CYCLE_SUBDIRECTORY_PATTERN = Pattern.compile("^C(\\d+)\\.1$");

    public IlluminaFileUtil(File basecallDir, int lane) {
        this.basecallDir = basecallDir;
        File intensityDir = basecallDir.getParentFile();
        File dataDir = intensityDir.getParentFile();
        File interopDir = new File(dataDir.getParentFile(), "InterOp");
        this.lane = lane;
        File basecallLaneDir = new File(basecallDir, IlluminaFileUtil.longLaneStr(lane));
        this.intensityLaneDir = new File(intensityDir, IlluminaFileUtil.longLaneStr(lane));
        this.utils = new HashMap<SupportedIlluminaFormat, ParameterizedFileUtil>();
        this.qseq = new QSeqIlluminaFileUtil();
        this.utils.put(SupportedIlluminaFormat.Qseq, this.qseq);
        this.bcl = new PerTilePerCycleFileUtil(this.inferBclExtension(basecallLaneDir), basecallLaneDir);
        this.utils.put(SupportedIlluminaFormat.Bcl, this.bcl);
        this.cif = new PerTilePerCycleFileUtil(".cif");
        this.utils.put(SupportedIlluminaFormat.Cif, this.cif);
        this.cnf = new PerTilePerCycleFileUtil(".cnf");
        this.utils.put(SupportedIlluminaFormat.Cnf, this.cnf);
        this.locs = new PerTileFileUtil(".locs", false);
        this.utils.put(SupportedIlluminaFormat.Locs, this.locs);
        this.clocs = new PerTileFileUtil(".clocs", false);
        this.utils.put(SupportedIlluminaFormat.Clocs, this.clocs);
        this.pos = new PerTileFileUtil("_pos.txt", false, intensityDir);
        this.utils.put(SupportedIlluminaFormat.Pos, this.pos);
        this.filter = new PerTileFileUtil(".filter", true, basecallLaneDir);
        this.utils.put(SupportedIlluminaFormat.Filter, this.filter);
        this.barcode = new PerTileFileUtil("_barcode.txt", true, basecallDir);
        this.utils.put(SupportedIlluminaFormat.Barcode, this.barcode);
        this.tileMetricsOut = new File(interopDir, "TileMetricsOut.bin");
    }

    public int getLane() {
        return this.lane;
    }

    public ParameterizedFileUtil getUtil(SupportedIlluminaFormat format) {
        return this.utils.get((Object)format);
    }

    public List<Integer> getExpectedTiles() {
        IoUtil.assertFileIsReadable(this.tileMetricsOut);
        TreeSet<Integer> expectedTiles = new TreeSet<Integer>();
        TileMetricsOutReader tileMetrics = new TileMetricsOutReader(this.tileMetricsOut);
        while (tileMetrics.hasNext()) {
            TileMetricsOutReader.IlluminaTileMetrics tileMetric = (TileMetricsOutReader.IlluminaTileMetrics)tileMetrics.next();
            if (tileMetric.getLaneNumber() != this.lane || expectedTiles.contains(tileMetric.getTileNumber())) continue;
            expectedTiles.add(tileMetric.getTileNumber());
        }
        return new ArrayList<Integer>(expectedTiles);
    }

    public List<Integer> getActualTiles(List<SupportedIlluminaFormat> formats) {
        if (formats == null) {
            throw new PicardException("Format list provided to getTiles was null!");
        }
        if (formats.size() == 0) {
            throw new PicardException("0 Formats were specified.  You need to specify at least SupportedIlluminaFormat to use getTiles");
        }
        List<Integer> tiles = this.utils.get((Object)formats.get(0)).getTiles();
        for (int i = 0; i < formats.size(); ++i) {
            List<Integer> fmTiles = this.utils.get((Object)formats.get(i)).getTiles();
            if (tiles.size() == fmTiles.size() && tiles.containsAll(fmTiles)) continue;
            throw new PicardException("Formats do not have the same number of tiles! " + this.summarizeTileCounts(formats));
        }
        return tiles;
    }

    public QSeqIlluminaFileUtil qseq() {
        return this.qseq;
    }

    public PerTilePerCycleFileUtil bcl() {
        return this.bcl;
    }

    public PerTilePerCycleFileUtil cif() {
        return this.cif;
    }

    public PerTilePerCycleFileUtil cnf() {
        return this.cnf;
    }

    public PerTileFileUtil locs() {
        return this.locs;
    }

    public PerTileFileUtil clocs() {
        return this.clocs;
    }

    public PerTileFileUtil pos() {
        return this.pos;
    }

    public PerTileFileUtil filter() {
        return this.filter;
    }

    public PerTileFileUtil barcode() {
        return this.barcode;
    }

    public File tileMetricsOut() {
        return this.tileMetricsOut;
    }

    public static String makeParameterizedLaneAndTileRegex(int lane) {
        if (lane < 0) {
            throw new PicardException("Lane (" + lane + ") cannot be negative");
        }
        return "s_" + lane + "_(\\d{1,4})";
    }

    public static String makeParameterizedQseqRegex(int lane) {
        if (lane < 0) {
            throw new PicardException("Lane (" + lane + ") cannot be negative");
        }
        return "s_" + lane + "_(\\d)_(\\d{4})_qseq\\.txt(\\.gz|\\.bz2)?";
    }

    public static String makeLTRegex(String fileNameEndPattern) {
        return "^" + UNPARAMETERIZED_PER_TILE_PATTERN + fileNameEndPattern + "$";
    }

    private static String makeLTRegex(String fileNameEndPattern, int lane) {
        return "^" + IlluminaFileUtil.makeParameterizedLaneAndTileRegex(lane) + fileNameEndPattern + "$";
    }

    private static int getCycleFromDir(File tempCycleDir) {
        char[] name = tempCycleDir.getName().toCharArray();
        if (name[0] != 'C') {
            throw new PicardException("Invalid cycle directory name " + tempCycleDir.getName());
        }
        String intStr = "";
        boolean periodFound = false;
        for (int i = 1; i < name.length && !periodFound; ++i) {
            if (name[i] == '.') {
                periodFound = true;
                continue;
            }
            if (name[i] == '1' || name[i] == '2' || name[i] == '3' || name[i] == '4' || name[i] == '5' || name[i] == '6' || name[i] == '7' || name[i] == '8' || name[i] == '9' || name[i] == '0') {
                intStr = intStr + name[i];
                continue;
            }
            throw new PicardException("Invalid cycle directory name " + tempCycleDir.getAbsolutePath());
        }
        return Integer.parseInt(intStr);
    }

    private static LaneTileEnd laneAndTileFromFirstTwoMatches(String fileName, Pattern pattern) {
        Matcher matcher = pattern.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        return new LaneTileEnd(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
    }

    private static String longLaneStr(int lane) {
        String lstr = String.valueOf(lane);
        int zerosToAdd = 3 - lstr.length();
        for (int i = 0; i < zerosToAdd; ++i) {
            lstr = "0" + lstr;
        }
        return "L" + lstr;
    }

    private static String longTileStr(int tile) {
        String tstr = String.valueOf(tile);
        int zerosToAdd = 4 - tstr.length();
        for (int i = 0; i < zerosToAdd; ++i) {
            tstr = "0" + tstr;
        }
        return tstr;
    }

    private static IlluminaFileMap getTiledFiles(File baseDirectory, Pattern pattern, ParameterizedFileUtil ift) {
        IlluminaFileMap fileMap = new IlluminaFileMap();
        if (baseDirectory.exists()) {
            File[] files;
            IoUtil.assertDirectoryIsReadable(baseDirectory);
            for (File file : files = IoUtil.getFilesMatchingRegexp(baseDirectory, pattern)) {
                if (file.length() <= 0L) continue;
                LaneTileEnd lt = ift.fileToLaneTileEnd(file.getName());
                fileMap.put(lt.tile, file);
            }
        }
        return fileMap;
    }

    private static String processTxtExtension(String fileNameEndPattern) {
        if (fileNameEndPattern.endsWith(".txt")) {
            return fileNameEndPattern + "(\\.gz|\\.bz2)?";
        }
        return fileNameEndPattern;
    }

    private String liToStr(List<Integer> intList) {
        if (intList.size() == 0) {
            return "";
        }
        String summary = String.valueOf(intList.get(0));
        for (int i = 1; i < intList.size(); ++i) {
            summary = summary + ", " + String.valueOf(intList.get(i));
        }
        return summary;
    }

    private String summarizeTileCounts(List<SupportedIlluminaFormat> formats) {
        ParameterizedFileUtil pfu = this.utils.get((Object)formats.get(0));
        List<Integer> tiles = pfu.getTiles();
        String summary = pfu.extension + "(" + this.liToStr(tiles) + ")";
        for (SupportedIlluminaFormat format : formats) {
            pfu = this.utils.get((Object)format);
            tiles = pfu.getTiles();
            summary = summary + ", " + pfu.extension + "(" + this.liToStr(tiles) + ")";
        }
        return summary;
    }

    private String inferBclExtension(File laneDir) {
        Pattern bclExtensionPattern = Pattern.compile(".*.bcl(\\.gz)?$");
        String bclGzipExtension = ".bcl.gz";
        String bclExtension = ".bcl";
        File[] cycleDirs = IoUtil.getFilesMatchingRegexp(laneDir, CYCLE_SUBDIRECTORY_PATTERN);
        ArrayList<File> allBclFiles = new ArrayList<File>();
        if (cycleDirs != null && cycleDirs.length > 0) {
            for (File cycleDir : cycleDirs) {
                allBclFiles.addAll(Arrays.asList(IoUtil.getFilesMatchingRegexp(cycleDir, bclExtensionPattern)));
            }
            if (allBclFiles.size() > 0) {
                if (((File)allBclFiles.get(0)).getPath().endsWith(".bcl.gz")) {
                    bclExtension = ".bcl.gz";
                }
                for (File bclFile : allBclFiles) {
                    if (bclFile.getPath().endsWith(bclExtension)) continue;
                    throw new PicardException("Not all BCL files in " + laneDir.getAbsolutePath() + " have the same extension!");
                }
            }
        }
        return bclExtension;
    }

    static class LaneTileEnd {
        public final Integer lane;
        public final Integer tile;
        public final Integer end;

        public LaneTileEnd(Integer lane, Integer tile, Integer end) {
            this.lane = lane;
            this.tile = tile;
            this.end = end;
        }

        public LaneTileEnd(Integer lane, Integer tile) {
            this(lane, tile, null);
        }
    }

    class QSeqIlluminaFileUtil
    extends ParameterizedFileUtil {
        private final List<Integer> tiles;
        private final List<IlluminaFileMap> readFileMaps;

        public QSeqIlluminaFileUtil() {
            super(UNPARAMETERIZED_QSEQ_PATTERN, IlluminaFileUtil.makeParameterizedQseqRegex(IlluminaFileUtil.this.lane), "_qseq.txt", IlluminaFileUtil.this.basecallDir);
            this.readFileMaps = this.getFiles();
            this.tiles = this.readFileMaps.size() > 0 ? Collections.unmodifiableList(new ArrayList(this.readFileMaps.get(0).keySet())) : new ArrayList<Integer>();
        }

        private String makeLaneAndEndSpecificRegex(int lane, int end) {
            return "^s_" + lane + "_" + end + "_\\d{4}_qseq\\.txt(\\.gz|\\.bz2)?$";
        }

        public int numberOfEnds() {
            return this.readFileMaps.size();
        }

        @Override
        public LaneTileEnd fileToLaneTileEnd(String fileName) {
            Matcher matcher = this.unparameterizedPattern.matcher(fileName);
            if (!matcher.matches()) {
                return null;
            }
            return new LaneTileEnd(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(2)));
        }

        private IlluminaFileMap getFiles(int end) {
            String regex = this.makeLaneAndEndSpecificRegex(IlluminaFileUtil.this.lane, end);
            return IlluminaFileUtil.getTiledFiles(IlluminaFileUtil.this.basecallDir, Pattern.compile(regex), this);
        }

        public List<IlluminaFileMap> getFiles() {
            ArrayList<IlluminaFileMap> readTileMap = new ArrayList<IlluminaFileMap>();
            boolean emptyMap = false;
            int i = 1;
            while (!emptyMap) {
                IlluminaFileMap fm = this.getFiles(i);
                if (fm.isEmpty()) {
                    emptyMap = true;
                } else {
                    readTileMap.add(fm);
                }
                ++i;
            }
            return readTileMap;
        }

        public List<IlluminaFileMap> getFiles(List<Integer> tiles) {
            ArrayList<IlluminaFileMap> filteredMaps = new ArrayList<IlluminaFileMap>();
            for (IlluminaFileMap fm : this.readFileMaps) {
                filteredMaps.add(fm.keep(tiles));
            }
            return filteredMaps;
        }

        @Override
        public List<Integer> getTiles() {
            return this.tiles;
        }

        @Override
        public List<String> verify(List<Integer> expectedTiles, int[] expectedCycles) {
            LinkedList<String> failures = new LinkedList<String>();
            if (!this.base.exists()) {
                failures.add("Base directory( " + this.base.getAbsolutePath() + ") does not exist!");
            } else {
                List<IlluminaFileMap> fileMapPerRead = this.getFiles(expectedTiles);
                int[] qseqReadLengths = new int[this.numberOfEnds()];
                int lastCycle = 0;
                for (int i = 0; i < qseqReadLengths.length; ++i) {
                    File currentReadForTile = (File)fileMapPerRead.get(i).get(expectedTiles.get(0));
                    qseqReadLengths[i] = QseqReadParser.getReadLength(currentReadForTile);
                    lastCycle += qseqReadLengths[i];
                }
                Range cycleRange = new Range(1, lastCycle);
                for (int expectedCycle : expectedCycles) {
                    if (expectedCycle >= cycleRange.start && expectedCycle <= cycleRange.end) continue;
                    failures.add("Expected cycle(" + expectedCycle + ") is not within the range provided by available qseqs.  " + "Min Available Cycle(" + cycleRange.start + ") Max Available Cycle(" + cycleRange.end + ") Length of Qseqs( " + StringUtil.join((String)", ", (Object[])new int[][]{qseqReadLengths}));
                }
                for (int i = 1; i < expectedTiles.size(); ++i) {
                    Integer tile = expectedTiles.get(i);
                    for (int j = 0; j < qseqReadLengths.length; ++j) {
                        File currentReadForTile = (File)fileMapPerRead.get(j).get(tile);
                        if (currentReadForTile != null && currentReadForTile.exists()) continue;
                        failures.add("Missing file s_" + IlluminaFileUtil.this.lane + "_" + (j + 1) + "_" + IlluminaFileUtil.longTileStr(tile) + "_qseq.txt");
                    }
                }
            }
            return failures;
        }

        @Override
        public boolean filesAvailable() {
            return !this.tiles.isEmpty();
        }
    }

    class PerTilePerCycleFileUtil
    extends ParameterizedFileUtil {
        private final CycleIlluminaFileMap cycleFileMap;
        private final List<Integer> tiles;
        private int[] detectedCycles;

        public PerTilePerCycleFileUtil(String fileNameEndPattern, File base) {
            super(IlluminaFileUtil.makeLTRegex(fileNameEndPattern), IlluminaFileUtil.makeLTRegex(fileNameEndPattern, IlluminaFileUtil.this.lane), fileNameEndPattern, base);
            this.cycleFileMap = this.getPerTilePerCycleFiles();
            this.tiles = this.cycleFileMap.size() > 0 ? Collections.unmodifiableList(new ArrayList(this.cycleFileMap.keySet())) : new ArrayList<Integer>();
        }

        public PerTilePerCycleFileUtil(String fileNameEndPattern) {
            this(fileNameEndPattern, illuminaFileUtil.intensityLaneDir);
        }

        @Override
        public LaneTileEnd fileToLaneTileEnd(String fileName) {
            return IlluminaFileUtil.laneAndTileFromFirstTwoMatches(fileName, this.unparameterizedPattern);
        }

        private List<Integer> getTilesInCycleDir(File cycleDir) {
            File[] files = IoUtil.getFilesMatchingRegexp(cycleDir, this.pattern);
            ArrayList<Integer> tiles = new ArrayList<Integer>();
            for (File file : files) {
                if (file.length() <= 0L) continue;
                tiles.add(this.fileToLaneTileEnd((String)file.getName()).tile);
            }
            return tiles;
        }

        private CycleIlluminaFileMap getPerTilePerCycleFiles() {
            CycleIlluminaFileMap cycledMap = new CycleIlluminaFileMap();
            File laneDir = this.base;
            File firstCycleDir = null;
            File[] tempCycleDirs = IoUtil.getFilesMatchingRegexp(laneDir, CYCLE_SUBDIRECTORY_PATTERN);
            if (tempCycleDirs == null || tempCycleDirs.length == 0) {
                return cycledMap;
            }
            int lowestCycle = Integer.MAX_VALUE;
            int lowestCycleDirIndex = 0;
            int[] cycles = new int[tempCycleDirs.length];
            for (int i = 0; i < tempCycleDirs.length; ++i) {
                cycles[i] = IlluminaFileUtil.getCycleFromDir(tempCycleDirs[i]);
                if (cycles[i] >= lowestCycle) continue;
                lowestCycle = cycles[i];
                lowestCycleDirIndex = i;
            }
            firstCycleDir = tempCycleDirs[lowestCycleDirIndex];
            Arrays.sort(cycles);
            this.detectedCycles = cycles;
            List<Integer> tiles = this.getTilesInCycleDir(firstCycleDir);
            for (int tile : tiles) {
                cycledMap.put(tile, new CycleFilesIterator(laneDir, IlluminaFileUtil.this.lane, tile, cycles, this.extension));
            }
            return cycledMap;
        }

        public CycleIlluminaFileMap getFiles() {
            return this.cycleFileMap;
        }

        public CycleIlluminaFileMap getFiles(List<Integer> tiles) {
            return this.cycleFileMap.keep(tiles, null);
        }

        public CycleIlluminaFileMap getFiles(int[] cycles) {
            int[] filteredCycles = this.removeNonExistentCycles(cycles);
            return this.cycleFileMap.keep(null, filteredCycles);
        }

        public CycleIlluminaFileMap getFiles(List<Integer> tiles, int[] cycles) {
            int[] filteredCycles = this.removeNonExistentCycles(cycles);
            return this.cycleFileMap.keep(tiles, filteredCycles);
        }

        private int[] removeNonExistentCycles(int[] cycles) {
            TreeSet<Integer> detectedCyclesSet = new TreeSet<Integer>();
            int[] arr$ = this.detectedCycles;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer cycle = arr$[i$];
                detectedCyclesSet.add(cycle);
            }
            TreeSet<Integer> inputCyclesSet = new TreeSet<Integer>();
            int[] arr$2 = cycles;
            int len$2 = arr$2.length;
            for (int i$ = 0; i$ < len$2; ++i$) {
                Integer inputCycle = arr$2[i$];
                inputCyclesSet.add(inputCycle);
            }
            inputCyclesSet.retainAll(detectedCyclesSet);
            int[] outputCycles = new int[inputCyclesSet.size()];
            int i = 0;
            for (Integer element : inputCyclesSet) {
                outputCycles[i++] = element;
            }
            return outputCycles;
        }

        public int[] getDetectedCycles() {
            return this.detectedCycles;
        }

        @Override
        public List<Integer> getTiles() {
            return this.tiles;
        }

        @Override
        public boolean filesAvailable() {
            return !this.cycleFileMap.isEmpty();
        }

        @Override
        public List<String> verify(List<Integer> expectedTiles, int[] expectedCycles) {
            LinkedList<String> failures = new LinkedList<String>();
            if (!this.base.exists()) {
                failures.add("Base directory(" + this.base.getAbsolutePath() + ") does not exist!");
            } else {
                CycleIlluminaFileMap cfm = this.getFiles(expectedTiles, expectedCycles);
                HashSet<Integer> detectedCycleSet = new HashSet<Integer>();
                int[] arr$ = this.detectedCycles;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Integer cycle = arr$[i$];
                    detectedCycleSet.add(cycle);
                }
                TreeSet<Integer> missingCycleSet = new TreeSet<Integer>();
                int[] arr$2 = expectedCycles;
                int len$2 = arr$2.length;
                for (int i$ = 0; i$ < len$2; ++i$) {
                    Integer cycle = arr$2[i$];
                    missingCycleSet.add(cycle);
                }
                missingCycleSet.removeAll(detectedCycleSet);
                for (Integer tile : expectedTiles) {
                    CycleFilesIterator cfIterator = (CycleFilesIterator)cfm.get(tile);
                    if (cfIterator == null) {
                        failures.add("File type " + this.extension + " is missing tile " + tile);
                        continue;
                    }
                    if (!cfIterator.hasNext()) {
                        failures.add("File type " + this.extension + " has 0 cycle files for tile " + tile);
                        continue;
                    }
                    Long cycleSize = null;
                    for (int expectedCycleIndex = 0; cfIterator.hasNext() && expectedCycleIndex < expectedCycles.length; ++expectedCycleIndex) {
                        int currentCycle = expectedCycles[expectedCycleIndex];
                        if (cfIterator.getNextCycle() == currentCycle) {
                            File cycleFile = cfIterator.next();
                            if (!missingCycleSet.contains(currentCycle)) {
                                if (!cycleFile.exists()) {
                                    failures.add("Missing file(" + cycleFile.getAbsolutePath() + ")");
                                    continue;
                                }
                                if (cycleFile.length() == 0L) {
                                    failures.add("0 Length tile file(" + cycleFile.getAbsolutePath() + ")");
                                    continue;
                                }
                                if (cycleSize == null) {
                                    cycleSize = cycleFile.length();
                                    continue;
                                }
                                if (this.extension.equals(".bcl.gz") || cycleSize.longValue() == cycleFile.length()) continue;
                                failures.add("File type " + this.extension + " has cycles files of different length.  Current cycle (" + currentCycle + ") " + "Length of first non-empty file (" + cycleSize + ") length of current cycle (" + cycleFile.length() + ")" + " File(" + cycleFile.getAbsolutePath() + ")");
                                continue;
                            }
                            cfIterator.reset();
                            throw new PicardException("Malformed CycleIlluminaFileMap! CycleIlluminaFileMap has cycle " + currentCycle + " even though the directory does not exist!  CycleFileIterator(" + CycleIlluminaFileMap.remainingCyclesToString(cfIterator) + ")");
                        }
                        if (missingCycleSet.contains(currentCycle)) continue;
                        cfIterator.reset();
                        throw new PicardException("Malformed CycleIlluminaFileMap! Tile " + tile + "CycleFileIterator(" + CycleIlluminaFileMap.remainingCyclesToString(cfIterator) + ")");
                    }
                }
                for (Integer cycle : missingCycleSet) {
                    failures.add("Missing cycle directory " + cycle + " in directory " + this.base.getAbsolutePath() + " for file type " + this.extension);
                }
            }
            return failures;
        }
    }

    class PerTileFileUtil
    extends ParameterizedFileUtil {
        protected final boolean txtBased;
        protected final boolean padTile;
        protected final IlluminaFileMap fileMap;
        protected final List<Integer> tiles;

        public PerTileFileUtil(String fileNameEndPattern, boolean padTile, File base) {
            super(IlluminaFileUtil.makeLTRegex(IlluminaFileUtil.processTxtExtension(fileNameEndPattern)), IlluminaFileUtil.makeLTRegex(IlluminaFileUtil.processTxtExtension(fileNameEndPattern), IlluminaFileUtil.this.lane), fileNameEndPattern, base);
            this.txtBased = fileNameEndPattern.endsWith(".txt");
            this.padTile = padTile;
            this.fileMap = IlluminaFileUtil.getTiledFiles(base, this.pattern, this);
            this.tiles = this.fileMap.size() > 0 ? Collections.unmodifiableList(new ArrayList(this.fileMap.keySet())) : new ArrayList<Integer>();
        }

        public PerTileFileUtil(String fileNameEndPattern, boolean padTile) {
            this(fileNameEndPattern, padTile, illuminaFileUtil.intensityLaneDir);
        }

        @Override
        public boolean filesAvailable() {
            return !this.fileMap.isEmpty();
        }

        @Override
        public LaneTileEnd fileToLaneTileEnd(String fileName) {
            return IlluminaFileUtil.laneAndTileFromFirstTwoMatches(fileName, this.unparameterizedPattern);
        }

        public IlluminaFileMap getFiles() {
            return this.fileMap;
        }

        public IlluminaFileMap getFiles(List<Integer> tiles) {
            return this.fileMap.keep(tiles);
        }

        @Override
        public List<Integer> getTiles() {
            return this.tiles;
        }

        @Override
        public List<String> verify(List<Integer> expectedTiles, int[] expectedCycles) {
            LinkedList<String> failures = new LinkedList<String>();
            if (!this.base.exists()) {
                failures.add("Base directory(" + this.base.getAbsolutePath() + ") does not exist!");
            } else {
                for (Integer tile : expectedTiles) {
                    if (!this.tiles.contains(tile)) {
                        failures.add("Missing tile " + tile + " for file type " + this.extension + ".");
                        continue;
                    }
                    if (((File)this.fileMap.get(tile)).length() != 0L) continue;
                    failures.add("Tile " + tile + " is empty for file type " + this.extension + ".");
                }
            }
            return failures;
        }
    }

    public abstract class ParameterizedFileUtil {
        public final String extension;
        public final Pattern pattern;
        public final Pattern unparameterizedPattern;
        protected final File base;

        public ParameterizedFileUtil(String unparameterizedPattern, String patternStr, String extension, File base) {
            this.pattern = Pattern.compile(this.escapePeriods(patternStr));
            this.unparameterizedPattern = Pattern.compile(this.escapePeriods(unparameterizedPattern));
            this.extension = extension;
            this.base = base;
        }

        private String escapePeriods(String preEscaped) {
            return preEscaped.replaceAll("\\.", "\\.");
        }

        public abstract boolean filesAvailable();

        public abstract LaneTileEnd fileToLaneTileEnd(String var1);

        public abstract List<Integer> getTiles();

        public abstract List<String> verify(List<Integer> var1, int[] var2);
    }

    public static enum SupportedIlluminaFormat {
        Qseq,
        Bcl,
        Cif,
        Cnf,
        Locs,
        Clocs,
        Pos,
        Filter,
        Barcode;

    }
}

