/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.picard.analysis.AlignmentSummaryMetrics;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.metrics.PerUnitMetricCollector;
import net.sf.picard.metrics.SAMRecordAndReference;
import net.sf.picard.metrics.SAMRecordAndReferenceMultiLevelCollector;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.Histogram;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.BAMRecord;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CoordMath;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class AlignmentSummaryMetricsCollector
extends SAMRecordAndReferenceMultiLevelCollector<AlignmentSummaryMetrics, Comparable<?>> {
    private final boolean doRefMetrics;
    private final byte[][] adapterKmers;
    private final List<String> adapterSequence;
    private final int maxInsertSize;
    private final boolean isBisulfiteSequenced;
    private final int MAPPING_QUALITY_THRESOLD = 20;
    private static final int BASE_QUALITY_THRESHOLD = 20;
    private static final int ADAPTER_MATCH_LENGTH = 16;
    private static final int MAX_ADAPTER_ERRORS = 1;

    public AlignmentSummaryMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, boolean doRefMetrics, List<String> adapterSequence, int maxInsertSize, boolean isBisulfiteSequenced) {
        this.doRefMetrics = doRefMetrics;
        this.adapterSequence = adapterSequence;
        this.adapterKmers = this.prepareAdapterSequences();
        this.maxInsertSize = maxInsertSize;
        this.isBisulfiteSequenced = isBisulfiteSequenced;
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected PerUnitMetricCollector<AlignmentSummaryMetrics, Comparable<?>, SAMRecordAndReference> makeChildCollector(String sample, String library, String readGroup) {
        return new GroupAlignmentSummaryMetricsPerUnitMetricCollector(sample, library, readGroup);
    }

    @Override
    public void acceptRecord(SAMRecord rec, ReferenceSequence ref) {
        if (!rec.isSecondaryOrSupplementary()) {
            super.acceptRecord(rec, ref);
        }
    }

    private byte[][] prepareAdapterSequences() {
        HashSet<String> kmers = new HashSet<String>();
        for (String seq : this.adapterSequence) {
            for (int i = 0; i <= seq.length() - 16; ++i) {
                String kmer = seq.substring(i, i + 16).toUpperCase();
                int ns = 0;
                for (char ch : kmer.toCharArray()) {
                    if (ch != 'N') continue;
                    ++ns;
                }
                if (ns > true) continue;
                kmers.add(kmer);
                kmers.add(SequenceUtil.reverseComplement((String)kmer));
            }
        }
        byte[][] adapterKmers = new byte[kmers.size()][];
        int i = 0;
        for (String kmer : kmers) {
            adapterKmers[i++] = StringUtil.stringToBytes((String)kmer);
        }
        return adapterKmers;
    }

    private boolean isAdapterSequence(byte[] read) {
        if (read.length < 16) {
            return false;
        }
        for (byte[] adapter : this.adapterKmers) {
            int errors = 0;
            for (int i = 0; i < adapter.length && (read[i] == adapter[i] || ++errors <= 1); ++i) {
            }
            if (errors > true) continue;
            return true;
        }
        return false;
    }

    private class GroupAlignmentSummaryMetricsPerUnitMetricCollector
    implements PerUnitMetricCollector<AlignmentSummaryMetrics, Comparable<?>, SAMRecordAndReference> {
        final IndividualAlignmentSummaryMetricsCollector unpairedCollector;
        final IndividualAlignmentSummaryMetricsCollector firstOfPairCollector;
        final IndividualAlignmentSummaryMetricsCollector secondOfPairCollector;
        final IndividualAlignmentSummaryMetricsCollector pairCollector;
        final String sample;
        final String library;
        final String readGroup;

        public GroupAlignmentSummaryMetricsPerUnitMetricCollector(String sample, String library, String readGroup) {
            this.sample = sample;
            this.library = library;
            this.readGroup = readGroup;
            this.unpairedCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.UNPAIRED, sample, library, readGroup);
            this.firstOfPairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.FIRST_OF_PAIR, sample, library, readGroup);
            this.secondOfPairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.SECOND_OF_PAIR, sample, library, readGroup);
            this.pairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.PAIR, sample, library, readGroup);
        }

        @Override
        public void acceptRecord(SAMRecordAndReference args) {
            SAMRecord rec = args.getSamRecord();
            ReferenceSequence ref = args.getReferenceSequence();
            if (rec.getReadPairedFlag()) {
                if (rec.getFirstOfPairFlag()) {
                    this.firstOfPairCollector.addRecord(rec, ref);
                } else {
                    this.secondOfPairCollector.addRecord(rec, ref);
                }
                this.pairCollector.addRecord(rec, ref);
            } else {
                this.unpairedCollector.addRecord(rec, ref);
            }
        }

        @Override
        public void finish() {
            this.unpairedCollector.onComplete();
            this.firstOfPairCollector.onComplete();
            this.secondOfPairCollector.onComplete();
            this.pairCollector.onComplete();
        }

        @Override
        public void addMetricsToFile(MetricsFile<AlignmentSummaryMetrics, Comparable<?>> file) {
            if (this.firstOfPairCollector.getMetrics().TOTAL_READS > 0L) {
                this.pairCollector.getMetrics().BAD_CYCLES = this.firstOfPairCollector.getMetrics().BAD_CYCLES + this.secondOfPairCollector.getMetrics().BAD_CYCLES;
                file.addMetric(this.firstOfPairCollector.getMetrics());
                file.addMetric(this.secondOfPairCollector.getMetrics());
                file.addMetric(this.pairCollector.getMetrics());
            }
            if (this.unpairedCollector.getMetrics().TOTAL_READS > 0L || this.firstOfPairCollector.getMetrics().TOTAL_READS == 0L) {
                file.addMetric(this.unpairedCollector.getMetrics());
            }
        }

        private class IndividualAlignmentSummaryMetricsCollector {
            private long numPositiveStrand = 0L;
            private final Histogram<Integer> readLengthHistogram = new Histogram();
            private AlignmentSummaryMetrics metrics;
            private long chimeras;
            private long chimerasDenominator;
            private long adapterReads;
            private long indels;
            private long nonBisulfiteAlignedBases = 0L;
            private long hqNonBisulfiteAlignedBases = 0L;
            private final Histogram<Long> mismatchHistogram = new Histogram();
            private final Histogram<Long> hqMismatchHistogram = new Histogram();
            private final Histogram<Integer> badCycleHistogram = new Histogram();

            public IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category pairingCategory, String sample, String library, String readGroup) {
                this.metrics = new AlignmentSummaryMetrics();
                this.metrics.CATEGORY = pairingCategory;
                this.metrics.SAMPLE = sample;
                this.metrics.LIBRARY = library;
                this.metrics.READ_GROUP = readGroup;
            }

            public void addRecord(SAMRecord record, ReferenceSequence ref) {
                if (record.isSecondaryOrSupplementary()) {
                    return;
                }
                this.collectReadData(record, ref);
                this.collectQualityData(record, ref);
            }

            public void onComplete() {
                if (this.metrics.TOTAL_READS > 0L) {
                    this.metrics.PCT_PF_READS = (double)this.metrics.PF_READS / (double)this.metrics.TOTAL_READS;
                    this.metrics.PCT_ADAPTER = (double)this.adapterReads / (double)this.metrics.PF_READS;
                    this.metrics.MEAN_READ_LENGTH = this.readLengthHistogram.getMean();
                    this.metrics.BAD_CYCLES = 0L;
                    for (Histogram.Bin cycleBin : this.badCycleHistogram.values()) {
                        double badCyclePercentage = cycleBin.getValue() / (double)this.metrics.TOTAL_READS;
                        if (!(badCyclePercentage >= 0.8)) continue;
                        ++this.metrics.BAD_CYCLES;
                    }
                    if (AlignmentSummaryMetricsCollector.this.doRefMetrics) {
                        if (this.metrics.PF_READS > 0L) {
                            this.metrics.PCT_PF_READS_ALIGNED = (double)this.metrics.PF_READS_ALIGNED / (double)this.metrics.PF_READS;
                        }
                        if (this.metrics.PF_READS_ALIGNED > 0L) {
                            this.metrics.PCT_READS_ALIGNED_IN_PAIRS = (double)this.metrics.READS_ALIGNED_IN_PAIRS / (double)this.metrics.PF_READS_ALIGNED;
                        }
                        if (this.metrics.PF_READS_ALIGNED > 0L) {
                            this.metrics.STRAND_BALANCE = (double)this.numPositiveStrand / (double)this.metrics.PF_READS_ALIGNED;
                        }
                        if (this.chimerasDenominator > 0L) {
                            this.metrics.PCT_CHIMERAS = (double)this.chimeras / (double)this.chimerasDenominator;
                        }
                        if (this.nonBisulfiteAlignedBases > 0L) {
                            this.metrics.PF_MISMATCH_RATE = this.mismatchHistogram.getSum() / (double)this.nonBisulfiteAlignedBases;
                        }
                        this.metrics.PF_HQ_MEDIAN_MISMATCHES = this.hqMismatchHistogram.getMedian();
                        if (this.hqNonBisulfiteAlignedBases > 0L) {
                            this.metrics.PF_HQ_ERROR_RATE = this.hqMismatchHistogram.getSum() / (double)this.hqNonBisulfiteAlignedBases;
                        }
                        if (this.metrics.PF_ALIGNED_BASES > 0L) {
                            this.metrics.PF_INDEL_RATE = (double)this.indels / (double)this.metrics.PF_ALIGNED_BASES;
                        }
                    }
                }
            }

            private void collectReadData(SAMRecord record, ReferenceSequence ref) {
                ++this.metrics.TOTAL_READS;
                this.readLengthHistogram.increment(record.getReadBases().length);
                if (!record.getReadFailsVendorQualityCheckFlag()) {
                    ++this.metrics.PF_READS;
                    if (this.isNoiseRead(record)) {
                        ++this.metrics.PF_NOISE_READS;
                    }
                    if (record.getReadUnmappedFlag()) {
                        byte[] readBases = record.getReadBases();
                        if (!(record instanceof BAMRecord)) {
                            StringUtil.toUpperCase((byte[])readBases);
                        }
                        if (AlignmentSummaryMetricsCollector.this.isAdapterSequence(readBases)) {
                            ++this.adapterReads;
                        }
                    } else if (AlignmentSummaryMetricsCollector.this.doRefMetrics) {
                        ++this.metrics.PF_READS_ALIGNED;
                        if (!record.getReadNegativeStrandFlag()) {
                            ++this.numPositiveStrand;
                        }
                        if (record.getReadPairedFlag() && !record.getMateUnmappedFlag()) {
                            ++this.metrics.READS_ALIGNED_IN_PAIRS;
                            Integer mateMq = record.getIntegerAttribute("MQ");
                            if (mateMq == null || mateMq >= 20 && record.getMappingQuality() >= 20) {
                                ++this.chimerasDenominator;
                                if (Math.abs(record.getInferredInsertSize()) > AlignmentSummaryMetricsCollector.this.maxInsertSize || !record.getReferenceIndex().equals(record.getMateReferenceIndex())) {
                                    ++this.chimeras;
                                }
                            }
                        }
                    }
                }
            }

            private void collectQualityData(SAMRecord record, ReferenceSequence reference) {
                block13: {
                    block12: {
                        if (!record.getReadUnmappedFlag() && !record.getReadFailsVendorQualityCheckFlag() && AlignmentSummaryMetricsCollector.this.doRefMetrics) break block12;
                        byte[] readBases = record.getReadBases();
                        for (int i = 0; i < readBases.length; ++i) {
                            if (!SequenceUtil.isNoCall((byte)readBases[i])) continue;
                            this.badCycleHistogram.increment(CoordMath.getCycle((boolean)record.getReadNegativeStrandFlag(), (int)readBases.length, (int)i));
                        }
                        break block13;
                    }
                    if (record.getReadFailsVendorQualityCheckFlag()) break block13;
                    boolean highQualityMapping = this.isHighQualityMapping(record);
                    if (highQualityMapping) {
                        ++this.metrics.PF_HQ_ALIGNED_READS;
                    }
                    byte[] readBases = record.getReadBases();
                    byte[] refBases = reference.getBases();
                    byte[] qualities = record.getBaseQualities();
                    int refLength = refBases.length;
                    long mismatchCount = 0L;
                    long hqMismatchCount = 0L;
                    for (AlignmentBlock alignmentBlock : record.getAlignmentBlocks()) {
                        int readIndex = alignmentBlock.getReadStart() - 1;
                        int refIndex = alignmentBlock.getReferenceStart() - 1;
                        int length = alignmentBlock.getLength();
                        for (int i = 0; i < length && refIndex + i < refLength; ++i) {
                            int readBaseIndex = readIndex + i;
                            boolean mismatch = !SequenceUtil.basesEqual((byte)readBases[readBaseIndex], (byte)refBases[refIndex + i]);
                            boolean bisulfiteBase = false;
                            if (mismatch && AlignmentSummaryMetricsCollector.this.isBisulfiteSequenced && (record.getReadNegativeStrandFlag() && (refBases[refIndex + i] == 71 || refBases[refIndex + i] == 103) && (readBases[readBaseIndex] == 65 || readBases[readBaseIndex] == 97) || !record.getReadNegativeStrandFlag() && (refBases[refIndex + i] == 67 || refBases[refIndex + i] == 99) && readBases[readBaseIndex] == 84 || readBases[readBaseIndex] == 116)) {
                                bisulfiteBase = true;
                                mismatch = false;
                            }
                            if (mismatch) {
                                ++mismatchCount;
                            }
                            ++this.metrics.PF_ALIGNED_BASES;
                            if (!bisulfiteBase) {
                                ++this.nonBisulfiteAlignedBases;
                            }
                            if (highQualityMapping) {
                                ++this.metrics.PF_HQ_ALIGNED_BASES;
                                if (!bisulfiteBase) {
                                    ++this.hqNonBisulfiteAlignedBases;
                                }
                                if (qualities[readBaseIndex] >= 20) {
                                    ++this.metrics.PF_HQ_ALIGNED_Q20_BASES;
                                }
                                if (mismatch) {
                                    ++hqMismatchCount;
                                }
                            }
                            if (!mismatch && !SequenceUtil.isNoCall((byte)readBases[readBaseIndex])) continue;
                            this.badCycleHistogram.increment(CoordMath.getCycle((boolean)record.getReadNegativeStrandFlag(), (int)readBases.length, (int)i));
                        }
                    }
                    this.mismatchHistogram.increment(mismatchCount);
                    this.hqMismatchHistogram.increment(hqMismatchCount);
                    for (CigarElement elem : record.getCigar().getCigarElements()) {
                        CigarOperator op = elem.getOperator();
                        if (op != CigarOperator.INSERTION && op != CigarOperator.DELETION) continue;
                        ++this.indels;
                    }
                }
            }

            private boolean isNoiseRead(SAMRecord record) {
                Object noiseAttribute = record.getAttribute("XN");
                return noiseAttribute != null && noiseAttribute.equals(1);
            }

            private boolean isHighQualityMapping(SAMRecord record) {
                return !record.getReadFailsVendorQualityCheckFlag() && record.getMappingQuality() >= 20;
            }

            public AlignmentSummaryMetrics getMetrics() {
                return this.metrics;
            }
        }
    }
}

