/*
 * Decompiled with CFR 0.152.
 */
package java_circos;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import java_circos.Chromosome;
import java_circos.Java_circos;
import java_circos.Range;
import java_circos.Style;
import java_circos.circosArc;
import java_circos.circosBridge;
import java_circos.circosCytogenetic;
import java_circos.circosLabel;
import java_circos.circosRing;
import java_circos.circosText;
import java_circos.circosWiggle;
import java_circos.circos_data;
import java_circos.cmp_mouseover;
import java_circos.connection_2_points;
import java_circos.mouseover_structure;
import javax.swing.JPanel;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;

public class canvas
extends JPanel {
    int radius;
    int corner_x;
    int corner_y;
    int center_x;
    int center_y;
    static int count = 0;
    int band_height = 20;
    double bend_degree = 2.0;
    ArrayList<mouseover_structure> mouse_over = new ArrayList();

    public canvas(int radius, int corner_x, int corner_y) {
        this.radius = radius;
        this.corner_x = corner_y;
        this.corner_y = corner_y;
    }

    public void save_high_vector_image(String filename, double ratio) throws IOException {
        OutputStream out = new FileOutputStream(filename);
        out = new BufferedOutputStream(out);
        EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
        g2d.setGraphicContext(new GraphicContext());
        g2d.setupDocument(out, (int)(ratio * (double)this.getHeight()), (int)(ratio * (double)this.getWidth()));
        this.draw_image((Graphics)g2d, ratio);
        g2d.finish();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(new Font("MyriadPro", 1, 12));
        this.draw_image(g, Java_circos.zoomRatio);
    }

    private void draw_image(Graphics graph, double ratio) {
        Graphics2D g2D = (Graphics2D)graph;
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.center_x = this.radius + this.corner_x;
        this.center_y = this.radius + this.corner_y;
        this.mouse_over.clear();
        this.drawChrScale(g2D, ratio);
        for (String filename : Java_circos.input_data.keySet()) {
            ArrayList<circos_data> cd_array = Java_circos.input_data.get((Object)filename).dat;
            String track_type = Java_circos.input_data.get((Object)filename).circos_type;
            if (cd_array == null || cd_array.isEmpty()) continue;
            if (cd_array.get(0).getClass().getName().equals("java_circos.circosCytogenetic")) {
                this.drawCytogentic(g2D, ratio, this.center_x, this.center_y, cd_array);
            }
            for (circos_data cd : cd_array) {
                if (cd.getClass().getName().equals("java_circos.circosWiggle")) {
                    this.drawWiggle(g2D, ratio, this.center_x, this.center_y, (circosWiggle)cd);
                    continue;
                }
                if (cd.getClass().getName().equals("java_circos.circosBridge")) {
                    this.drawBridge(g2D, ratio, this.center_x, this.center_y, (circosBridge)cd);
                    continue;
                }
                if (cd.getClass().getName().equals("java_circos.circosArc")) {
                    this.drawArc(g2D, ratio, this.center_x, this.center_y, (circosArc)cd);
                    continue;
                }
                if (cd.getClass().getName().equals("java_circos.circosText")) {
                    this.drawText(g2D, ratio, this.center_x, this.center_y, (circosText)cd);
                    continue;
                }
                if (cd.getClass().getName().equals("java_circos.circosRing")) {
                    this.drawRing(g2D, ratio, this.center_x, this.center_y, (circosRing)cd);
                    continue;
                }
                if (cd.getClass().getName().equals("java_circos.connection_2_points")) {
                    this.drawConnection_2_points(g2D, ratio, this.center_x, this.center_y, (connection_2_points)cd);
                    continue;
                }
                if (!cd.getClass().getName().equals("java_circos.circosLabel")) continue;
                this.drawLabel(g2D, ratio, this.center_x, this.center_y, (circosLabel)cd);
            }
            if (!track_type.equals("Circos_wiggle") && !track_type.equals("Circos_bridge") && !track_type.equals("UCSC_bigWig/bedgraph")) continue;
            int Radius = cd_array.get((int)0).Radius;
            this.drawRing(g2D, ratio, this.center_x, this.center_y, new circosRing(Radius, new Color(0, 0, 0), 1));
        }
        Collections.sort(this.mouse_over, new cmp_mouseover());
    }

    private void drawCytogentic(Graphics2D g, double ratio, int x_org, int y_org, ArrayList<circos_data> cyto) {
        TreeMap<String, Color> band_G_color = new TreeMap<String, Color>();
        band_G_color.put("acen", new Color(128, 0, 0));
        band_G_color.put("gneg", Color.white);
        band_G_color.put("gpos100", Color.black);
        band_G_color.put("gpos25", new Color(220, 220, 220));
        band_G_color.put("gpos50", new Color(169, 169, 169));
        band_G_color.put("gpos75", new Color(105, 105, 105));
        band_G_color.put("gvar", Color.white);
        band_G_color.put("stalk", new Color(220, 20, 60));
        double accumulate_theta = 0.0;
        circosCytogenetic cy = (circosCytogenetic)cyto.get(0);
        String pre_chr = cy.chr;
        double accum_nt = 0.0;
        double len = (long)cy.stop / Java_circos.whole_genome_nt;
        double theta1 = 0.0;
        double theta2 = len * 360.0 + accumulate_theta;
        accum_nt += (double)(cy.stop - cy.start);
        this.drawWiggle(g, ratio, x_org, y_org, cy.Radius, (float)theta1, (float)theta2, this.band_height, Color.black, (Color)band_G_color.get(cy.gieStain), true);
        for (int i = 1; i < cyto.size(); ++i) {
            cy = (circosCytogenetic)cyto.get(i);
            theta1 = theta2;
            if (!cy.chr.equals(pre_chr)) {
                pre_chr = cy.chr;
                accumulate_theta = theta2;
            }
            theta2 = 360.0 * (double)cy.stop / (double)Java_circos.whole_genome_nt + accumulate_theta;
            this.drawWiggle(g, ratio, x_org, y_org, cy.Radius, (float)(360.0 - theta1), (float)(360.0 - theta2), this.band_height, Color.black, (Color)band_G_color.get(cy.gieStain), true);
        }
    }

    private void drawLabel(Graphics2D g, double ratio, int x_org, int y_org, circosLabel label) {
        Color tmp = g.getColor();
        g.setColor(label.color);
        Stroke tmp_stroke = g.getStroke();
        g.setStroke(new BasicStroke((int)ratio));
        int x_org_original = x_org;
        int y_org_original = y_org;
        x_org = (int)((double)x_org * ratio);
        y_org = (int)((double)y_org * ratio);
        double r = label.Radius;
        double x1 = (double)x_org + (r *= ratio) * Math.cos((double)label.src_angle * Math.PI / 180.0);
        double y1 = (double)y_org - r * Math.sin((double)label.src_angle * Math.PI / 180.0);
        r = label.Radius + (int)((double)(label.des_Radius - label.Radius) / 8.0);
        double x2 = (double)x_org + (r *= ratio) * Math.cos((double)label.src_angle * Math.PI / 180.0);
        double y2 = (double)y_org - r * Math.sin((double)label.src_angle * Math.PI / 180.0);
        r = label.Radius + (label.des_Radius - label.Radius) * 7 / 8;
        double x3 = (double)x_org + (r *= ratio) * Math.cos((double)label.des_angle * Math.PI / 180.0);
        double y3 = (double)y_org - r * Math.sin((double)label.des_angle * Math.PI / 180.0);
        r = label.des_Radius;
        double x4 = (double)x_org + (r *= ratio) * Math.cos((double)label.des_angle * Math.PI / 180.0);
        double y4 = (double)y_org - r * Math.sin((double)label.des_angle * Math.PI / 180.0);
        g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        g.drawLine((int)x2, (int)y2, (int)x3, (int)y3);
        g.drawLine((int)x3, (int)y3, (int)x4, (int)y4);
        this.circos_drawString_radio_new_new(g, ratio, label.str, label.des_Radius, x_org_original, y_org_original, label.des_angle, label.des_Radius > label.Radius);
        g.setStroke(tmp_stroke);
        g.setColor(tmp);
    }

    private void drawConnection_2_points(Graphics2D g, double ratio, int x_org, int y_org, connection_2_points connect_2_p) {
        Color tmp = g.getColor();
        g.setColor(connect_2_p.color);
        Stroke tmp_stroke = g.getStroke();
        g.setStroke(new BasicStroke((int)ratio));
        x_org = (int)((double)x_org * ratio);
        y_org = (int)((double)y_org * ratio);
        double r = connect_2_p.Radius;
        double x1 = (double)x_org + (r *= ratio) * Math.cos((double)connect_2_p.src_angle * Math.PI / 180.0);
        double y1 = (double)y_org - r * Math.sin((double)connect_2_p.src_angle * Math.PI / 180.0);
        r = connect_2_p.Radius + (int)((double)(connect_2_p.des_Radius - connect_2_p.Radius) / 3.0);
        double x2 = (double)x_org + (r *= ratio) * Math.cos((double)connect_2_p.src_angle * Math.PI / 180.0);
        double y2 = (double)y_org - r * Math.sin((double)connect_2_p.src_angle * Math.PI / 180.0);
        r = connect_2_p.Radius + (connect_2_p.des_Radius - connect_2_p.Radius) * 2 / 3;
        double x3 = (double)x_org + (r *= ratio) * Math.cos((double)connect_2_p.des_angle * Math.PI / 180.0);
        double y3 = (double)y_org - r * Math.sin((double)connect_2_p.des_angle * Math.PI / 180.0);
        r = connect_2_p.des_Radius;
        double x4 = (double)x_org + (r *= ratio) * Math.cos((double)connect_2_p.des_angle * Math.PI / 180.0);
        double y4 = (double)y_org - r * Math.sin((double)connect_2_p.des_angle * Math.PI / 180.0);
        g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        g.drawLine((int)x2, (int)y2, (int)x3, (int)y3);
        g.drawLine((int)x3, (int)y3, (int)x4, (int)y4);
        g.setStroke(tmp_stroke);
        g.setColor(tmp);
    }

    private void drawRing(Graphics2D g, double ratio, int x_org, int y_org, circosRing ring) {
        Color tmp = g.getColor();
        g.setColor(ring.color);
        Stroke tmp_stroke = g.getStroke();
        g.setStroke(new BasicStroke((int)((double)ring.height * ratio)));
        int middle_radius = (int)(ratio * (double)(ring.Radius + ring.height / 2));
        x_org = (int)((double)x_org * ratio);
        y_org = (int)((double)y_org * ratio);
        g.drawOval(x_org - middle_radius, y_org - middle_radius, 2 * middle_radius, 2 * middle_radius);
        g.setStroke(tmp_stroke);
        g.setColor(tmp);
    }

    private void drawRing_slow(Graphics2D g, int x_org, int y_org, circosRing ring) {
        Color tmp = g.getColor();
        g.setColor(ring.color);
        Polygon s = new Polygon();
        int small_radius = ring.Radius;
        int x = (int)((double)x_org + (double)small_radius * Math.cos(0.0));
        int y = (int)((double)y_org - (double)small_radius * Math.sin(0.0));
        for (double i = 0.0; i <= 360.0; i += 0.001) {
            int x2 = (int)((double)x_org + (double)small_radius * Math.cos(i / 180.0 * Math.PI));
            int y2 = (int)((double)y_org - (double)small_radius * Math.sin(i / 180.0 * Math.PI));
            s.addPoint(x, y);
            x = x2;
            y = y2;
        }
        int radius1 = ring.Radius + ring.height;
        for (double i = 360.0; i >= 0.0; i -= 0.001) {
            double t = i / 360.0;
            int x2 = (int)((double)x_org + (double)radius1 * Math.cos(2.0 * t * Math.PI));
            int y2 = (int)((double)y_org - (double)radius1 * Math.sin(2.0 * t * Math.PI));
            s.addPoint(x, y);
            x = x2;
            y = y2;
        }
        s.addPoint(x, y);
        g.fillPolygon(s);
        g.drawPolygon(s);
        g.setColor(tmp);
    }

    private void drawText(Graphics2D g, double ratio, int x_org, int y_org, circosText text) {
        Color tmp = g.getColor();
        g.setColor(text.color);
        if (text.style == Style.EMMISION) {
            this.circos_drawString_radio_new_new(g, ratio, text.str, text.Radius, x_org, y_org, text.startAngle, true);
        } else if (text.style == Style.CURVE) {
            this.circos_drawString_flat(g, ratio, text.str, text.Radius, x_org, y_org, text.startAngle);
        }
        g.setColor(tmp);
    }

    private void drawArc(Graphics2D g, double ratio, int x_org, int y_org, circosArc arc) {
        Color tmp = g.getColor();
        Stroke tmp_stroke = g.getStroke();
        g.setStroke(new BasicStroke((int)((double)arc.height * ratio)));
        g.setColor(arc.color);
        x_org = (int)((double)x_org * ratio);
        y_org = (int)((double)y_org * ratio);
        double R = (double)arc.Radius * ratio;
        g.draw(new Arc2D.Double((double)x_org - R, (double)y_org - R, 2.0 * R, 2.0 * R, arc.range.startAngle, -arc.range.arcAngle, 0));
        g.setStroke(tmp_stroke);
        g.setColor(tmp);
    }

    private void drawWiggle(Graphics2D g, double ratio, int x_org, int y_org, circosWiggle wiggle) {
        float theta1 = wiggle.range.startAngle - wiggle.range.arcAngle;
        float theta2 = wiggle.range.startAngle;
        this.drawWiggle(g, ratio, x_org, y_org, (int)((double)wiggle.Radius + wiggle.height1), theta1, theta2, (int)(wiggle.height2 - wiggle.height1), wiggle.boundaryColor, wiggle.color, wiggle.filled);
        int height1 = (int)(wiggle.height1 * ratio);
        int height2 = (int)(wiggle.height2 * ratio);
        if (Math.abs(height1 - height2) > 5) {
            this.mouse_over.add(new mouseover_structure(wiggle.range.startAngle - wiggle.range.arcAngle, wiggle.range.arcAngle, (int)((double)wiggle.Radius * ratio) + height1, (int)((double)wiggle.Radius * ratio) + height2, wiggle.description));
        } else {
            int middle_height = (int)(ratio * (double)wiggle.Radius) + (height1 + height2) / 2;
            this.mouse_over.add(new mouseover_structure(wiggle.range.startAngle - wiggle.range.arcAngle, wiggle.range.arcAngle, middle_height - 2, middle_height + 3, wiggle.description));
        }
    }

    private void drawWiggle(Graphics2D g, double ratio, int x_org, int y_org, int radius, float theta1, float theta2, int wigHeight, Color boundary_color, Color fill_color, boolean filled) {
        x_org = (int)((double)x_org * ratio);
        y_org = (int)((double)y_org * ratio);
        float[] x = new float[4];
        float[] y = new float[4];
        x[0] = (float)x_org + (float)(radius + wigHeight) * (float)Math.cos(Math.toRadians(theta2)) * (float)ratio;
        y[0] = (float)y_org - (float)(radius + wigHeight) * (float)Math.sin(Math.toRadians(theta2)) * (float)ratio;
        x[1] = (float)x_org + (float)(radius + wigHeight) * (float)Math.cos(Math.toRadians(theta1)) * (float)ratio;
        y[1] = (float)y_org - (float)(radius + wigHeight) * (float)Math.sin(Math.toRadians(theta1)) * (float)ratio;
        x[2] = (float)x_org + (float)radius * (float)Math.cos(Math.toRadians(theta1)) * (float)ratio;
        y[2] = (float)y_org - (float)radius * (float)Math.sin(Math.toRadians(theta1)) * (float)ratio;
        x[3] = (float)x_org + (float)radius * (float)Math.cos(Math.toRadians(theta2)) * (float)ratio;
        y[3] = (float)y_org - (float)radius * (float)Math.sin(Math.toRadians(theta2)) * (float)ratio;
        boolean theta180 = theta2 - theta1 > 180.0f;
        ExtendedGeneralPath path = new ExtendedGeneralPath(0, 3);
        path.moveTo(x[0], y[0]);
        float out_radius = (float)((double)(radius + wigHeight) * ratio);
        path.arcTo(out_radius, out_radius, theta2 - theta1, theta180, true, x[1], y[1]);
        path.lineTo(x[2], y[2]);
        float in_radius = (float)((double)radius * ratio);
        path.arcTo(in_radius, in_radius, theta2 - theta1, theta180, false, x[3], y[3]);
        path.closePath();
        Color tmp = g.getColor();
        if (filled) {
            g.setColor(fill_color);
            g.fill((Shape)path);
        }
        g.setColor(boundary_color);
        g.draw((Shape)path);
        g.setColor(tmp);
    }

    private void drawBridge(Graphics2D g, double ratio, int x_org, int y_org, circosBridge bridge) {
        x_org = (int)((double)x_org * ratio);
        y_org = (int)((double)y_org * ratio);
        int radius = (int)((double)bridge.Radius * ratio);
        double startAngle1 = bridge.range1.startAngle - bridge.range1.arcAngle;
        double startAngle2 = startAngle1 + (double)bridge.range1.arcAngle;
        double arcAngle2 = (double)(bridge.range2.startAngle - bridge.range2.arcAngle) - startAngle2;
        double arcAngle1 = arcAngle2 + (double)bridge.range1.arcAngle + (double)bridge.range2.arcAngle;
        String geneName = bridge.description;
        Color color = bridge.color;
        int len1 = (int)bridge.range1.arcAngle;
        if (len1 < 5) {
            len1 = 5;
        }
        this.mouse_over.add(new mouseover_structure((int)startAngle1, len1, (int)(ratio * (double)bridge.Radius) - 5, (int)(ratio * (double)bridge.Radius) + 3, bridge.description));
        int len2 = (int)bridge.range2.arcAngle;
        if (len2 < 5) {
            len2 = 5;
        }
        this.mouse_over.add(new mouseover_structure((int)(startAngle2 + arcAngle2), len2, (int)(ratio * (double)bridge.Radius) - 5, (int)(ratio * (double)bridge.Radius) + 3, bridge.description));
        if (bridge.range1.arcAngle < 5.0f && bridge.range2.arcAngle < 5.0f) {
            g.setColor(color);
            Stroke tmp = g.getStroke();
            g.setStroke(new BasicStroke(2.0f));
            this.drawCircosCurve(g, x_org, y_org, radius, startAngle1, arcAngle1);
            g.setStroke(tmp);
        } else {
            this.drawBridge(g, ratio, x_org, y_org, radius, startAngle1, arcAngle1, startAngle2, arcAngle2, geneName, color);
        }
    }

    private void draw_cycle(Graphics g, int radius) {
        g.drawOval(this.center_x - radius, this.center_y - radius, 2 * radius, 2 * radius);
    }

    @Override
    public boolean contains(int x, int y) {
        int org_x = (int)((double)this.center_x * Java_circos.zoomRatio);
        int org_y = (int)((double)this.center_y * Java_circos.zoomRatio);
        double r = Math.sqrt((org_y - y) * (org_y - y) + (x - org_x) * (x - org_x));
        double angle = Math.atan((double)(org_y - y) / (double)(x - org_x)) * 180.0 / Math.PI;
        if (x - org_x <= 0 || org_y - y >= 0) {
            // empty if block
        }
        if (x - org_x <= 0 && org_y - y > 0) {
            angle += 180.0;
        }
        if (x - org_x < 0 && org_y - y <= 0) {
            angle += 180.0;
        }
        if (x - org_x >= 0 && org_y - y < 0) {
            angle += 360.0;
        }
        for (int insertPos = (pos = Collections.binarySearch(this.mouse_over, new mouseover_structure((int)angle, (int)angle, 0, 0, ""), new cmp_mouseover())) < 0 ? -pos - 2 : pos; insertPos >= 0 && insertPos < this.mouse_over.size(); --insertPos) {
            if (!(angle <= (double)(this.mouse_over.get((int)insertPos).startAngle + this.mouse_over.get((int)insertPos).arcAngle))) continue;
            double r1 = this.mouse_over.get((int)insertPos).radius1;
            double r2 = this.mouse_over.get((int)insertPos).radius2;
            if (!(r >= r1) || !(r <= r2)) continue;
            this.setToolTipText(this.mouse_over.get((int)insertPos).text);
            break;
        }
        return super.contains(x, y);
    }

    private void drawGeneFusion(Graphics2D g, double ratio, String chr1, int loci_start1, String chr2, int loci_start2, int len, String geneName, Color color) {
        Range r1 = this.convert_range(chr1, loci_start1, len);
        Range r2 = this.convert_range(chr2, loci_start2, len);
        Range[] ranges = new Range[2];
        if (r1.start < r2.start) {
            ranges[0] = r1;
            ranges[1] = r2;
        } else {
            ranges[0] = r2;
            ranges[1] = r1;
        }
        this.drawBridge(g, ratio, this.center_x, this.center_y, this.radius, ranges, geneName, color);
    }

    private Range convert_range(String chr, int start, int len) {
        Range result = new Range();
        long num_nt = 0L;
        for (Chromosome chrom : Java_circos.chromosomeSize) {
            String chr1 = chrom.name;
            if (chr1.equals(chr)) break;
            num_nt += (long)chrom.length;
        }
        result.start = (double)(num_nt + (long)start) / (double)Java_circos.whole_genome_nt;
        result.len = (double)len / (double)Java_circos.whole_genome_nt;
        return result;
    }

    private void drawChrScale(Graphics2D g, double ratio) {
        float theta1 = 360.0f;
        float theta2 = 0.0f;
        double accum_nt = 0.0;
        for (Chromosome chrom : Java_circos.chromosomeSize) {
            String chr = chrom.name;
            theta2 = (float)(360.0 - (accum_nt += (double)chrom.length) / (double)Java_circos.whole_genome_nt * 360.0);
            this.drawWiggle(g, ratio, this.center_x, this.center_y, this.radius, theta2, theta1, this.band_height, Color.BLACK, Color.lightGray, true);
            boolean outer = true;
            this.circos_drawString_radio_new_new(g, ratio, chr.replace("chr", ""), (double)this.radius + 3.0 * (double)this.band_height / 2.0, this.center_x, this.center_y, (double)(theta1 + theta2) / 2.0, outer);
            theta1 = theta2;
        }
    }

    void circos_drawString_radio_new_new(Graphics2D g, double ratio, String str, double Radius, int center_x, int center_y, double angle, boolean outer) {
        if (angle > 90.0 && angle < 270.0) {
            str = new StringBuilder(str).reverse().toString();
        }
        if (!outer) {
            Radius = Radius - (double)g.getFontMetrics().stringWidth(str) + (double)g.getFontMetrics().stringWidth(str.substring(0, 1));
        }
        for (int i = 0; i < str.length(); ++i) {
            String letter = str.substring(i, i + 1);
            int str_len = g.getFontMetrics().stringWidth(str.substring(0, i));
            this.circos_drawString_radio_new(g, ratio, letter, Radius + (double)str_len, center_x, center_y, angle, outer);
        }
    }

    void circos_drawString_radio_new(Graphics2D g, double ratio, String str, double Radius, int center_x, int center_y, double angle, boolean outer) {
        double angle_PI = angle / 180.0 * Math.PI;
        Font oldFont = g.getFont();
        Font font = g.getFont();
        Font biggerFont = font.deriveFont((float)((double)(g.getFont().getSize() * 1) * ratio));
        int str_len = g.getFontMetrics().stringWidth(str);
        if (!outer) {
            Radius -= (double)str_len;
        }
        int font_height = g.getFontMetrics().getAscent();
        double offset_x = (double)center_x + Radius * Math.cos(angle_PI);
        double offset_y = (double)center_y - Radius * Math.sin(angle_PI);
        double rotate_angle = -angle_PI;
        if (angle > 90.0 && angle < 270.0) {
            rotate_angle = Math.PI - angle_PI;
            offset_x -= (double)str_len * Math.cos(rotate_angle);
            offset_y -= (double)str_len * Math.sin(rotate_angle);
        }
        offset_x += (double)font_height / 2.0 * Math.sin(-rotate_angle);
        offset_y += (double)font_height / 2.0 * Math.cos(-rotate_angle);
        AffineTransform at = new AffineTransform();
        at.translate(offset_x *= ratio, offset_y *= ratio);
        at.rotate(rotate_angle);
        Font rotatedFont = biggerFont.deriveFont(at);
        rotatedFont.deriveFont((float)((double)(g.getFont().getSize() * 1) * ratio));
        g.setFont(rotatedFont);
        g.drawString(str, 0, 0);
        g.setFont(oldFont);
    }

    void circos_drawString_radio_new1(Graphics2D g, double ratio, String str, double Radius, int center_x, int center_y, double angle, boolean outer) {
        double angle_PI = angle / 180.0 * Math.PI;
        Font oldFont = g.getFont();
        Font font = g.getFont();
        Font biggerFont = font.deriveFont((float)((double)(g.getFont().getSize() * 1) * ratio));
        g.setFont(biggerFont);
        int str_len = g.getFontMetrics().stringWidth(str);
        int font_height = g.getFontMetrics().getHeight();
        AffineTransform affineTransform1 = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        AffineTransform affineTransform3 = new AffineTransform();
        AffineTransform affineTransform4 = new AffineTransform();
        affineTransform1.translate(Radius, (double)font_height / 2.0);
        AffineTransform affineTransform = new AffineTransform();
        if (angle > 90.0 && angle < 270.0) {
            affineTransform.translate((-Radius - (double)str_len) * Math.cos(angle_PI), (double)font_height / 2.0);
            affineTransform.rotate(Math.toRadians(angle), 0.0, 0.0);
        } else {
            affineTransform2.rotate(-Math.toRadians(angle), 0.0, 0.0);
            affineTransform.translate(Radius, (double)font_height / 2.0);
            affineTransform.rotate(-Math.toRadians(angle), 0.0, 0.0);
        }
        affineTransform3.translate((double)center_x * Math.cos(angle_PI) - (double)center_y * Math.sin(angle_PI), (double)(-center_x) * Math.sin(angle_PI) + (double)center_y * Math.cos(angle_PI));
        affineTransform4.concatenate(affineTransform1);
        affineTransform4.concatenate(affineTransform2);
        affineTransform4.concatenate(affineTransform3);
        if (str.startsWith("2222222")) {
            boolean debug = false;
        }
        double[] ptSrc = new double[]{Radius, font_height / 2};
        double[] ptDst = new double[2];
        affineTransform.transform(ptSrc, 0, ptDst, 0, 1);
        affineTransform.translate((double)center_x - Radius / Math.cos(angle_PI), center_y);
        Font rotatedFont = font.deriveFont(affineTransform4);
        g.setFont(rotatedFont);
        g.drawString(str, 0, 0);
        g.setFont(oldFont);
    }

    void circos_drawString_radio(Graphics2D g, double ratio, String str, double Radius, int center_x, int center_y, double angle, boolean outer) {
        Font oldFont = g.getFont();
        Font font = g.getFont();
        Font biggerFont = font.deriveFont((float)((double)(g.getFont().getSize() * 1) * ratio));
        g.setFont(biggerFont);
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform tmp_affineTransform = g.getTransform();
        double R = Radius;
        double delta_x = 0.0;
        double delta_y = 0.0;
        int str_len = g.getFontMetrics().stringWidth(str);
        int font_height = g.getFontMetrics().getHeight();
        if (angle > 90.0 && angle < 270.0) {
            affineTransform.rotate(Math.PI - Math.toRadians(angle), 0.0, 0.0);
            if (outer) {
                R += (double)str_len;
            }
        } else {
            affineTransform.rotate(-Math.toRadians(angle), 0.0, 0.0);
            if (!outer) {
                R -= (double)str_len;
            }
        }
        Font rotatedFont = font.deriveFont(affineTransform);
        g.setFont(rotatedFont);
        double x = (double)center_x + R * Math.cos(angle / 180.0 * Math.PI) + delta_x;
        double y = (double)center_y - R * Math.sin(angle / 180.0 * Math.PI) - delta_y;
        g.drawString(str, (int)(x * ratio), (int)(y * ratio));
        g.setFont(oldFont);
    }

    void circos_drawString_flat_wornt(Graphics2D g, double ratio, String str, int Radius, int center_x, int center_y, float angle) {
        double angle_PI = (double)angle / 180.0 * Math.PI;
        Font oldFont = g.getFont();
        Font font = g.getFont();
        Font biggerFont = font.deriveFont((float)((double)(g.getFont().getSize() * 1) * ratio));
        int str_len = g.getFontMetrics().stringWidth(str);
        int font_height = g.getFontMetrics().getAscent();
        double offset_x = (double)center_x + (double)Radius * Math.cos(angle_PI);
        double offset_y = (double)center_y - (double)Radius * Math.sin(angle_PI);
        double rotate_angle = -1.5707963267948966 - angle_PI;
        if (angle > 90.0f && angle < 270.0f) {
            rotate_angle = 1.5707963267948966 - angle_PI;
            offset_x -= (double)str_len * Math.cos(rotate_angle);
            offset_y -= (double)str_len * Math.sin(rotate_angle);
        }
        if (angle > 270.0f) {
            rotate_angle = 1.5707963267948966 - angle_PI;
        }
        offset_x += (double)font_height / 2.0 * Math.sin(-rotate_angle);
        offset_y += (double)font_height / 2.0 * Math.cos(-rotate_angle);
        AffineTransform at = new AffineTransform(Math.cos(rotate_angle), Math.sin(rotate_angle), -Math.sin(rotate_angle), Math.cos(rotate_angle), offset_x *= ratio, offset_y *= ratio);
        Font rotatedFont = biggerFont.deriveFont(at);
        rotatedFont.deriveFont((float)((double)(g.getFont().getSize() * 1) * ratio));
        g.setFont(rotatedFont);
        g.drawString(str, 0, 0);
        g.setFont(oldFont);
    }

    void circos_drawString_flat(Graphics2D g, double ratio, String str, int Radius, int center_x, int center_y, float angle) {
        Font oldFont = g.getFont();
        int str_len = g.getFontMetrics().stringWidth(str);
        int str_height = g.getFontMetrics().getAscent() - g.getFontMetrics().getDescent();
        Font font = g.getFont();
        AffineTransform affineTransform = angle > 180.0f ? AffineTransform.getScaleInstance(-1.0, -1.0) : new AffineTransform();
        affineTransform.rotate(-Math.toRadians(angle - 90.0f), 0.0, 0.0);
        Font rotatedFont = font.deriveFont(affineTransform);
        Font biggerFont = rotatedFont.deriveFont((float)((double)g.getFont().getSize() * ratio));
        g.setFont(biggerFont);
        double ang = Math.toRadians(angle);
        AffineTransform at = new AffineTransform(Math.cos(ang), Math.sin(ang), -Math.sin(ang), Math.cos(ang), 0.0, 0.0);
        double[] ptSrc = new double[]{(double)Radius * ratio, (double)str_len * ratio / 2.0};
        if (angle > 180.0f) {
            ptSrc[0] = (double)(Radius += str_height) * ratio;
            ptSrc[1] = (double)(-str_len) * ratio / 2.0;
        }
        double[] ptDst = new double[2];
        at.transform(ptSrc, 0, ptDst, 0, 1);
        g.drawString(str, (int)((double)center_x * ratio + ptDst[0]), (int)((double)center_y * ratio - ptDst[1]));
        g.setFont(oldFont);
    }

    private void drawChrScale_modified_in_mac(Graphics2D g) {
        double accum_nt = 0.0;
        double start_angle = 0.0;
        g.drawRect(this.corner_x - 10, this.corner_y - 10, 20, 20);
        g.drawLine(this.center_x, this.center_y - 10, this.center_x, this.center_y + 10);
        g.drawLine(this.center_x - 10, this.center_y, this.center_x + 10, this.center_y);
        g.drawRect(this.center_x - 10, this.center_y - 10, 20, 20);
        int rec_no = 0;
        for (Chromosome chrom : Java_circos.chromosomeSize) {
            String chr = chrom.name;
            double increase_angle = (double)chrom.length / (double)Java_circos.whole_genome_nt * 360.0;
            this.drawString_on_cycle(g, this.center_x, this.center_y, this.radius + this.band_height / 2, start_angle + increase_angle / 2.0, chr.replace("chr", ""), Color.red);
            if (rec_no != 0) {
                g.drawArc(this.center_x - this.radius, this.center_y - this.radius, this.radius * 2, this.radius * 2, (int)start_angle, (int)(start_angle + increase_angle));
                g.drawArc(this.center_x - this.radius + this.band_height, this.center_y - this.radius + this.band_height, (this.radius - this.band_height) * 2, (this.radius - this.band_height) * 2, (int)start_angle, (int)(start_angle + increase_angle));
            }
            g.setColor(Color.red);
            int x1 = this.center_x + (int)((double)(this.radius - this.band_height) * Math.cos(start_angle * Math.PI / 180.0));
            int y1 = this.center_y - (int)((double)(this.radius - this.band_height) * Math.sin(start_angle * Math.PI / 180.0));
            int x2 = this.center_x + (int)((double)this.radius * Math.cos(start_angle * Math.PI / 180.0));
            int y2 = this.center_y - (int)((double)this.radius * Math.sin(start_angle * Math.PI / 180.0));
            g.drawLine(x1, y1, x2, y2);
            g.setColor(Color.green);
            x1 = this.center_x + (int)((double)(this.radius - this.band_height) * Math.cos((start_angle += increase_angle) * Math.PI / 180.0));
            y1 = this.center_y - (int)((double)(this.radius - this.band_height) * Math.sin(start_angle * Math.PI / 180.0));
            x2 = this.center_x + (int)((double)this.radius * Math.cos(start_angle * Math.PI / 180.0));
            y2 = this.center_y - (int)((double)this.radius * Math.sin(start_angle * Math.PI / 180.0));
            g.drawLine(x1, y1, x2, y2);
            if (++rec_no <= 1) continue;
        }
    }

    private void drawBridge(Graphics2D g, double ratio, int x_org, int y_org, int radius, Range[] ranges, String geneName, Color color) {
        if (ranges.length != 2) {
            System.out.println("ranges needs 2 and only 2 elements");
        }
        if (ranges[0].start > ranges[1].start) {
            System.out.println("the first one should smaller than second one");
        }
        if (ranges[0].start + ranges[0].len > ranges[1].start) {
            System.out.println("two ranges should not overlappedranges[0].start=" + ranges[0].start + "+ranges[0].len=" + ranges[0].len + ">ranges[1].start=" + ranges[1].start);
        }
        double startAngle1 = ranges[0].start * 360.0;
        double arcAngle1 = (ranges[1].start + ranges[1].len - ranges[0].start) * 360.0;
        double startAngle2 = (ranges[0].start + ranges[0].len) * 360.0;
        double arcAngle2 = (ranges[1].start - (ranges[0].start + ranges[0].len)) * 360.0;
        this.drawBridge(g, ratio, x_org, y_org, radius, startAngle1, arcAngle1, startAngle2, arcAngle2, geneName, color);
    }

    private void add_polgon(Polygon boundry, double[] current_point, double[] previous_point) {
        if (Math.abs(current_point[1] - previous_point[1]) > 2.0 || Math.abs(current_point[0] - previous_point[0]) > 2.0) {
            boundry.addPoint((int)current_point[0], (int)current_point[1]);
            previous_point[0] = current_point[0];
            previous_point[1] = current_point[1];
        }
    }

    private void drawBridge(Graphics2D g, double ratio, int x_org, int y_org, int radius, double startAngle1, double arcAngle1, double startAngle2, double arcAngle2, String geneName, Color color) {
        double[] ptDst;
        double[] ptSrc;
        double theta;
        AffineTransform transformer = new AffineTransform();
        transformer.translate(x_org, y_org);
        Polygon boundry = new Polygon();
        double step = (startAngle2 - startAngle1) / 1000.0;
        double[] previous_point = new double[]{-10.0, -10.0};
        double[] first_p = new double[]{-10.0, -10.0};
        if (step < 1.0E-7) {
            double[] ptSrc2 = new double[]{(double)radius * Math.cos(startAngle2 * Math.PI / 180.0), (double)(-radius) * Math.sin(startAngle2 * Math.PI / 180.0)};
            double[] ptDst2 = new double[2];
            transformer.transform(ptSrc2, 0, ptDst2, 0, 1);
            this.add_polgon(boundry, ptDst2, previous_point);
            first_p[0] = ptDst2[0];
            first_p[1] = ptDst2[1];
        } else {
            for (double angle = startAngle2 - 2.0 * step; angle > startAngle1 + 2.0 * step; angle -= step) {
                theta = angle * Math.PI / 180.0;
                ptSrc = new double[]{(double)radius * Math.cos(theta), (double)(-radius) * Math.sin(theta)};
                ptDst = new double[2];
                transformer.transform(ptSrc, 0, ptDst, 0, 1);
                this.add_polgon(boundry, ptDst, previous_point);
                if (!(first_p[0] < 0.0)) continue;
                first_p[0] = ptDst[0];
                first_p[1] = ptDst[1];
            }
        }
        this.drawBigCurve(g, x_org, y_org, radius, startAngle1, arcAngle1, boundry, previous_point);
        step = (startAngle1 + arcAngle1 - (startAngle2 + arcAngle2)) / 1000.0;
        if (step < 1.0E-7) {
            double start_theta = (startAngle1 + arcAngle1) * Math.PI / 180.0;
            double[] ptSrc3 = new double[]{(double)radius * Math.cos(start_theta), (double)(-radius) * Math.sin(start_theta)};
            double[] ptDst3 = new double[2];
            transformer.transform(ptSrc3, 0, ptDst3, 0, 1);
            this.add_polgon(boundry, ptDst3, previous_point);
        } else {
            for (double angle = startAngle1 + arcAngle1 + 2.0 * step; angle > startAngle2 + arcAngle2 + 2.0 * step; angle -= step) {
                theta = angle * Math.PI / 180.0;
                ptSrc = new double[]{(double)radius * Math.cos(theta), (double)(-radius) * Math.sin(theta)};
                ptDst = new double[2];
                transformer.transform(ptSrc, 0, ptDst, 0, 1);
                this.add_polgon(boundry, ptDst, previous_point);
            }
        }
        this.drawSmallCurve(g, x_org, y_org, radius, startAngle2, arcAngle2, boundry, previous_point, first_p);
        boundry.addPoint((int)first_p[0], (int)first_p[1]);
        g.setColor(color);
        g.fillPolygon(boundry);
        Stroke tmp_stroke = g.getStroke();
        g.setStroke(new BasicStroke((int)ratio));
        g.drawPolygon(boundry);
        g.setStroke(tmp_stroke);
        if (geneName.contains("chr19-chrX")) {
            boolean debug = false;
        }
    }

    private void drawCircosCurve(Graphics g, int x_org, int y_org, int radius, double startAngle, double arcAngle) {
        double width = (double)radius * Math.sin(arcAngle * Math.PI / 360.0);
        double dist = (double)radius * Math.cos(arcAngle * Math.PI / 360.0);
        double c = dist * this.bend_degree / 3.0;
        AffineTransform transformer = new AffineTransform();
        transformer.translate(x_org, y_org);
        double middle_angle = startAngle + arcAngle / 2.0;
        transformer.rotate((270.0 - middle_angle) * Math.PI / 180.0);
        double a = -c / (width * width);
        double step = 2.0 * width / 1000.0;
        ArrayList<Point> points = new ArrayList<Point>();
        for (double x = -width + 2.0 * step; x < width - 2.0 * step; x += step) {
            double y = dist - (a * x * x + c);
            double[] ptSrc = new double[]{x, y};
            double[] ptDst = new double[2];
            transformer.transform(ptSrc, 0, ptDst, 0, 1);
            points.add(new Point((int)ptDst[0], (int)ptDst[1]));
        }
        if (points.size() > 0) {
            int pre_x = ((Point)points.get((int)0)).x;
            int pre_y = ((Point)points.get((int)0)).y;
            for (int i = 1; i < points.size(); ++i) {
                g.drawLine(pre_x, pre_y, ((Point)points.get((int)i)).x, ((Point)points.get((int)i)).y);
                pre_x = ((Point)points.get((int)i)).x;
                pre_y = ((Point)points.get((int)i)).y;
            }
        }
    }

    private void drawBigCurve(Graphics g, int x_org, int y_org, int radius, double startAngle, double arcAngle, Polygon boundry, double[] previous_point) {
        double width = (double)radius * Math.sin(arcAngle * Math.PI / 360.0);
        double dist = (double)radius * Math.cos(arcAngle * Math.PI / 360.0);
        double c = dist * this.bend_degree / 3.0;
        AffineTransform transformer = new AffineTransform();
        transformer.translate(x_org, y_org);
        double middle_angle = startAngle + arcAngle / 2.0;
        transformer.rotate((270.0 - middle_angle) * Math.PI / 180.0);
        double a = -c / (width * width);
        double step = 2.0 * width / 1000.0;
        if (step < 1.0E-7) {
            double[][] tripple_ptSrc = new double[][]{{0.0, dist}, {0.0, dist - 2.0 * c}, {0.0, dist}};
            for (int i = 0; i < 3; ++i) {
                double[] ptDst = new double[2];
                transformer.transform(tripple_ptSrc[i], 0, ptDst, 0, 1);
            }
        } else {
            for (double x = -width + 2.0 * step; x < width - 2.0 * step; x += step) {
                double y = dist - (a * x * x + c);
                double[] ptSrc = new double[]{x, y};
                double[] ptDst = new double[2];
                transformer.transform(ptSrc, 0, ptDst, 0, 1);
                this.add_polgon(boundry, ptDst, previous_point);
            }
        }
    }

    private void drawSmallCurve(Graphics g, int x_org, int y_org, int radius, double startAngle, double arcAngle, Polygon boundry, double[] previous_point, double[] first_p) {
        double width = (double)radius * Math.sin(arcAngle * Math.PI / 360.0);
        double dist = (double)radius * Math.cos(arcAngle * Math.PI / 360.0);
        double c = dist * this.bend_degree / 3.0;
        AffineTransform transformer = new AffineTransform();
        transformer.translate(x_org, y_org);
        double middle_angle = startAngle + arcAngle / 2.0;
        transformer.rotate((270.0 - middle_angle) * Math.PI / 180.0);
        double a = -c / (width * width);
        double step = 2.0 * width / 1000.0;
        if (step < 1.0E-7) {
            double[][] tripple_ptSrc = new double[][]{{0.0, dist}, {0.0, dist - 2.0 * c}, {0.0, dist}};
            for (int i = 0; i < 3; ++i) {
                double[] ptDst = new double[2];
                transformer.transform(tripple_ptSrc[i], 0, ptDst, 0, 1);
                this.add_polgon(boundry, ptDst, previous_point);
            }
        } else {
            for (double x = width - 2.0 * step; x > -width + 3.0 * step; x -= step) {
                double y = dist - (a * x * x + c);
                double[] ptSrc = new double[]{x, y};
                double[] ptDst = new double[2];
                transformer.transform(ptSrc, 0, ptDst, 0, 1);
                if (!(Math.abs(first_p[1] - y) > 2.0) && !(Math.abs(first_p[0] - x) > 2.0)) continue;
                this.add_polgon(boundry, ptDst, previous_point);
            }
        }
    }

    private void drawString_on_cycle(Graphics2D g, int x_org, int y_org, int radius, double theta, String str, Color color) {
        g.setColor(color);
        int chr_string_width = g.getFontMetrics().stringWidth(str);
        int chr_string_height = g.getFontMetrics().getAscent();
        int x_offset_str = Math.abs((int)((double)chr_string_width * Math.cos(theta * Math.PI / 180.0))) - 7;
        int y_offset_str = Math.abs((int)((double)chr_string_height * Math.sin(theta * Math.PI / 180.0))) - 5;
        g.drawString(str, (int)((double)x_org + (double)radius * Math.cos(theta * Math.PI / 180.0)) - x_offset_str, (int)((double)y_org - (double)radius * Math.sin(theta * Math.PI / 180.0)) + y_offset_str);
        g.setColor(Color.black);
    }

    private void drawString(Graphics2D g, int x_org, int y_org, int radius, double theta, String str, Color color) {
        int Angle = (int)(theta * 360.0);
        g.setColor(color);
        Angle = (Angle + 180) % 360 - 180;
        g.translate(x_org, y_org);
        if (Angle <= 90 && Angle >= -90) {
            g.rotate(-Math.PI * (double)Angle / 180.0);
            g.translate(radius, 0);
            g.drawString(str, 0, 0);
            g.translate(-radius, 0);
            g.rotate(Math.PI * (double)Angle / 180.0);
        } else {
            g.rotate(Math.PI - Math.PI * (double)Angle / 180.0);
            g.translate(-radius, g.getFontMetrics().getAscent() / 2);
            g.drawString(str, -g.getFontMetrics().stringWidth(str), 0);
            g.translate(radius, -g.getFontMetrics().getAscent() / 2);
            g.rotate(-(Math.PI - Math.PI * (double)Angle / 180.0));
        }
        g.setColor(Color.black);
        g.translate(-x_org, -y_org);
    }

    private boolean on_line(int x1, int y1, int x2, int y2, int x, int y) {
        return (x - x1) * (x - x1) + (y - y1) * (y - y1) + (x - x2) * (x - x2) + (y - y2) * (y - y2) == (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    private void drawWiggle_wrong(Graphics2D g, int x_org, int y_org, int radius, int theta1, int theta2, int wigHeight, Color boundary_color, Color fill_color) {
        Color tmp_color = g.getColor();
        Stroke tmp = g.getStroke();
        g.setColor(Color.red);
        g.setStroke(new BasicStroke(wigHeight));
        int middle_R = radius + wigHeight / 2;
        double extra_angle = (double)(180 * wigHeight) / (Math.PI * (double)middle_R);
        double adjust_start = (double)theta1 + extra_angle / 2.0;
        double len = (double)(theta2 - theta1) - extra_angle;
        g.draw(new Arc2D.Double(x_org - middle_R, y_org - middle_R, 2.0 * (double)middle_R, 2.0 * (double)middle_R, adjust_start, len, 0));
        g.setStroke(tmp);
        g.setColor(tmp_color);
    }

    private void drawWiggle_slow(Graphics2D g, int x_org, int y_org, int radius, int theta1, int theta2, int wigHeight, Color boundary_color, Color fill_color) {
        Polygon s = new Polygon();
        int small_radius = radius;
        int x = (int)((double)x_org + (double)small_radius * Math.cos((double)theta1 / 180.0 * Math.PI));
        int y = (int)((double)y_org - (double)small_radius * Math.sin((double)theta1 / 180.0 * Math.PI));
        double step = 1.0 / (double)small_radius;
        for (double i = (double)theta1; i <= (double)theta2; i += step) {
            int x2 = (int)((double)x_org + (double)small_radius * Math.cos(i / 180.0 * Math.PI));
            int y2 = (int)((double)y_org - (double)small_radius * Math.sin(i / 180.0 * Math.PI));
            s.addPoint(x, y);
            x = x2;
            y = y2;
        }
        int radius1 = radius + wigHeight;
        step = 1.0 / (double)radius1;
        for (double i = (double)theta2; i >= (double)theta1; i -= step) {
            double t = i / 360.0;
            int x2 = (int)((double)x_org + (double)radius1 * Math.cos(2.0 * t * Math.PI));
            int y2 = (int)((double)y_org - (double)radius1 * Math.sin(2.0 * t * Math.PI));
            s.addPoint(x, y);
            x = x2;
            y = y2;
        }
        s.addPoint(x, y);
        g.setColor(fill_color);
        g.fillPolygon(s);
        g.setColor(boundary_color);
        g.drawPolygon(s);
    }

    private void drawWiggle_old(Graphics g, int x_org, int y_org, int radius, Range r, int wigHeight, Color color) {
        double startAngle = r.start * 360.0;
        double arcAngle = r.len * 360.0;
        Polygon s = new Polygon();
        int x = (int)((double)x_org + (double)radius * Math.cos(startAngle / 180.0 * Math.PI));
        int y = (int)((double)y_org - (double)radius * Math.sin(startAngle / 180.0 * Math.PI));
        for (double i = startAngle; i <= startAngle + arcAngle; i += 0.01) {
            int x2 = (int)((double)x_org + (double)radius * Math.cos(i / 180.0 * Math.PI));
            int y2 = (int)((double)y_org - (double)radius * Math.sin(i / 180.0 * Math.PI));
            s.addPoint(x, y);
            x = x2;
            y = y2;
        }
        int radius1 = radius + wigHeight;
        for (double i = startAngle + arcAngle; i >= startAngle; i -= 0.01) {
            double t = i / 360.0;
            int x2 = (int)((double)x_org + (double)radius1 * Math.cos(2.0 * t * Math.PI));
            int y2 = (int)((double)y_org - (double)radius1 * Math.sin(2.0 * t * Math.PI));
            s.addPoint(x, y);
            x = x2;
            y = y2;
        }
        s.addPoint(x, y);
        g.setColor(color);
        g.fillPolygon(s);
        g.setColor(Color.BLACK);
        g.drawPolygon(s);
    }
}

