/*
 * Decompiled with CFR 0.152.
 */
package java_circos;

import java.awt.Cursor;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java_circos.Java_circos;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;

public class StartPoint_JNLP
extends JFrame
implements PropertyChangeListener {
    static JFrame genomeFrame;
    static String JavaVersion;
    JFrame jFrame = new JFrame(){
        {
            this.setUndecorated(true);
            this.setLayout((LayoutManager)new MigLayout("", "[grow]"));
            this.setTitle("process bar");
            StartPoint_JNLP.this.jlabel = new JLabel("Downloading demo data");
            this.add(StartPoint_JNLP.this.jlabel);
            StartPoint_JNLP.this.bar = new JProgressBar();
            this.add(StartPoint_JNLP.this.bar);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setAlwaysOnTop(true);
            this.setVisible(true);
        }
    };
    JProgressBar bar;
    static String data_folder;
    boolean download_success = false;
    JLabel jlabel;

    StartPoint_JNLP() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String[] filenames = new String[]{"demo_text", "demo_label", "demo_Circos_bridge", "demo_Circos_bridge_genefusion_from_Defuse.txt", "demo_Circos_wiggle", "demo_UCSC_bed_miRNAs.bed", "demo_UCSC_BigBed_miRNAs.bb", "demo_UCSC_wiggle.minus.bw", "demo_UCSC_wiggle.plus.bw", "hg19.chrom.sizes", "cytogenetic_hg19/cytogenetic", "cytogenetic_hg19/value.txt"};
            Task task = new Task(filenames);
            task.addPropertyChangeListener(this);
            task.execute();
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.bar.setValue(progress);
        }
    }

    public static boolean removeDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        if (!directory.exists()) {
            return true;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        String[] list = directory.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(directory, list[i]);
                if (!(entry.isDirectory() ? !StartPoint_JNLP.removeDirectory(entry) : !entry.delete())) continue;
                return false;
            }
        }
        return directory.delete();
    }

    private static boolean need_download_data_and_remove_existing_folder() {
        try {
            data_folder = System.getProperty("user.dir").replace("\\", "/") + "/.JCircos_data/";
            if (new File(data_folder).exists()) {
                if (new File("Data").exists()) {
                    Date createdDate = new Date(new File("Data").lastModified());
                    Date revisedDate = new SimpleDateFormat("MM/dd/yyyy").parse("09/10/2014");
                    String tmp_str = "current \"Data\" directory was created on " + createdDate.toString();
                    if (createdDate.before(revisedDate)) {
                        StartPoint_JNLP.removeDirectory(new File(data_folder));
                        return true;
                    }
                    int response = JOptionPane.showConfirmDialog(null, "The initial files have been downloaded\n Do you want skip?", "Confirm", 0, 3);
                    if (response == 1) {
                        StartPoint_JNLP.removeDirectory(new File(data_folder));
                        return true;
                    }
                    return false;
                }
                StartPoint_JNLP.removeDirectory(new File(data_folder));
                return true;
            }
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public static void main(String[] args) {
        if (StartPoint_JNLP.need_download_data_and_remove_existing_folder()) {
            if (!new File(data_folder).mkdir()) {
                String tmp = "fail in creating " + data_folder;
                data_folder = System.getProperty("user.home").replace("\\", "/") + "/.JCircos_data/";
                tmp = "data_folder=" + data_folder + " is replaced";
                new File(data_folder).mkdir();
            }
            StartPoint_JNLP.create_sub_folder();
            StartPoint_JNLP startPoint_JNLP = new StartPoint_JNLP();
        } else {
            StartPoint_JNLP.start_genome();
        }
    }

    private static void create_sub_folder() {
        String new_folder1;
        String new_folder = data_folder + "Data/";
        if (!new File(new_folder).exists()) {
            new File(new_folder).mkdir();
        }
        if (!new File(new_folder1 = data_folder + "Data/cytogenetic_hg19").exists()) {
            new File(new_folder1).mkdir();
        }
    }

    static void start_genome() {
        try {
            Java_circos frame = new Java_circos(data_folder + "Data/", "hg19.chrom.sizes", 200, 50, 50);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            Logger.getLogger(Java_circos.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        JavaVersion = "1.7.0_23";
    }

    class Task
    extends SwingWorker<Void, Void> {
        String[] filenames;

        public Task(String[] filenames) {
            this.filenames = new String[filenames.length];
            this.filenames = Arrays.copyOf(filenames, filenames.length);
        }

        @Override
        public Void doInBackground() {
            try {
                for (int i = 0; i < this.filenames.length; ++i) {
                    String string = this.transfer_file(data_folder + "Data/", this.filenames[i]);
                }
                StartPoint_JNLP.this.download_success = true;
            }
            catch (Exception ex) {
                StartPoint_JNLP.this.download_success = false;
                System.err.println("error in transfer_file: " + ex.toString());
            }
            return null;
        }

        @Override
        public void done() {
            StartPoint_JNLP.this.jFrame.dispose();
            StartPoint_JNLP.this.setCursor(null);
            if (StartPoint_JNLP.this.download_success) {
                StartPoint_JNLP.start_genome();
            } else {
                JOptionPane.showMessageDialog(null, "download failed");
            }
        }

        private String transfer_file(String local_path, String filename) {
            try {
                int bytesRead;
                int blockSize = 81920;
                byte[] buffer = new byte[blockSize];
                URL url = new URL("http://data.australianprostatecentre.org/RNAseq/J-Circos/Data/" + filename);
                BufferedInputStream inputStream = null;
                BufferedOutputStream outputStream = null;
                URLConnection connection = url.openConnection();
                double fileSize = (double)connection.getContentLength() / (double)blockSize;
                inputStream = new BufferedInputStream(connection.getInputStream(), blockSize);
                File f = new File(local_path + "/" + filename);
                double finished_size = 0.0;
                outputStream = new BufferedOutputStream(new FileOutputStream(f));
                StartPoint_JNLP.this.jlabel.setText(filename);
                this.setProgress(0);
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    int ratio = (int)(100.0 * ((finished_size += (double)bytesRead / (double)blockSize) / fileSize));
                    if (ratio > 100) {
                        ratio = 100;
                    }
                    if (ratio < 0) {
                        ratio = 0;
                    }
                    this.setProgress(ratio);
                }
                inputStream.close();
                outputStream.close();
                return "success";
            }
            catch (IOException ex) {
                System.err.println(ex.toString());
                return "failure";
            }
        }
    }
}

